/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.AbstractSTSClient;
import org.apache.cxf.ws.security.trust.TrustException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STSClient
extends AbstractSTSClient {
    private static final Logger LOG = LogUtils.getL7dLogger(STSClient.class);

    public STSClient(Bus b) {
        super(b);
    }

    public SecurityToken requestSecurityToken() throws Exception {
        return this.requestSecurityToken(null);
    }

    public SecurityToken requestSecurityToken(String appliesTo) throws Exception {
        return this.requestSecurityToken(appliesTo, null);
    }

    public SecurityToken requestSecurityToken(String appliesTo, String binaryExchange) throws Exception {
        return this.requestSecurityToken(appliesTo, null, "/Issue", binaryExchange);
    }

    public SecurityToken requestSecurityToken(String appliesTo, String action, String requestType, String binaryExchange) throws Exception {
        AbstractSTSClient.STSResponse response = this.issue(appliesTo, action, requestType, binaryExchange);
        SecurityToken token = this.createSecurityToken(this.getDocumentElement(response.getResponse()), response.getEntropy());
        if (response.getCert() != null) {
            token.setX509Certificate(response.getCert(), response.getCrypto());
        }
        if (token.getTokenType() == null) {
            String tokenTypeFromTemplate = this.getTokenTypeFromTemplate();
            if (tokenTypeFromTemplate != null) {
                token.setTokenType(tokenTypeFromTemplate);
            } else if (this.tokenType != null) {
                token.setTokenType(this.tokenType);
            }
        }
        return token;
    }

    public SecurityToken renewSecurityToken(SecurityToken tok) throws Exception {
        AbstractSTSClient.STSResponse response = this.renew(tok);
        SecurityToken token = this.createSecurityToken(this.getDocumentElement(response.getResponse()), null);
        if (token.getTokenType() == null) {
            String tokenTypeFromTemplate = this.getTokenTypeFromTemplate();
            if (tokenTypeFromTemplate != null) {
                token.setTokenType(tokenTypeFromTemplate);
            } else if (this.tokenType != null) {
                token.setTokenType(this.tokenType);
            }
        }
        return token;
    }

    public List<SecurityToken> validateSecurityToken(SecurityToken tok) throws Exception {
        String validateTokenType = this.tokenType;
        if (validateTokenType == null) {
            validateTokenType = this.namespace + "/RSTR/Status";
        }
        return this.validateSecurityToken(tok, validateTokenType);
    }

    protected List<SecurityToken> validateSecurityToken(SecurityToken tok, String tokentype) throws Exception {
        AbstractSTSClient.STSResponse response = this.validate(tok, tokentype);
        Element el = this.getDocumentElement(response.getResponse());
        if ("RequestSecurityTokenResponseCollection".equals(el.getLocalName())) {
            el = DOMUtils.getFirstElement((Node)el);
        }
        if (!"RequestSecurityTokenResponse".equals(el.getLocalName())) {
            throw new Fault("Unexpected element " + el.getLocalName(), LOG);
        }
        el = DOMUtils.getFirstElement((Node)el);
        String reason = null;
        boolean valid = false;
        LinkedList<SecurityToken> tokens = new LinkedList<SecurityToken>();
        while (el != null) {
            if ("Status".equals(el.getLocalName())) {
                Element e2 = DOMUtils.getFirstChildWithName((Element)el, (String)el.getNamespaceURI(), (String)"Code");
                String s = DOMUtils.getContent((Node)e2);
                valid = s.endsWith("/status/valid");
                e2 = DOMUtils.getFirstChildWithName((Element)el, (String)el.getNamespaceURI(), (String)"Reason");
                if (e2 != null) {
                    reason = DOMUtils.getContent((Node)e2);
                }
            } else if ("RequestedSecurityToken".equals(el.getLocalName())) {
                SecurityToken token = this.createSecurityToken(this.getDocumentElement(response.getResponse()), response.getEntropy());
                if (response.getCert() != null) {
                    token.setX509Certificate(response.getCert(), response.getCrypto());
                }
                if (token.getTokenType() == null) {
                    String tokenTypeFromTemplate = this.getTokenTypeFromTemplate();
                    if (tokenTypeFromTemplate != null) {
                        token.setTokenType(tokenTypeFromTemplate);
                    } else if (this.tokenType != null) {
                        token.setTokenType(this.tokenType);
                    }
                }
                tokens.add(token);
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        if (!valid) {
            throw new TrustException(LOG, "VALIDATION_FAILED", reason);
        }
        if (tokens.isEmpty()) {
            tokens.add(tok);
        }
        return tokens;
    }

    public boolean cancelSecurityToken(SecurityToken token) throws Exception {
        try {
            this.cancel(token);
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem cancelling token", ex);
            return false;
        }
    }

    private String getTokenTypeFromTemplate() {
        if (this.template != null && DOMUtils.getFirstElement((Node)this.template) != null) {
            Element tl = DOMUtils.getFirstElement((Node)this.template);
            while (tl != null) {
                if ("TokenType".equals(tl.getLocalName())) {
                    return DOMUtils.getContent((Node)tl);
                }
                tl = DOMUtils.getNextElement((Element)tl);
            }
        }
        return null;
    }
}

