/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.HandlerMethodSelector;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandlerComposite;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractMethodMessageHandler<T>
implements MessageHandler,
ApplicationContextAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Collection<String> destinationPrefixes = new ArrayList<String>();
    private final List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(4);
    private final List<HandlerMethodReturnValueHandler> customReturnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>(4);
    private HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
    private ApplicationContext applicationContext;
    private final Map<T, HandlerMethod> handlerMethods = new LinkedHashMap<T, HandlerMethod>();
    private final MultiValueMap<String, T> destinationLookup = new LinkedMultiValueMap();
    private final Map<Class<?>, AbstractExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);

    public void setDestinationPrefixes(Collection<String> prefixes) {
        this.destinationPrefixes.clear();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                prefix = prefix.trim();
                this.destinationPrefixes.add(prefix);
            }
        }
    }

    public Collection<String> getDestinationPrefixes() {
        return this.destinationPrefixes;
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> customArgumentResolvers) {
        this.customArgumentResolvers.clear();
        if (customArgumentResolvers != null) {
            this.customArgumentResolvers.addAll(customArgumentResolvers);
        }
    }

    public List<HandlerMethodArgumentResolver> getCustomArgumentResolvers() {
        return this.customArgumentResolvers;
    }

    public void setCustomReturnValueHandlers(List<HandlerMethodReturnValueHandler> customReturnValueHandlers) {
        this.customReturnValueHandlers.clear();
        if (customReturnValueHandlers != null) {
            this.customReturnValueHandlers.addAll(customReturnValueHandlers);
        }
    }

    public List<HandlerMethodReturnValueHandler> getCustomReturnValueHandlers() {
        return this.customReturnValueHandlers;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (argumentResolvers == null) {
            this.argumentResolvers.clear();
            return;
        }
        this.argumentResolvers.addResolvers(argumentResolvers);
    }

    public List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers.getResolvers();
    }

    public void setReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        if (returnValueHandlers == null) {
            this.returnValueHandlers.clear();
            return;
        }
        this.returnValueHandlers.addHandlers(returnValueHandlers);
    }

    public List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        return this.returnValueHandlers.getReturnValueHandlers();
    }

    public Map<T, HandlerMethod> getHandlerMethods() {
        return Collections.unmodifiableMap(this.handlerMethods);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() {
        if (this.argumentResolvers.getResolvers().isEmpty()) {
            this.argumentResolvers.addResolvers(this.initArgumentResolvers());
        }
        if (this.returnValueHandlers.getReturnValueHandlers().isEmpty()) {
            this.returnValueHandlers.addHandlers(this.initReturnValueHandlers());
        }
        for (String beanName : this.applicationContext.getBeanNamesForType(Object.class)) {
            if (!this.isHandler(this.applicationContext.getType(beanName))) continue;
            this.detectHandlerMethods(beanName);
        }
    }

    protected abstract List<? extends HandlerMethodArgumentResolver> initArgumentResolvers();

    protected abstract List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers();

    protected abstract boolean isHandler(Class<?> var1);

    protected final void detectHandlerMethods(Object handler) {
        Class handlerType = handler instanceof String ? this.applicationContext.getType((String)handler) : handler.getClass();
        final Class userType = ClassUtils.getUserClass((Class)handlerType);
        Set<Method> methods = HandlerMethodSelector.selectMethods(userType, new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AbstractMethodMessageHandler.this.getMappingForMethod(method, userType) != null;
            }
        });
        for (Method method : methods) {
            T mapping = this.getMappingForMethod(method, userType);
            this.registerHandlerMethod(handler, method, mapping);
        }
    }

    protected abstract T getMappingForMethod(Method var1, Class<?> var2);

    protected void registerHandlerMethod(Object handler, Method method, T mapping) {
        HandlerMethod newHandlerMethod = this.createHandlerMethod(handler, method);
        HandlerMethod oldHandlerMethod = this.handlerMethods.get(mapping);
        if (oldHandlerMethod != null && !oldHandlerMethod.equals(newHandlerMethod)) {
            throw new IllegalStateException("Ambiguous mapping found. Cannot map '" + newHandlerMethod.getBean() + "' bean method \n" + newHandlerMethod + "\nto " + mapping + ": There is already '" + oldHandlerMethod.getBean() + "' bean method\n" + oldHandlerMethod + " mapped.");
        }
        this.handlerMethods.put(mapping, newHandlerMethod);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Mapped \"" + mapping + "\" onto " + newHandlerMethod));
        }
        for (String pattern : this.getDirectLookupDestinations(mapping)) {
            this.destinationLookup.add((Object)pattern, mapping);
        }
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method) {
        HandlerMethod handlerMethod;
        if (handler instanceof String) {
            String beanName = (String)handler;
            handlerMethod = new HandlerMethod(beanName, (BeanFactory)this.applicationContext.getAutowireCapableBeanFactory(), method);
        } else {
            handlerMethod = new HandlerMethod(handler, method);
        }
        return handlerMethod;
    }

    protected abstract Set<String> getDirectLookupDestinations(T var1);

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        String destination = this.getDestination(message);
        if (destination == null) {
            return;
        }
        String lookupDestination = this.getLookupDestination(destination);
        if (lookupDestination == null) {
            return;
        }
        MessageHeaderAccessor headerAccessor = MessageHeaderAccessor.getMutableAccessor(message);
        headerAccessor.setHeader("lookupDestination", lookupDestination);
        headerAccessor.setLeaveMutable(true);
        message = MessageBuilder.createMessage(message.getPayload(), headerAccessor.getMessageHeaders());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching methods to handle " + headerAccessor.getShortLogMessage(message.getPayload())));
        }
        this.handleMessageInternal(message, lookupDestination);
        headerAccessor.setImmutable();
    }

    protected abstract String getDestination(Message<?> var1);

    protected String getLookupDestination(String destination) {
        if (destination == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.destinationPrefixes)) {
            return destination;
        }
        for (String prefix : this.destinationPrefixes) {
            if (!destination.startsWith(prefix)) continue;
            return destination.substring(prefix.length());
        }
        return null;
    }

    protected void handleMessageInternal(Message<?> message, String lookupDestination) {
        Match secondBestMatch;
        ArrayList<Match> matches = new ArrayList<Match>();
        List mappingsByUrl = (List)this.destinationLookup.get((Object)lookupDestination);
        if (mappingsByUrl != null) {
            this.addMatchesToCollection(mappingsByUrl, message, matches);
        }
        if (matches.isEmpty()) {
            Set<T> allMappings = this.handlerMethods.keySet();
            this.addMatchesToCollection(allMappings, message, matches);
        }
        if (matches.isEmpty()) {
            this.handleNoMatch(this.handlerMethods.keySet(), lookupDestination, message);
            return;
        }
        MatchComparator comparator = new MatchComparator(this.getMappingComparator(message));
        Collections.sort(matches, comparator);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Found " + matches.size() + " methods: " + matches));
        }
        Match bestMatch = (Match)matches.get(0);
        if (matches.size() > 1 && comparator.compare(bestMatch, secondBestMatch = (Match)matches.get(1)) == 0) {
            Method m1 = bestMatch.handlerMethod.getMethod();
            Method m2 = secondBestMatch.handlerMethod.getMethod();
            throw new IllegalStateException("Ambiguous handler methods mapped for destination '" + lookupDestination + "': {" + m1 + ", " + m2 + "}");
        }
        this.handleMatch(bestMatch.mapping, bestMatch.handlerMethod, lookupDestination, message);
    }

    private void addMatchesToCollection(Collection<T> mappingsToCheck, Message<?> message, List<Match> matches) {
        for (T mapping : mappingsToCheck) {
            T match = this.getMatchingMapping(mapping, message);
            if (match == null) continue;
            matches.add(new Match(match, this.handlerMethods.get(mapping)));
        }
    }

    protected abstract T getMatchingMapping(T var1, Message<?> var2);

    protected abstract Comparator<T> getMappingComparator(Message<?> var1);

    protected void handleMatch(T mapping, HandlerMethod handlerMethod, String lookupDestination, Message<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking " + handlerMethod.getShortLogMessage()));
        }
        handlerMethod = handlerMethod.createWithResolvedBean();
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod);
        invocable.setMessageMethodArgumentResolvers(this.argumentResolvers);
        try {
            Object returnValue = invocable.invoke(message, new Object[0]);
            MethodParameter returnType = handlerMethod.getReturnType();
            if (Void.TYPE.equals(returnType.getParameterType())) {
                return;
            }
            this.returnValueHandlers.handleReturnValue(returnValue, returnType, message);
        }
        catch (Exception ex) {
            this.processHandlerMethodException(handlerMethod, ex, message);
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Error while processing message " + message), ex);
        }
    }

    protected void processHandlerMethodException(HandlerMethod handlerMethod, Exception ex, Message<?> message) {
        Method method;
        Class<?> beanType;
        AbstractExceptionHandlerMethodResolver resolver;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching methods to handle " + ex.getClass().getSimpleName()));
        }
        if ((resolver = this.exceptionHandlerCache.get(beanType = handlerMethod.getBeanType())) == null) {
            resolver = this.createExceptionHandlerMethodResolverFor(beanType);
            this.exceptionHandlerCache.put(beanType, resolver);
        }
        if ((method = resolver.resolveMethod(ex)) == null) {
            this.logger.error((Object)"Unhandled exception", (Throwable)ex);
            return;
        }
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod.getBean(), method);
        invocable.setMessageMethodArgumentResolvers(this.argumentResolvers);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking " + invocable.getShortLogMessage()));
        }
        try {
            Object returnValue = invocable.invoke(message, ex);
            MethodParameter returnType = invocable.getReturnType();
            if (Void.TYPE.equals(returnType.getParameterType())) {
                return;
            }
            this.returnValueHandlers.handleReturnValue(returnValue, returnType, message);
        }
        catch (Throwable ex2) {
            this.logger.error((Object)"Error while processing handler method exception", ex2);
        }
    }

    protected abstract AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> var1);

    protected void handleNoMatch(Set<T> ts, String lookupDestination, Message<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No matching methods.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[prefixes=" + this.getDestinationPrefixes() + "]";
    }

    private class MatchComparator
    implements Comparator<Match> {
        private final Comparator<T> comparator;

        public MatchComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match match1, Match match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }

    private class Match {
        private final T mapping;
        private final HandlerMethod handlerMethod;

        private Match(T mapping, HandlerMethod handlerMethod) {
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }
}

