/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.file.FileComponent;
import org.apache.servicemix.file.FileEndpointType;
import org.apache.servicemix.util.FileUtil;

public class FileSenderEndpoint
extends ProviderEndpoint
implements FileEndpointType {
    private File directory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    @Deprecated
    private String tempFilePrefix = "servicemix-";
    @Deprecated
    private String tempFileSuffix = ".xml";
    private boolean autoCreateDirectory = true;
    private boolean append = false;
    private boolean overwrite;

    public FileSenderEndpoint() {
    }

    public FileSenderEndpoint(FileComponent component, ServiceEndpoint endpoint) {
        super((DefaultComponent)component, endpoint);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.directory == null) {
            throw new DeploymentException("You must specify the directory property");
        }
        if (this.isAutoCreateDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new DeploymentException("The directory property must be a directory but was: " + this.directory);
        }
        if (this.isOverwrite() && this.isAppend()) {
            throw new DeploymentException("You can't have 'append' and 'overwrite' active at the same time.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        block38: {
            block41: {
                block30: {
                    out = null;
                    newFile = null;
                    name = null;
                    writeTempName = null;
                    success = false;
                    try {
                        name = this.marshaler.getOutputName(exchange, in);
                        if (name == null) {
                            newFile = File.createTempFile("" + System.currentTimeMillis(), "tmp", this.directory);
                        } else {
                            newFile = new File(this.directory, name);
                            if (newFile.exists()) {
                                if (this.isOverwrite()) {
                                    newFile.delete();
                                } else if (!this.isAppend()) {
                                    newFile = null;
                                    throw new IOException("Can not write " + name + " : file already exists and overwrite has not been enabled");
                                }
                            }
                            writeTempName = this.marshaler.getTempOutputName(exchange, in) != null ? this.marshaler.getTempOutputName(exchange, in) : name;
                            newFile = new File(this.directory, writeTempName);
                        }
                        if (!newFile.getParentFile().exists() && this.isAutoCreateDirectory()) {
                            newFile.getParentFile().mkdirs();
                        }
                        FileSenderEndpoint.logger.debug("Writing to file: {}", (Object)newFile.getCanonicalPath());
                        out = new BufferedOutputStream(new FileOutputStream(newFile, this.append));
                        this.marshaler.writeMessage(exchange, in, out, name);
                        success = true;
                        var9_8 = null;
                        if (out == null) break block30;
                    }
                    catch (Throwable var8_30) {
                        block35: {
                            block37: {
                                var9_9 = null;
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException e) {
                                        FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                                    }
                                }
                                if (!success) break block35;
                                if (name == null) throw var8_30;
                                if (name.equals(newFile.getName()) != false) throw var8_30;
                                if (!this.isAppend()) {
                                    if (newFile.renameTo(new File(this.directory, name)) != false) throw var8_30;
                                    throw new IOException("File " + newFile.getName() + " could not be renamed to " + name);
                                }
                                targetFile = new File(this.directory, name);
                                bis = new BufferedInputStream(new FileInputStream(newFile));
                                out = new BufferedOutputStream(new FileOutputStream(targetFile, this.append));
                                try {
                                    try {
                                        FileUtil.copyInputStream((InputStream)bis, (OutputStream)out);
                                    }
                                    catch (IOException ioex) {
                                        FileSenderEndpoint.logger.error("Unable to append to file {}", (Object)targetFile.getName(), (Object)ioex);
                                        var14_18 = null;
                                        try {
                                            out.close();
                                        }
                                        catch (IOException e) {
                                            FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                                        }
                                        if (newFile.delete() != false) throw var8_30;
                                        throw new IOException("File " + newFile.getName() + " could not be deleted...");
                                    }
                                    var14_17 = null;
                                }
                                catch (Throwable var13_29) {
                                    block36: {
                                        var14_19 = null;
                                        ** try [egrp 4[TRYBLOCK] [7 : 453->460)] { 
lbl75:
                                        // 1 sources

                                        out.close();
                                        break block36;
lbl77:
                                        // 1 sources

                                        catch (IOException e) {
                                            FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                                        }
                                    }
                                    if (newFile.delete() != false) throw var13_29;
                                    throw new IOException("File " + newFile.getName() + " could not be deleted...");
                                }
                                ** try [egrp 4[TRYBLOCK] [7 : 453->460)] { 
lbl84:
                                // 1 sources

                                out.close();
                                break block37;
lbl86:
                                // 1 sources

                                catch (IOException e) {
                                    FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                                }
                            }
                            if (newFile.delete() != false) throw var8_30;
                            throw new IOException("File " + newFile.getName() + " could not be deleted...");
                        }
                        if (newFile != null) {
                            FileSenderEndpoint.logger.error("An error occured while writing file {}, deleting the invalid file", (Object)newFile.getCanonicalPath());
                            if (newFile.delete() != false) throw var8_30;
                            FileSenderEndpoint.logger.warn("Unable to delete file {} after an error had occured", (Object)newFile.getCanonicalPath());
                            throw var8_30;
                        }
                        FileSenderEndpoint.logger.error("An error occured while creating file or creating name of this file");
                        throw var8_30;
                    }
                    ** try [egrp 1[TRYBLOCK] [2 : 299->306)] { 
lbl100:
                    // 1 sources

                    out.close();
                    break block30;
lbl102:
                    // 1 sources

                    catch (IOException e) {
                        FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                    }
                }
                if (!success) break block38;
                if (name == null) return;
                if (name.equals(newFile.getName()) != false) return;
                if (!this.isAppend()) {
                    if (newFile.renameTo(new File(this.directory, name)) != false) return;
                    throw new IOException("File " + newFile.getName() + " could not be renamed to " + name);
                }
                targetFile = new File(this.directory, name);
                bis = new BufferedInputStream(new FileInputStream(newFile));
                out = new BufferedOutputStream(new FileOutputStream(targetFile, this.append));
                try {}
                catch (Throwable var13_28) {
                    block39: {
                        var14_16 = null;
                        ** try [egrp 4[TRYBLOCK] [7 : 453->460)] { 
lbl119:
                        // 1 sources

                        out.close();
                        break block39;
lbl121:
                        // 1 sources

                        catch (IOException e) {
                            FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                        }
                    }
                    if (newFile.delete() != false) throw var13_28;
                    throw new IOException("File " + newFile.getName() + " could not be deleted...");
                }
                try {}
                catch (IOException ioex) {
                    block40: {
                        FileSenderEndpoint.logger.error("Unable to append to file {}", (Object)targetFile.getName(), (Object)ioex);
                        var14_15 = null;
                        ** try [egrp 4[TRYBLOCK] [7 : 453->460)] { 
lbl132:
                        // 1 sources

                        out.close();
                        break block40;
lbl134:
                        // 1 sources

                        catch (IOException e) {
                            FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                        }
                    }
                    if (newFile.delete() != false) return;
                    throw new IOException("File " + newFile.getName() + " could not be deleted...");
                }
                FileUtil.copyInputStream((InputStream)bis, (OutputStream)out);
                var14_14 = null;
                ** try [egrp 4[TRYBLOCK] [7 : 453->460)] { 
lbl144:
                // 1 sources

                out.close();
                break block41;
lbl146:
                // 1 sources

                catch (IOException e) {
                    FileSenderEndpoint.logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                }
            }
            if (newFile.delete() != false) return;
            throw new IOException("File " + newFile.getName() + " could not be deleted...");
        }
        if (newFile != null) {
            FileSenderEndpoint.logger.error("An error occured while writing file {}, deleting the invalid file", (Object)newFile.getCanonicalPath());
            if (newFile.delete() != false) return;
            FileSenderEndpoint.logger.warn("Unable to delete file {} after an error had occured", (Object)newFile.getCanonicalPath());
            return;
        }
        FileSenderEndpoint.logger.error("An error occured while creating file or creating name of this file");
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        super.processInOut(exchange, in, out);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    @Deprecated
    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    @Deprecated
    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    @Deprecated
    public void setTempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
    }

    @Deprecated
    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }
}

