/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingscaling;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.shardingsphere.shardingscaling.core.config.ScalingContext;
import org.apache.shardingsphere.shardingscaling.core.config.ServerConfiguration;
import org.apache.shardingsphere.shardingscaling.utils.RuntimeUtil;
import org.apache.shardingsphere.shardingscaling.web.HttpServerInitializer;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private static final String DEFAULT_CONFIG_PATH = "/conf/";
    private static final String DEFAULT_CONFIG_FILE_NAME = "server.yaml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        log.info("Init server config");
        Bootstrap.initServerConfig();
        log.info("ShardingScaling Startup");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new HttpServerInitializer());
            int port = ScalingContext.getInstance().getServerConfiguration().getPort();
            Channel channel = bootstrap.bind(port).sync().channel();
            log.info("ShardingScaling is server on http://127.0.0.1:" + port + '/');
            channel.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    private static void initServerConfig() throws IOException {
        File yamlFile = new File(RuntimeUtil.getResourcePath("/conf/server.yaml"));
        ServerConfiguration serverConfiguration = (ServerConfiguration)YamlEngine.unmarshal((File)yamlFile, ServerConfiguration.class);
        Preconditions.checkNotNull((Object)serverConfiguration, (String)"Server configuration file `%s` is invalid.", (Object[])new Object[]{yamlFile.getName()});
        ScalingContext.getInstance().init(serverConfiguration);
    }
}

