/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingscaling.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.shardingscaling.core.ShardingScalingJob;
import org.apache.shardingsphere.shardingscaling.core.config.ScalingConfiguration;
import org.apache.shardingsphere.shardingscaling.core.config.SyncConfiguration;
import org.apache.shardingsphere.shardingscaling.core.config.utils.SyncConfigurationUtil;
import org.apache.shardingsphere.shardingscaling.core.controller.ScalingJobController;
import org.apache.shardingsphere.shardingscaling.core.controller.SyncProgress;
import org.apache.shardingsphere.shardingscaling.core.datasource.DataSourceManager;
import org.apache.shardingsphere.shardingscaling.core.exception.DatasourceCheckFailedException;
import org.apache.shardingsphere.shardingscaling.core.exception.ScalingJobNotFoundException;
import org.apache.shardingsphere.shardingscaling.core.execute.executor.checker.DataSourceChecker;
import org.apache.shardingsphere.shardingscaling.core.execute.executor.checker.DataSourceCheckerCheckerFactory;
import org.apache.shardingsphere.shardingscaling.utils.ResponseContentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    private static final Pattern URL_PATTERN = Pattern.compile("(^/shardingscaling/job/(start|stop|list))|(^/shardingscaling/job/progress/\\d+)", 2);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
    private static final ScalingJobController SCALING_JOB_CONTROLLER = new ScalingJobController();

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest request) {
        String requestPath = request.uri();
        String requestBody = request.content().toString(CharsetUtil.UTF_8);
        HttpMethod method = request.method();
        if (!URL_PATTERN.matcher(requestPath).matches()) {
            this.response(GSON.toJson((Object)ResponseContentUtil.handleBadRequest("Not support request!")), channelHandlerContext, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if ("/shardingscaling/job/start".equalsIgnoreCase(requestPath) && method.equals((Object)HttpMethod.POST)) {
            this.startJob(channelHandlerContext, requestBody);
            return;
        }
        if (requestPath.contains("/shardingscaling/job/progress/") && method.equals((Object)HttpMethod.GET)) {
            this.getJobProgress(channelHandlerContext, requestPath);
            return;
        }
        if ("/shardingscaling/job/list".equalsIgnoreCase(requestPath) && method.equals((Object)HttpMethod.GET)) {
            this.listAllJobs(channelHandlerContext);
            return;
        }
        if ("/shardingscaling/job/stop".equalsIgnoreCase(requestPath) && method.equals((Object)HttpMethod.POST)) {
            this.stopJob(channelHandlerContext, requestBody);
            return;
        }
        this.response(GSON.toJson((Object)ResponseContentUtil.handleBadRequest("Not support request!")), channelHandlerContext, HttpResponseStatus.BAD_REQUEST);
    }

    private void startJob(ChannelHandlerContext channelHandlerContext, String requestBody) {
        ScalingConfiguration scalingConfiguration = (ScalingConfiguration)GSON.fromJson(requestBody, ScalingConfiguration.class);
        ShardingScalingJob shardingScalingJob = new ShardingScalingJob("Local Sharding Scaling Job");
        shardingScalingJob.getSyncConfigurations().addAll(SyncConfigurationUtil.toSyncConfigurations((ScalingConfiguration)scalingConfiguration));
        DataSourceManager dataSourceManager = new DataSourceManager(shardingScalingJob.getSyncConfigurations());
        try {
            this.checkDatasources(shardingScalingJob.getSyncConfigurations(), dataSourceManager);
        }
        catch (DatasourceCheckFailedException e) {
            log.warn("Datasources check failed!", (Throwable)e);
            this.response(GSON.toJson((Object)ResponseContentUtil.handleBadRequest(e.getMessage())), channelHandlerContext, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        log.info("start job : {}", (Object)requestBody);
        SCALING_JOB_CONTROLLER.start(shardingScalingJob);
        this.response(GSON.toJson((Object)ResponseContentUtil.success()), channelHandlerContext, HttpResponseStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatasources(List<SyncConfiguration> syncConfigurations, DataSourceManager dataSourceManager) {
        try {
            DataSourceChecker dataSourceChecker = DataSourceCheckerCheckerFactory.newInstanceDataSourceChecker((String)syncConfigurations.get(0).getReaderConfiguration().getDataSourceConfiguration().getDatabaseType().getName());
            dataSourceChecker.checkConnection(new ArrayList(dataSourceManager.getCachedDataSources().values()));
            dataSourceChecker.checkPrivilege(new ArrayList(dataSourceManager.getSourceDatasources().values()));
        }
        finally {
            dataSourceManager.close();
        }
    }

    private void getJobProgress(ChannelHandlerContext channelHandlerContext, String requestPath) {
        int jobId = Integer.parseInt(requestPath.split("/")[4]);
        try {
            SyncProgress progresses = SCALING_JOB_CONTROLLER.getProgresses(jobId);
            this.response(GSON.toJson(ResponseContentUtil.build(progresses)), channelHandlerContext, HttpResponseStatus.OK);
        }
        catch (ScalingJobNotFoundException e) {
            this.response(GSON.toJson((Object)ResponseContentUtil.handleBadRequest(e.getMessage())), channelHandlerContext, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private void listAllJobs(ChannelHandlerContext channelHandlerContext) {
        List shardingScalingJobs = SCALING_JOB_CONTROLLER.listShardingScalingJobs();
        this.response(GSON.toJson(ResponseContentUtil.build(shardingScalingJobs)), channelHandlerContext, HttpResponseStatus.OK);
    }

    private void stopJob(ChannelHandlerContext channelHandlerContext, String requestBody) {
        ShardingScalingJob shardingScalingJob = (ShardingScalingJob)GSON.fromJson(requestBody, ShardingScalingJob.class);
        SCALING_JOB_CONTROLLER.stop(shardingScalingJob.getJobId());
        this.response(GSON.toJson((Object)ResponseContentUtil.success()), channelHandlerContext, HttpResponseStatus.OK);
    }

    private void response(String content, ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        ctx.writeAndFlush((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.warn("Http request handle occur error:", cause);
        this.response(GSON.toJson((Object)ResponseContentUtil.handleException(cause.toString())), ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        ctx.close();
    }
}

