/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.constant;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnknownSQLException;

public enum MySQLStatusFlag {
    SERVER_STATUS_IN_TRANS(1),
    SERVER_STATUS_AUTOCOMMIT(2),
    SERVER_MORE_RESULTS_EXISTS(8),
    SERVER_STATUS_NO_GOOD_INDEX_USED(16),
    SERVER_STATUS_NO_INDEX_USED(32),
    SERVER_STATUS_CURSOR_EXISTS(64),
    SERVER_STATUS_LAST_ROW_SENT(128),
    SERVER_STATUS_DB_DROPPED(256),
    SERVER_STATUS_NO_BACKSLASH_ESCAPES(512),
    SERVER_STATUS_METADATA_CHANGED(1024),
    SERVER_QUERY_WAS_SLOW(2048),
    SERVER_PS_OUT_PARAMS(4096),
    SERVER_STATUS_IN_TRANS_READONLY(8192),
    SERVER_SESSION_STATE_CHANGED(16384);

    private final int value;

    public static MySQLStatusFlag valueOf(int value) {
        for (MySQLStatusFlag each : MySQLStatusFlag.values()) {
            if (each.value != value) continue;
            return each;
        }
        throw new UnknownSQLException((Exception)new SQLException(String.format("Illegal MySQL status flag value %d", value)));
    }

    @Generated
    private MySQLStatusFlag(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }
}

