/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.blob;

import java.io.Serializable;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;

public final class MySQLBlobBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        return payload.readStringFixByBytes(this.readLengthFromMeta(columnDef.getColumnMeta(), payload));
    }

    private int readLengthFromMeta(int columnMeta, MySQLPacketPayload payload) {
        switch (columnMeta) {
            case 1: {
                return payload.getByteBuf().readUnsignedByte();
            }
            case 2: {
                return payload.getByteBuf().readUnsignedShortLE();
            }
            case 3: {
                return payload.getByteBuf().readUnsignedMediumLE();
            }
            case 4: {
                return payload.readInt4();
            }
        }
        throw new UnsupportedSQLOperationException(String.format("MySQL BLOB type meta in binlog should be range 1 to 4, but actual value is: %s", columnMeta));
    }
}

