/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLNewParametersBoundFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLPreparedStatementParameterType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLComStmtExecutePacket
extends MySQLCommandPacket {
    private static final int ITERATION_COUNT = 1;
    private static final int NULL_BITMAP_OFFSET = 0;
    private final MySQLPacketPayload payload;
    private final int statementId;
    private final int flags;
    private final MySQLNullBitmap nullBitmap;
    private final MySQLNewParametersBoundFlag newParametersBoundFlag;
    private final List<MySQLPreparedStatementParameterType> newParameterTypes;

    public MySQLComStmtExecutePacket(MySQLPacketPayload payload, int parameterCount) {
        super(MySQLCommandPacketType.COM_STMT_EXECUTE);
        this.payload = payload;
        this.statementId = payload.readInt4();
        this.flags = payload.readInt1();
        Preconditions.checkArgument((1 == payload.readInt4() ? 1 : 0) != 0);
        if (parameterCount > 0) {
            this.nullBitmap = new MySQLNullBitmap(parameterCount, 0);
            for (int i = 0; i < this.nullBitmap.getNullBitmap().length; ++i) {
                this.nullBitmap.getNullBitmap()[i] = payload.readInt1();
            }
            this.newParametersBoundFlag = MySQLNewParametersBoundFlag.valueOf(payload.readInt1());
            this.newParameterTypes = MySQLNewParametersBoundFlag.PARAMETER_TYPE_EXIST == this.newParametersBoundFlag ? this.getNewParameterTypes(parameterCount) : Collections.emptyList();
        } else {
            this.nullBitmap = null;
            this.newParametersBoundFlag = null;
            this.newParameterTypes = Collections.emptyList();
        }
    }

    private List<MySQLPreparedStatementParameterType> getNewParameterTypes(int parameterCount) {
        ArrayList<MySQLPreparedStatementParameterType> result = new ArrayList<MySQLPreparedStatementParameterType>(parameterCount);
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            MySQLBinaryColumnType columnType = MySQLBinaryColumnType.valueOf(this.payload.readInt1());
            int unsignedFlag = this.payload.readInt1();
            result.add(new MySQLPreparedStatementParameterType(columnType, unsignedFlag));
        }
        return result;
    }

    public List<Object> readParameters(List<MySQLPreparedStatementParameterType> parameterTypes, Set<Integer> longDataIndexes) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(parameterTypes.size());
        for (int parameterIndex = 0; parameterIndex < parameterTypes.size(); ++parameterIndex) {
            if (longDataIndexes.contains(parameterIndex)) {
                result.add(null);
                continue;
            }
            MySQLBinaryProtocolValue binaryProtocolValue = MySQLBinaryProtocolValueFactory.getBinaryProtocolValue(parameterTypes.get(parameterIndex).getColumnType());
            result.add(this.nullBitmap.isNullParameter(parameterIndex) ? null : binaryProtocolValue.read(this.payload));
        }
        return result;
    }

    @Generated
    public String toString() {
        return "MySQLComStmtExecutePacket(statementId=" + this.getStatementId() + ")";
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }

    @Generated
    public MySQLNewParametersBoundFlag getNewParametersBoundFlag() {
        return this.newParametersBoundFlag;
    }

    @Generated
    public List<MySQLPreparedStatementParameterType> getNewParameterTypes() {
        return this.newParameterTypes;
    }
}

