/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDateBinaryProtocolValue
implements MySQLBinaryProtocolValue {
    @Override
    public Object read(MySQLPacketPayload payload) throws SQLException {
        int length = payload.readInt1();
        switch (length) {
            case 0: {
                throw new SQLFeatureNotSupportedException("Can not support date format if year, month, day is absent.");
            }
            case 4: {
                return this.getTimestampForDate(payload);
            }
            case 7: {
                return this.getTimestampForDatetime(payload);
            }
            case 11: {
                Timestamp result = this.getTimestampForDatetime(payload);
                result.setNanos(payload.readInt4() * 1000);
                return result;
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Wrong length `%d` of MYSQL_TYPE_TIME", length));
    }

    private Timestamp getTimestampForDate(MySQLPacketPayload payload) {
        Calendar result = Calendar.getInstance();
        result.set(payload.readInt2(), payload.readInt1() - 1, payload.readInt1());
        return new Timestamp(result.getTimeInMillis());
    }

    private Timestamp getTimestampForDatetime(MySQLPacketPayload payload) {
        Calendar result = Calendar.getInstance();
        result.set(payload.readInt2(), payload.readInt1() - 1, payload.readInt1(), payload.readInt1(), payload.readInt1(), payload.readInt1());
        return new Timestamp(result.getTimeInMillis());
    }

    @Override
    public void write(MySQLPacketPayload payload, Object value) {
        boolean isNanosAbsent;
        Timestamp timestamp = new Timestamp(((Date)value).getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        int hourOfDay = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        int nanos = timestamp.getNanos();
        boolean isTimeAbsent = 0 == hourOfDay && 0 == minutes && 0 == seconds;
        boolean bl = isNanosAbsent = 0 == nanos;
        if (isTimeAbsent && isNanosAbsent) {
            payload.writeInt1(4);
            this.writeDate(payload, year, month, dayOfMonth);
            return;
        }
        if (isNanosAbsent) {
            payload.writeInt1(7);
            this.writeDate(payload, year, month, dayOfMonth);
            this.writeTime(payload, hourOfDay, minutes, seconds);
            return;
        }
        payload.writeInt1(11);
        this.writeDate(payload, year, month, dayOfMonth);
        this.writeTime(payload, hourOfDay, minutes, seconds);
        this.writeNanos(payload, nanos);
    }

    private void writeDate(MySQLPacketPayload payload, int year, int month, int dayOfMonth) {
        payload.writeInt2(year);
        payload.writeInt1(month);
        payload.writeInt1(dayOfMonth);
    }

    private void writeTime(MySQLPacketPayload payload, int hourOfDay, int minutes, int seconds) {
        payload.writeInt1(hourOfDay);
        payload.writeInt1(minutes);
        payload.writeInt1(seconds);
    }

    private void writeNanos(MySQLPacketPayload payload, int nanos) {
        payload.writeInt4(nanos);
    }
}

