/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.generic;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.util.exception.external.sql.vendor.VendorError;

public final class MySQLErrPacket
implements MySQLPacket {
    public static final int HEADER = 255;
    private static final String SQL_STATE_MARKER = "#";
    private final int sequenceId;
    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    public MySQLErrPacket(int sequenceId, VendorError vendorError, Object ... errorMessageArguments) {
        this(sequenceId, vendorError.getVendorCode(), vendorError.getSqlState().getValue(), String.format(vendorError.getReason(), errorMessageArguments));
    }

    public MySQLErrPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((255 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL ERR packet must be `0xff`.");
        this.errorCode = payload.readInt2();
        payload.readStringFix(1);
        this.sqlState = payload.readStringFix(5);
        this.errorMessage = payload.readStringEOF();
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(255);
        payload.writeInt2(this.errorCode);
        if (0 != this.sequenceId) {
            payload.writeStringFix(SQL_STATE_MARKER);
            payload.writeStringFix(this.sqlState);
        }
        payload.writeStringEOF(this.errorMessage);
    }

    @Generated
    public MySQLErrPacket(int sequenceId, int errorCode, String sqlState, String errorMessage) {
        this.sequenceId = sequenceId;
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = errorMessage;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getSqlState() {
        return this.sqlState;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

