/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.handshake;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthPluginData;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLAuthSwitchRequestPacket
implements MySQLPacket {
    public static final int HEADER = 254;
    private final int sequenceId;
    private final String authPluginName;
    private final MySQLAuthPluginData authPluginData;

    public MySQLAuthSwitchRequestPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((254 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL auth switch request packet must be `0xfe`.");
        this.authPluginName = payload.readStringNul();
        String strAuthPluginData = payload.readStringNul();
        this.authPluginData = new MySQLAuthPluginData(Arrays.copyOfRange(strAuthPluginData.getBytes(), 0, 8), Arrays.copyOfRange(strAuthPluginData.getBytes(), 8, 20));
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(254);
        payload.writeStringNul(this.authPluginName);
        payload.writeStringNul(new String(this.authPluginData.getAuthenticationPluginData()));
    }

    @Generated
    public MySQLAuthSwitchRequestPacket(int sequenceId, String authPluginName, MySQLAuthPluginData authPluginData) {
        this.sequenceId = sequenceId;
        this.authPluginName = authPluginName;
        this.authPluginData = authPluginData;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public String getAuthPluginName() {
        return this.authPluginName;
    }

    @Generated
    public MySQLAuthPluginData getAuthPluginData() {
        return this.authPluginData;
    }
}

