/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.LiteralValue;

public final class NumberLiteralValue
implements LiteralValue<Number> {
    private final Number value;

    public NumberLiteralValue(String value) {
        this.value = this.getNumber(value);
    }

    private Number getNumber(String value) {
        try {
            return NumberLiteralValue.getBigInteger(value);
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    private static Number getBigInteger(String value) {
        BigInteger result = new BigInteger(value);
        if (result.compareTo(new BigInteger(String.valueOf(Integer.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Integer.MAX_VALUE))) <= 0) {
            return result.intValue();
        }
        if (result.compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) <= 0) {
            return result.longValue();
        }
        return result;
    }

    @Override
    @Generated
    public Number getValue() {
        return this.value;
    }
}

