/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.arguments.BootstrapArguments;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfigurationLoader;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.frontend.CDCServer;
import org.apache.shardingsphere.proxy.frontend.ShardingSphereProxy;
import org.apache.shardingsphere.proxy.initializer.BootstrapInitializer;

public final class Bootstrap {
    public static void main(String[] args) throws IOException, SQLException {
        boolean cdcEnabled;
        BootstrapArguments bootstrapArgs = new BootstrapArguments(args);
        YamlProxyConfiguration yamlConfig = ProxyConfigurationLoader.load((String)bootstrapArgs.getConfigurationPath());
        int port = bootstrapArgs.getPort().orElseGet(() -> (Integer)new ConfigurationProperties(yamlConfig.getServerConfiguration().getProps()).getValue((Enum)ConfigurationPropertyKey.PROXY_DEFAULT_PORT));
        List<String> addresses = bootstrapArgs.getAddresses();
        new BootstrapInitializer().init(yamlConfig, port, bootstrapArgs.getForce());
        boolean bl = cdcEnabled = null != yamlConfig.getServerConfiguration().getCdc() && yamlConfig.getServerConfiguration().getCdc().isEnabled();
        if (cdcEnabled) {
            new CDCServer(addresses, yamlConfig.getServerConfiguration().getCdc().getPort()).start();
        }
        new ShardingSphereProxy().start(port, addresses);
    }

    @Generated
    private Bootstrap() {
    }
}

