/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.arguments;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class BootstrapArguments {
    private static final String DEFAULT_CONFIG_PATH = "/conf/";
    private static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    private final String[] args;

    public Optional<Integer> getPort() {
        if (0 == this.args.length) {
            return Optional.empty();
        }
        try {
            int port = Integer.parseInt(this.args[0]);
            if (port < 0) {
                return Optional.empty();
            }
            return Optional.of(port);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Invalid port `%s`.", this.args[0]));
        }
    }

    public String getConfigurationPath() {
        return this.args.length < 2 ? DEFAULT_CONFIG_PATH : this.paddingWithSlash(this.args[1]);
    }

    public List<String> getAddresses() {
        return this.args.length < 3 ? Collections.singletonList(DEFAULT_BIND_ADDRESS) : Arrays.asList(this.args[2].split(","));
    }

    public boolean getForce() {
        return this.args.length >= 4 && this.parseForceParameter(this.args[3]);
    }

    private boolean parseForceParameter(String forceParam) {
        return Boolean.TRUE.toString().equalsIgnoreCase(forceParam.trim());
    }

    private String paddingWithSlash(String pathArg) {
        StringBuilder result = new StringBuilder(pathArg);
        if (!pathArg.startsWith("/")) {
            result.insert(0, '/');
        }
        if (!pathArg.endsWith("/")) {
            result.append('/');
        }
        return result.toString();
    }

    @Generated
    public BootstrapArguments(String[] args) {
        this.args = args;
    }
}

