/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.config;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;

public class LogbackConfiguration
extends BasicConfigurator {
    public static final String DEFAULT_PATTERN = "[%-5level] %d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %logger{36} - %msg%n";
    public static final String SHARDINGSPHERE_LOGGER_NAME = "org.apache.shardingsphere";
    public static final String HIKARI_LOGGER_NAME = "com.zaxxer.hikari";
    public static final String ATOMIKOS_LOGGER_NAME = "com.atomikos";
    public static final String NETTY_LOGGER_NAME = "io.netty";

    public void configure(LoggerContext loggerContext) {
        ConsoleAppender<ILoggingEvent> consoleAppender = this.createConsoleAppender(loggerContext);
        Logger rootLogger = loggerContext.getLogger("ROOT");
        rootLogger.setLevel(Level.INFO);
        rootLogger.addAppender(consoleAppender);
        Logger shardingsphereLogger = loggerContext.getLogger(SHARDINGSPHERE_LOGGER_NAME);
        shardingsphereLogger.setLevel(Level.INFO);
        shardingsphereLogger.setAdditive(false);
        shardingsphereLogger.addAppender(consoleAppender);
        this.initBasicLogger(loggerContext);
    }

    private ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext) {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.setName("console");
        LayoutWrappingEncoder<ILoggingEvent> encoder = this.createEncoder(loggerContext);
        consoleAppender.setEncoder(encoder);
        consoleAppender.start();
        return consoleAppender;
    }

    private LayoutWrappingEncoder<ILoggingEvent> createEncoder(LoggerContext loggerContext) {
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setContext((Context)loggerContext);
        PatternLayout layout = this.createConsolePatternLayout(loggerContext);
        encoder.setLayout((Layout)layout);
        return encoder;
    }

    private PatternLayout createConsolePatternLayout(LoggerContext loggerContext) {
        PatternLayout layout = new PatternLayout();
        layout.setPattern(DEFAULT_PATTERN);
        layout.setContext((Context)loggerContext);
        layout.start();
        return layout;
    }

    private void initBasicLogger(LoggerContext loggerContext) {
        loggerContext.getLogger(HIKARI_LOGGER_NAME).setLevel(Level.ERROR);
        loggerContext.getLogger(ATOMIKOS_LOGGER_NAME).setLevel(Level.ERROR);
        loggerContext.getLogger(NETTY_LOGGER_NAME).setLevel(Level.ERROR);
    }
}

