/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.initializer;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataBuilder;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.spi.type.required.RequiredSPIRegistry;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPIRegistry;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListener;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.version.ShardingSphereProxyVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BootstrapInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapInitializer.class);

    public void init(YamlProxyConfiguration yamlConfig, int port, boolean force) throws SQLException {
        ModeConfiguration modeConfig = null == yamlConfig.getServerConfiguration().getMode() ? null : new YamlModeConfigurationSwapper().swapToObject(yamlConfig.getServerConfiguration().getMode());
        ProxyConfiguration proxyConfig = new YamlProxyConfigurationSwapper().swap(yamlConfig);
        ContextManager contextManager = this.createContextManager(proxyConfig, modeConfig, port, force);
        ProxyContext.init((ContextManager)contextManager);
        this.contextManagerInitializedCallback(modeConfig, contextManager);
        ShardingSphereProxyVersion.setVersion(contextManager);
    }

    private ContextManager createContextManager(ProxyConfiguration proxyConfig, ModeConfiguration modeConfig, int port, boolean force) throws SQLException {
        ContextManagerBuilderParameter param = new ContextManagerBuilderParameter(modeConfig, proxyConfig.getDatabaseConfigurations(), proxyConfig.getGlobalConfiguration().getRules(), proxyConfig.getGlobalConfiguration().getProperties(), proxyConfig.getGlobalConfiguration().getLabels(), this.createInstanceMetaData(proxyConfig, port), force);
        ContextManagerBuilder contextManagerBuilder = null == modeConfig ? (ContextManagerBuilder)RequiredSPIRegistry.getRegisteredService(ContextManagerBuilder.class) : (ContextManagerBuilder)TypedSPIRegistry.getRegisteredService(ContextManagerBuilder.class, (String)modeConfig.getType());
        return contextManagerBuilder.build(param);
    }

    private InstanceMetaData createInstanceMetaData(ProxyConfiguration proxyConfig, int port) {
        String instanceType = proxyConfig.getGlobalConfiguration().getProperties().getProperty(ConfigurationPropertyKey.PROXY_INSTANCE_TYPE.getKey(), ConfigurationPropertyKey.PROXY_INSTANCE_TYPE.getDefaultValue());
        return ((InstanceMetaDataBuilder)TypedSPIRegistry.getRegisteredService(InstanceMetaDataBuilder.class, (String)instanceType)).build(port);
    }

    private void contextManagerInitializedCallback(ModeConfiguration modeConfig, ContextManager contextManager) {
        for (ContextManagerLifecycleListener each : ShardingSphereServiceLoader.getServiceInstances(ContextManagerLifecycleListener.class)) {
            try {
                each.onInitialized(modeConfig, contextManager);
            }
            catch (Exception ex) {
                log.error("contextManager onInitialized callback for '{}' failed", (Object)each.getClass().getName(), (Object)ex);
            }
        }
    }

    @Generated
    public BootstrapInitializer() {
    }
}

