/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.version;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.infra.autogen.version.ShardingSphereVersion;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResourceMetaData;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPIRegistry;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.database.DatabaseServerInfo;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereProxyVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereProxyVersion.class);

    public static void setVersion(ContextManager contextManager) {
        CommonConstants.PROXY_VERSION.set(ShardingSphereProxyVersion.getProxyVersion());
        contextManager.getMetaDataContexts().getMetaData().getDatabases().values().forEach(ShardingSphereProxyVersion::setDatabaseVersion);
    }

    private static String getProxyVersion() {
        String result = "5.3.1";
        if (!ShardingSphereVersion.IS_SNAPSHOT || Strings.isNullOrEmpty((String)ShardingSphereVersion.BUILD_GIT_COMMIT_ID_ABBREV)) {
            return result;
        }
        result = result + (ShardingSphereVersion.BUILD_GIT_DIRTY ? "-dirty" : "");
        result = result + "-" + ShardingSphereVersion.BUILD_GIT_COMMIT_ID_ABBREV;
        return result;
    }

    private static void setDatabaseVersion(ShardingSphereDatabase database) {
        Optional<DataSource> dataSource = ShardingSphereProxyVersion.findDataSourceByProtocolType(database.getName(), database.getResourceMetaData(), database.getProtocolType());
        if (!dataSource.isPresent()) {
            return;
        }
        DatabaseServerInfo databaseServerInfo = new DatabaseServerInfo(dataSource.get());
        log.info("{}, database name is `{}`", (Object)databaseServerInfo, (Object)database.getName());
        ((DatabaseProtocolFrontendEngine)TypedSPIRegistry.getRegisteredService(DatabaseProtocolFrontendEngine.class, (String)DatabaseTypeEngine.getTrunkDatabaseType((String)databaseServerInfo.getDatabaseName()).getType(), (Properties)new Properties())).setDatabaseVersion(database.getName(), databaseServerInfo.getDatabaseVersion());
    }

    private static Optional<DataSource> findDataSourceByProtocolType(String databaseName, ShardingSphereResourceMetaData resourceMetaData, DatabaseType protocolType) {
        Optional<String> dataSourceName = resourceMetaData.getStorageTypes().entrySet().stream().filter(entry -> ((DatabaseType)entry.getValue()).equals(protocolType)).map(Map.Entry::getKey).findFirst();
        return dataSourceName.flatMap(optional -> Optional.ofNullable(DataSourceStateManager.getInstance().getEnabledDataSourceMap(databaseName, resourceMetaData.getDataSources()).get(optional)));
    }
}

