/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.apm.plugin.customize.constants;

/**
 * The constant of customize enhance.
 */

public class Constants {

    public static final String OPERATION_NAME_SEPARATOR = "/";

    public static final String COMMA = ",";

    public static final String LEFT_PARENTHESIS = "(";

    public static final String RIGHT_PARENTHESIS = ")";

    public static final String XML_ELEMENT_CLASS = "class";

    public static final String XML_ELEMENT_CLASS_NAME = "class_name";

    public static final String XML_ELEMENT_METHOD = "method";

    public static final String XML_ELEMENT_METHOD_IS_STATIC = "static";

    public static final String XML_ELEMENT_OPERATION_NAME = "operation_name";

    public static final String XML_ELEMENT_CLOSE_BEFORE_METHOD = "close_before_method";

    public static final String XML_ELEMENT_CLOSE_AFTER_METHOD = "close_after_method";

    public static final String XML_ELEMENT_OPERATION_NAME_SUFFIX = "operation_name_suffix";

    public static final String XML_ELEMENT_TAG = "tag";

    public static final String XML_ELEMENT_LOG = "log";

    public static final String XML_ELEMENT_KEY = "key";

    public static final String CONTEXT_METHOD_CONFIGURATIONS = "CONTEXT_METHOD_CONFIGURATIONS";

    public static final String CONTEXT_ENHANCE_CLASSES = "CONTEXT_ENHANCE_CLASSES";

    public static final String CONFIGURATION_ATTRIBUTE_METHOD = "CONFIGURATION_ATTRIBUTE_METHOD";

    public static final String CONFIGURATION_ATTRIBUTE_METHOD_NAME = "CONFIGURATION_ATTRIBUTE_METHOD_NAME";

    public static final String CONFIGURATION_ATTRIBUTE_ARGUMENTS = "CONFIGURATION_ATTRIBUTE_ARGUMENTS";

    public static final String CONFIGURATION_ATTRIBUTE_IS_STATIC = "CONFIGURATION_ATTRIBUTE_IS_STATIC";

    public static final String CONFIGURATION_ATTRIBUTE_CLZ = "CONFIGURATION_ATTRIBUTE_CLZ";

    public static final String CONFIGURATION_ATTRIBUTE_OPERATION_NAME = "CONFIGURATION_ATTRIBUTE_OPERATION_NAME";

    public static final String CONFIGURATION_ATTRIBUTE_CLOSE_BEFORE_METHOD = "CONFIGURATION_ATTRIBUTE_CLOSE_BEFORE_METHOD";

    public static final String CONFIGURATION_ATTRIBUTE_CLOSE_AFTER_METHOD = "CONFIGURATION_ATTRIBUTE_CLOSE_AFTER_METHOD";

    public static final String CONFIGURATION_ATTRIBUTE_OPERATION_NAME_SUFFIXES = "CONFIGURATION_ATTRIBUTE_OPERATION_NAME_SUFFIXES";

    public static final String CONFIGURATION_ATTRIBUTE_TAGS = "CONFIGURATION_ATTRIBUTE_TAGS";

    public static final String CONFIGURATION_ATTRIBUTE_LOGS = "CONFIGURATION_ATTRIBUTE_LOGS";
}
