/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.oap.server.receiver.zipkin;

import lombok.Getter;
import lombok.Setter;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;

@Setter
@Getter
public class ZipkinReceiverConfig extends ModuleConfig {
    private String host;
    private int port;
    private String contextPath;
    private int jettyMinThreads = 1;
    private int jettyMaxThreads = 200;
    private long jettyIdleTimeOut = 30000;
    private int jettyAcceptorPriorityDelta = 0;
    private int jettyAcceptQueueSize = 0;
    private int expireTime = 20;
    private int maxCacheSize = 1_000_000;
    private boolean needAnalysis = false;
}
