/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package test.org.apache.skywalking.apm.testcase.exceptionchecker.controller;

import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import test.org.apache.skywalking.apm.testcase.exceptionchecker.service.TestService;

@RestController
@RequestMapping("/case")
@Log4j2
public class CaseController {

    private final TestService service;

    private static final String SUCCESS = "Success";

    @Autowired
    public CaseController(final TestService service) {
        this.service = service;
    }

    @RequestMapping("/exceptionchecker")
    @ResponseBody
    public String testcase() {
        try {
            service.testAnnotatedException();
        } catch (Exception ignore) {
        }

        try {
            service.testListedException();
        } catch (Exception ignore) {
        }

        try {
            service.testHierarchyListedException();
        } catch (Exception ignore) {
        }

        try {
            service.testException();
        } catch (Exception ignore) {
        }

        try {
            service.testRecursiveException();
        } catch (Exception ignore) {
        }
        return SUCCESS;
    }

    @RequestMapping("/healthCheck")
    @ResponseBody
    public String healthCheck() {
        // your codes
        return SUCCESS;
    }

}
