/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.storage.model.ElasticSearchExtension;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;

public class ColumnTypeEsMapping {
    public String transform(Class<?> type, Type genericType, ElasticSearchExtension elasticSearchExtension) {
        if (Integer.class.equals(type) || Integer.TYPE.equals(type) || Layer.class.equals(type)) {
            return "integer";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return "long";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return "double";
        }
        if (String.class.equals(type) || elasticSearchExtension.isKeyword()) {
            return "keyword";
        }
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return "text";
        }
        if (byte[].class.equals(type)) {
            return "binary";
        }
        if (JsonObject.class.equals(type)) {
            return "text";
        }
        if (List.class.isAssignableFrom(type)) {
            Type elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return this.transform((Class)elementType, elementType, elasticSearchExtension);
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }
}

