/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class EBPFProfilingDataEsDAO
extends EsDAO
implements IEBPFProfilingDataDAO {
    private final int scrollingBatchSize;

    public EBPFProfilingDataEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.scrollingBatchSize = config.getProfileDataQueryBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<EBPFProfilingDataRecord> queryData(List<String> scheduleIdList, long beginTime, long endTime) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_data");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("ebpf_profiling_data")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"ebpf_profiling_data"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.scrollingBatchSize));
        query.must((QueryBuilder)Query.terms((String)"schedule_id", scheduleIdList));
        query.must((QueryBuilder)Query.range((String)"upload_time").gte((Object)beginTime).lt((Object)endTime));
        SearchParams params = new SearchParams().scroll(SCROLL_CONTEXT_RETENTION);
        ArrayList<EBPFProfilingDataRecord> records = new ArrayList<EBPFProfilingDataRecord>();
        SearchResponse results = ((ElasticSearchClient)this.getClient()).search(index, search.build(), params);
        HashSet<String> scrollIds = new HashSet<String>();
        try {
            while (true) {
                String scrollId = results.getScrollId();
                scrollIds.add(scrollId);
                if (results.getHits().getTotal() != 0) {
                    List<EBPFProfilingDataRecord> batch = this.buildDataList(results);
                    records.addAll(batch);
                    if (batch.size() >= this.scrollingBatchSize) {
                        results = ((ElasticSearchClient)this.getClient()).scroll(SCROLL_CONTEXT_RETENTION, scrollId);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
            throw throwable;
        }
        scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
        return records;
    }

    private List<EBPFProfilingDataRecord> buildDataList(SearchResponse response) {
        ArrayList<EBPFProfilingDataRecord> records = new ArrayList<EBPFProfilingDataRecord>();
        for (SearchHit hit : response.getHits()) {
            Map sourceAsMap = hit.getSource();
            EBPFProfilingDataRecord.Builder builder = new EBPFProfilingDataRecord.Builder();
            records.add(builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ebpf_profiling_data", sourceAsMap)));
        }
        return records;
    }
}

