/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskExtension;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class EBPFProfilingTaskEsDAO
extends EsDAO
implements IEBPFProfilingTaskDAO {
    private static final Gson GSON = new Gson();
    private final int taskMaxSize;

    public EBPFProfilingTaskEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.taskMaxSize = config.getProfileTaskQueryMaxSize();
    }

    public List<EBPFProfilingTask> queryTasksByServices(List<String> serviceIdList, long taskStartTime, long latestUpdateTime) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_task");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("ebpf_profiling_task")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"ebpf_profiling_task"));
        }
        if (CollectionUtils.isNotEmpty(serviceIdList)) {
            query.must((QueryBuilder)Query.terms((String)"service_id", serviceIdList));
        }
        if (taskStartTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"start_time").gte((Object)taskStartTime));
        }
        if (latestUpdateTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"last_update_time").gt((Object)latestUpdateTime));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("create_time", Sort.Order.DESC).size(Integer.valueOf(this.taskMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseTask).collect(Collectors.toList());
    }

    public List<EBPFProfilingTask> queryTasksByTargets(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targetTypes, long taskStartTime, long latestUpdateTime) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_task");
        BoolQueryBuilder query = Query.bool();
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            query.must((QueryBuilder)Query.term((String)"instance_id", (Object)serviceInstanceId));
        }
        if (CollectionUtils.isNotEmpty(targetTypes)) {
            query.must((QueryBuilder)Query.terms((String)"target_type", targetTypes.stream().map(EBPFProfilingTargetType::value).collect(Collectors.toList())));
        }
        if (taskStartTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"start_time").gte((Object)taskStartTime));
        }
        if (latestUpdateTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"last_update_time").gt((Object)latestUpdateTime));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("create_time", Sort.Order.DESC).size(Integer.valueOf(this.taskMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseTask).collect(Collectors.toList());
    }

    public EBPFProfilingTask queryById(String id) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_task");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"logical_id", (Object)id));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.taskMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        List tasks = response.getHits().getHits().stream().map(this::parseTask).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tasks)) {
            return null;
        }
        EBPFProfilingTask result = (EBPFProfilingTask)tasks.get(0);
        for (int i = 1; i < tasks.size(); ++i) {
            result = result.combine((EBPFProfilingTask)tasks.get(i));
        }
        return result;
    }

    private EBPFProfilingTask parseTask(SearchHit hit) {
        Map sourceAsMap = hit.getSource();
        EBPFProfilingTaskRecord.Builder builder = new EBPFProfilingTaskRecord.Builder();
        EBPFProfilingTaskRecord record = builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ebpf_profiling_task", sourceAsMap));
        EBPFProfilingTask task = new EBPFProfilingTask();
        task.setTaskId(record.getLogicalId());
        task.setServiceId(record.getServiceId());
        task.setServiceName(IDManager.ServiceID.analysisId((String)record.getServiceId()).getName());
        if (StringUtil.isNotEmpty((String)record.getProcessLabelsJson())) {
            task.setProcessLabels((List)GSON.fromJson(record.getProcessLabelsJson(), ArrayList.class));
        } else {
            task.setProcessLabels(Collections.emptyList());
        }
        if (StringUtil.isNotEmpty((String)record.getInstanceId())) {
            task.setServiceInstanceId(record.getInstanceId());
            task.setServiceInstanceName(IDManager.ServiceInstanceID.analysisId((String)record.getInstanceId()).getName());
        }
        task.setTaskStartTime(record.getStartTime());
        task.setTriggerType(EBPFProfilingTriggerType.valueOf((int)record.getTriggerType()));
        task.setFixedTriggerDuration(record.getFixedTriggerDuration());
        task.setTargetType(EBPFProfilingTargetType.valueOf((int)record.getTargetType()));
        task.setCreateTime(record.getCreateTime());
        task.setLastUpdateTime(record.getLastUpdateTime());
        if (StringUtil.isNotEmpty((String)record.getExtensionConfigJson())) {
            task.setExtensionConfig((EBPFProfilingTaskExtension)GSON.fromJson(record.getExtensionConfigJson(), EBPFProfilingTaskExtension.class));
        }
        return task;
    }
}

