/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class TopologyQueryEsDAO
extends EsDAO
implements ITopologyQueryDAO {
    public TopologyQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration duration, List<String> serviceIds) {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        SearchBuilder sourceBuilder = Search.builder().size(Integer.valueOf(0));
        this.setQueryCondition(sourceBuilder, duration, serviceIds, "service_relation_server_side");
        return this.buildServiceRelation(sourceBuilder, "service_relation_server_side", DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration duration, List<String> serviceIds) {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        SearchBuilder sourceBuilder = Search.builder().size(Integer.valueOf(0));
        this.setQueryCondition(sourceBuilder, duration, serviceIds, "service_relation_client_side");
        return this.buildServiceRelation(sourceBuilder, "service_relation_client_side", DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration duration) {
        SearchBuilder sourceBuilder = Search.builder();
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket()));
        if (IndexController.LogicIndicesRegister.isMergedTable("service_relation_server_side")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"service_relation_server_side"));
        }
        sourceBuilder.query((QueryBuilder)query).size(Integer.valueOf(0));
        return this.buildServiceRelation(sourceBuilder, "service_relation_server_side", DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration duration) {
        SearchBuilder sourceBuilder = Search.builder();
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket()));
        if (IndexController.LogicIndicesRegister.isMergedTable("service_relation_client_side")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"service_relation_client_side"));
        }
        sourceBuilder.query((QueryBuilder)query).size(Integer.valueOf(0));
        return this.buildServiceRelation(sourceBuilder, "service_relation_client_side", DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String clientServiceId, String serverServiceId, Duration duration) {
        SearchBuilder search = Search.builder().size(Integer.valueOf(0));
        this.setInstanceQueryCondition(search, duration, clientServiceId, serverServiceId, "service_instance_relation_server_side");
        return this.buildInstanceRelation(search, "service_instance_relation_server_side", DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String clientServiceId, String serverServiceId, Duration duration) {
        SearchBuilder search = Search.builder().size(Integer.valueOf(0));
        this.setInstanceQueryCondition(search, duration, clientServiceId, serverServiceId, "service_instance_relation_client_side");
        return this.buildInstanceRelation(search, "service_instance_relation_client_side", DetectPoint.CLIENT);
    }

    private void setInstanceQueryCondition(SearchBuilder search, Duration duration, String clientServiceId, String serverServiceId, String indexName) {
        BoolQueryBuilder serverRelationBoolQuery = Query.bool().must((QueryBuilder)Query.term((String)"source_service_id", (Object)clientServiceId)).must((QueryBuilder)Query.term((String)"dest_service_id", (Object)serverServiceId));
        BoolQueryBuilder clientRelationBoolQuery = Query.bool().must((QueryBuilder)Query.term((String)"dest_service_id", (Object)clientServiceId)).must((QueryBuilder)Query.term((String)"source_service_id", (Object)serverServiceId));
        BoolQueryBuilder serviceIdBoolQuery = Query.bool().should((QueryBuilder)serverRelationBoolQuery).should((QueryBuilder)clientRelationBoolQuery);
        BoolQueryBuilder boolQuery = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket())).must((QueryBuilder)serviceIdBoolQuery);
        if (IndexController.LogicIndicesRegister.isMergedTable(indexName)) {
            boolQuery.must((QueryBuilder)Query.term((String)"metric_table", (Object)indexName));
        }
        search.query((QueryBuilder)boolQuery);
    }

    public List<Call.CallDetail> loadEndpointRelation(Duration duration, String destEndpointId) {
        SearchBuilder sourceBuilder = Search.builder();
        sourceBuilder.size(Integer.valueOf(0));
        BoolQueryBuilder boolQuery = Query.bool();
        boolQuery.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket()));
        BoolQueryBuilder serviceIdBoolQuery = Query.bool();
        boolQuery.must((QueryBuilder)serviceIdBoolQuery);
        serviceIdBoolQuery.should((QueryBuilder)Query.term((String)"source_endpoint", (Object)destEndpointId));
        serviceIdBoolQuery.should((QueryBuilder)Query.term((String)"dest_endpoint", (Object)destEndpointId));
        if (IndexController.LogicIndicesRegister.isMergedTable("endpoint_relation_server_side")) {
            boolQuery.must((QueryBuilder)Query.term((String)"metric_table", (Object)"endpoint_relation_server_side"));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        return this.loadEndpoint(sourceBuilder, "endpoint_relation_server_side", DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtClientSide(String serviceInstanceId, Duration duration) throws IOException {
        return this.buildProcessRelation(serviceInstanceId, duration, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtServerSide(String serviceInstanceId, Duration duration) throws IOException {
        return this.buildProcessRelation(serviceInstanceId, duration, DetectPoint.SERVER);
    }

    private List<Call.CallDetail> buildProcessRelation(String serviceInstanceId, Duration duration, DetectPoint detectPoint) throws IOException {
        SearchBuilder sourceBuilder = Search.builder().size(Integer.valueOf(0));
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"service_instance_id", (Object)serviceInstanceId)).must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket()));
        sourceBuilder.query((QueryBuilder)query);
        sourceBuilder.aggregation((AggregationBuilder)Aggregation.terms((String)"entity_id").field("entity_id").subAggregation((AggregationBuilder)Aggregation.terms((String)"component_id").field("component_id").executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST)).executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).size(1000));
        String indexName = detectPoint == DetectPoint.SERVER ? "process_relation_server_side" : "process_relation_client_side";
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(indexName);
        if (IndexController.LogicIndicesRegister.isMergedTable(indexName)) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)indexName));
        }
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, sourceBuilder.build());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        Map entityTerms = (Map)response.getAggregations().get("entity_id");
        List buckets = (List)entityTerms.get("buckets");
        for (Map entityBucket : buckets) {
            String entityId = (String)entityBucket.get("key");
            Map componentTerms = (Map)entityBucket.get("component_id");
            List subAgg = (List)componentTerms.get("buckets");
            int componentId = ((Number)((Map)subAgg.iterator().next()).get("key")).intValue();
            Call.CallDetail call = new Call.CallDetail();
            call.buildProcessRelation(entityId, componentId, detectPoint);
            calls.add(call);
        }
        return calls;
    }

    private List<Call.CallDetail> buildServiceRelation(SearchBuilder sourceBuilder, String indexName, DetectPoint detectPoint) {
        sourceBuilder.aggregation((AggregationBuilder)Aggregation.terms((String)"entity_id").field("entity_id").subAggregation((AggregationBuilder)Aggregation.terms((String)"component_ids").field("component_ids").executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST)).executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).size(1000));
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(indexName);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, sourceBuilder.build());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        Map entityTerms = (Map)response.getAggregations().get("entity_id");
        List buckets = (List)entityTerms.get("buckets");
        for (Map entityBucket : buckets) {
            String entityId = (String)entityBucket.get("key");
            Map componentTerms = (Map)entityBucket.get("component_ids");
            List subAgg = (List)componentTerms.get("buckets");
            IntList componentIds = new IntList((String)((Map)subAgg.iterator().next()).get("key"));
            Call.CallDetail call = new Call.CallDetail();
            for (int i = 0; i < componentIds.size(); ++i) {
                call.buildFromServiceRelation(entityId, componentIds.get(i), detectPoint);
                calls.add(call);
            }
        }
        return calls;
    }

    private List<Call.CallDetail> buildInstanceRelation(SearchBuilder sourceBuilder, String indexName, DetectPoint detectPoint) {
        sourceBuilder.aggregation((AggregationBuilder)Aggregation.terms((String)"entity_id").field("entity_id").executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).size(1000));
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(indexName);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, sourceBuilder.build());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        Map entityTerms = (Map)response.getAggregations().get("entity_id");
        List buckets = (List)entityTerms.get("buckets");
        for (Map entityBucket : buckets) {
            String entityId = (String)entityBucket.get("key");
            Call.CallDetail call = new Call.CallDetail();
            call.buildFromInstanceRelation(entityId, detectPoint);
            calls.add(call);
        }
        return calls;
    }

    private List<Call.CallDetail> loadEndpoint(SearchBuilder sourceBuilder, String indexName, DetectPoint detectPoint) {
        sourceBuilder.aggregation((AggregationBuilder)Aggregation.terms((String)"entity_id").field("entity_id").executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).size(1000));
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(indexName);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, sourceBuilder.build());
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        Map entityTerms = (Map)response.getAggregations().get("entity_id");
        List buckets = (List)entityTerms.get("buckets");
        for (Map entityBucket : buckets) {
            String entityId = (String)entityBucket.get("key");
            Call.CallDetail call = new Call.CallDetail();
            call.buildFromEndpointRelation(entityId, detectPoint);
            calls.add(call);
        }
        return calls;
    }

    private void setQueryCondition(SearchBuilder search, Duration duration, List<String> serviceIds, String indexName) {
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket()));
        BoolQueryBuilder serviceIdBoolQuery = Query.bool();
        query.must((QueryBuilder)serviceIdBoolQuery);
        if (IndexController.LogicIndicesRegister.isMergedTable(indexName)) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)indexName));
        }
        if (serviceIds.size() == 1) {
            serviceIdBoolQuery.should((QueryBuilder)Query.term((String)"source_service_id", (Object)serviceIds.get(0)));
            serviceIdBoolQuery.should((QueryBuilder)Query.term((String)"dest_service_id", (Object)serviceIds.get(0)));
        } else {
            serviceIdBoolQuery.should((QueryBuilder)Query.terms((String)"source_service_id", serviceIds));
            serviceIdBoolQuery.should((QueryBuilder)Query.terms((String)"dest_service_id", serviceIds));
        }
        search.query((QueryBuilder)query);
    }
}

