/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.library.util.MultipleFilesChangeMonitor;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchProvider;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.BatchProcessEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.HistoryDeleteEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache.NetworkAddressAliasEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ProfileTaskLogEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ProfileTaskQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TopNRecordsQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TopologyQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.UITemplateManagementEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.StorageModuleElasticsearch7Config;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.base.StorageEs7Installer;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.client.ElasticSearch7Client;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.dao.StorageEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.AggregationQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.AlarmQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.BrowserLogQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.LogQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.MetadataQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.MetricsQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.ProfileThreadSnapshotQueryEs7DAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query.TraceQueryEs7DAO;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class StorageModuleElasticsearch7Provider
extends ModuleProvider {
    protected final StorageModuleElasticsearch7Config config = new StorageModuleElasticsearch7Config();
    protected ElasticSearch7Client elasticSearch7Client;

    public String name() {
        return "elasticsearch7";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        if (!StringUtil.isEmpty((String)this.config.getNameSpace())) {
            this.config.setNameSpace(this.config.getNameSpace().toLowerCase());
        }
        if (this.config.getDayStep() > 1) {
            TimeSeriesUtils.setDAY_STEP((int)this.config.getDayStep());
            TimeSeriesUtils.setSUPER_DATASET_DAY_STEP((int)this.config.getDayStep());
        }
        if (this.config.getSuperDatasetDayStep() > 0) {
            TimeSeriesUtils.setSUPER_DATASET_DAY_STEP((int)this.config.getSuperDatasetDayStep());
        }
        if (!StringUtil.isEmpty((String)this.config.getSecretsManagementFile())) {
            MultipleFilesChangeMonitor monitor = new MultipleFilesChangeMonitor(10L, readableContents -> {
                byte[] secretsFileContent = (byte[])readableContents.get(0);
                if (secretsFileContent == null) {
                    return;
                }
                Properties secrets = new Properties();
                secrets.load(new ByteArrayInputStream(secretsFileContent));
                this.config.setUser(secrets.getProperty("user", null));
                this.config.setPassword(secrets.getProperty("password", null));
                this.config.setTrustStorePass(secrets.getProperty("trustStorePass", null));
                if (this.elasticSearch7Client != null) {
                    this.elasticSearch7Client.setUser(this.config.getUser());
                    this.elasticSearch7Client.setPassword(this.config.getPassword());
                    this.elasticSearch7Client.setTrustStorePass(this.config.getTrustStorePass());
                    this.elasticSearch7Client.connect();
                }
            }, new String[]{this.config.getSecretsManagementFile(), this.config.getTrustStorePass()});
            monitor.start();
        }
        this.elasticSearch7Client = new ElasticSearch7Client(this.config.getClusterNodes(), this.config.getProtocol(), this.config.getTrustStorePath(), this.config.getTrustStorePass(), this.config.getUser(), this.config.getPassword(), StorageModuleElasticsearchProvider.indexNameConverters((String)this.config.getNameSpace()));
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BatchProcessEsDAO((ElasticSearchClient)this.elasticSearch7Client, this.config.getBulkActions(), this.config.getSyncBulkActions(), this.config.getFlushInterval(), this.config.getConcurrentRequests()));
        this.registerServiceImplementation(StorageDAO.class, (Service)new StorageEs7DAO(this.elasticSearch7Client));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new HistoryDeleteEsDAO((ElasticSearchClient)this.elasticSearch7Client));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new NetworkAddressAliasEsDAO((ElasticSearchClient)this.elasticSearch7Client, this.config.getResultWindowMaxSize()));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new TopologyQueryEsDAO((ElasticSearchClient)this.elasticSearch7Client));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new MetricsQueryEs7DAO(this.elasticSearch7Client));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new TraceQueryEs7DAO(this.elasticSearch7Client, this.config.getSegmentQueryMaxSize()));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new BrowserLogQueryEs7DAO(this.elasticSearch7Client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new MetadataQueryEs7DAO(this.elasticSearch7Client, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new AggregationQueryEs7DAO(this.elasticSearch7Client));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new AlarmQueryEs7DAO(this.elasticSearch7Client));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new TopNRecordsQueryEsDAO((ElasticSearchClient)this.elasticSearch7Client));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new LogQueryEs7DAO(this.elasticSearch7Client));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new ProfileTaskQueryEsDAO((ElasticSearchClient)this.elasticSearch7Client, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new ProfileTaskLogEsDAO((ElasticSearchClient)this.elasticSearch7Client, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new ProfileThreadSnapshotQueryEs7DAO(this.elasticSearch7Client, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new UITemplateManagementEsDAO((ElasticSearchClient)this.elasticSearch7Client));
    }

    public void start() throws ModuleStartException {
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_elasticsearch", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.elasticSearch7Client.registerChecker((HealthChecker)healthChecker);
        try {
            this.elasticSearch7Client.connect();
            StorageEs7Installer installer = new StorageEs7Installer((Client)this.elasticSearch7Client, this.getManager(), this.config);
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)installer);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException | StorageException e) {
            throw new ModuleStartException(e.getMessage(), e);
        }
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

