/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.client;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.IndexNameConverter;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.client.ElasticSearch7InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.client.ElasticSearch7UpdateRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearch7Client
extends ElasticSearchClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearch7Client.class);

    public ElasticSearch7Client(String clusterNodes, String protocol, String trustStorePath, String trustStorePass, String user, String password, List<IndexNameConverter> indexNameConverters) {
        super(clusterNodes, protocol, trustStorePath, trustStorePass, user, password, indexNameConverters);
    }

    public void connect() throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, CertificateException {
        this.connectLock.lock();
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Throwable t) {
                    log.error("ElasticSearch7 client reconnection fails based on new config", t);
                }
            }
            List hosts = ElasticSearch7Client.parseClusterNodes((String)this.protocol, (String)this.clusterNodes);
            this.client = this.createClient(hosts);
            this.client.ping(RequestOptions.DEFAULT);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public boolean createIndex(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        CreateIndexResponse response = this.client.indices().create(request, RequestOptions.DEFAULT);
        log.debug("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public boolean createIndex(String indexName, Map<String, Object> settings, Map<String, Object> mapping) throws IOException {
        indexName = this.formatIndexName(indexName);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.settings(settings);
        request.mapping(mapping);
        CreateIndexResponse response = this.client.indices().create(request, RequestOptions.DEFAULT);
        log.debug("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public List<String> retrievalIndexByAliases(String aliases) throws IOException {
        GetAliasesResponse alias;
        aliases = this.formatIndexName(aliases);
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(new String[]{aliases});
        try {
            alias = this.client.indices().getAlias(getAliasesRequest, RequestOptions.DEFAULT);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
        return new ArrayList<String>(alias.getAliases().keySet());
    }

    protected boolean deleteIndex(String indexName, boolean formatIndexName) throws IOException {
        if (formatIndexName) {
            indexName = this.formatIndexName(indexName);
        }
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        AcknowledgedResponse response = this.client.indices().delete(request, RequestOptions.DEFAULT);
        log.debug("delete {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public boolean isExistsIndex(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        return this.client.indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean isExistsTemplate(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        IndexTemplatesExistRequest indexTemplatesExistRequest = new IndexTemplatesExistRequest(new String[]{indexName});
        return this.client.indices().existsTemplate(indexTemplatesExistRequest, RequestOptions.DEFAULT);
    }

    public boolean createTemplate(String indexName, Map<String, Object> settings, Map<String, Object> mapping) throws IOException {
        indexName = this.formatIndexName(indexName);
        PutIndexTemplateRequest putIndexTemplateRequest = new PutIndexTemplateRequest(indexName).patterns(Collections.singletonList(indexName + "-*")).alias(new Alias(indexName)).settings(settings).mapping(mapping);
        AcknowledgedResponse acknowledgedResponse = this.client.indices().putTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT);
        return acknowledgedResponse.isAcknowledged();
    }

    public boolean deleteTemplate(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        DeleteIndexTemplateRequest deleteIndexTemplateRequest = new DeleteIndexTemplateRequest(indexName);
        AcknowledgedResponse acknowledgedResponse = this.client.indices().deleteTemplate(deleteIndexTemplateRequest, RequestOptions.DEFAULT);
        return acknowledgedResponse.isAcknowledged();
    }

    public SearchResponse doSearch(SearchSourceBuilder searchSourceBuilder, String ... indexNames) throws IOException {
        SearchRequest searchRequest = new SearchRequest(indexNames);
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)false));
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            this.healthChecker.health();
            return response;
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            this.handleIOPoolStopped(t);
            throw t;
        }
    }

    public GetResponse get(String indexName, String id) throws IOException {
        indexName = this.formatIndexName(indexName);
        GetRequest request = new GetRequest(indexName, id);
        try {
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            this.healthChecker.health();
            return response;
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public SearchResponse ids(String indexName, String[] ids) throws IOException {
        indexName = this.formatIndexName(indexName);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source().query((QueryBuilder)QueryBuilders.idsQuery().addIds(ids)).size(ids.length);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            this.healthChecker.health();
            return response;
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public void forceInsert(String indexName, String id, XContentBuilder source) throws IOException {
        IndexRequest request = (IndexRequest)this.prepareInsert(indexName, id, source);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.client.index(request, RequestOptions.DEFAULT);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public void forceUpdate(String indexName, String id, XContentBuilder source) throws IOException {
        UpdateRequest request = (UpdateRequest)this.prepareUpdate(indexName, id, source);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.client.update(request, RequestOptions.DEFAULT);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public InsertRequest prepareInsert(String indexName, String id, XContentBuilder source) {
        indexName = this.formatIndexName(indexName);
        return new ElasticSearch7InsertRequest(indexName, id).source(source);
    }

    public org.apache.skywalking.oap.server.library.client.request.UpdateRequest prepareUpdate(String indexName, String id, XContentBuilder source) {
        indexName = this.formatIndexName(indexName);
        return new ElasticSearch7UpdateRequest(indexName, id).doc(source);
    }

    public int delete(String indexName, String timeBucketColumnName, long endTimeBucket) throws IOException {
        indexName = this.formatIndexName(indexName);
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
        deleteByQueryRequest.setAbortOnVersionConflict(false);
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.rangeQuery((String)timeBucketColumnName).lte((Object)endTimeBucket));
        BulkByScrollResponse bulkByScrollResponse = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
        log.debug("delete indexName: {}, by query request: {}, response: {}", new Object[]{indexName, deleteByQueryRequest, bulkByScrollResponse});
        return 200;
    }

    public void synchronousBulk(BulkRequest request) {
        request.timeout(TimeValue.timeValueMinutes((long)2L));
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        request.waitForActiveShards(ActiveShardCount.ONE);
        try {
            int size = request.requests().size();
            BulkResponse responses = this.client.bulk(request, RequestOptions.DEFAULT);
            log.info("Synchronous bulk took time: {} millis, size: {}", (Object)responses.getTook().getMillis(), (Object)size);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
        }
    }

    public BulkProcessor createBulkProcessor(int bulkActions, int flushInterval, int concurrentRequests) {
        BulkProcessor.Listener listener = this.createBulkListener();
        return BulkProcessor.builder((bulkRequest, bulkResponseActionListener) -> this.client.bulkAsync(bulkRequest, RequestOptions.DEFAULT, bulkResponseActionListener), (BulkProcessor.Listener)listener).setBulkActions(bulkActions).setFlushInterval(TimeValue.timeValueSeconds((long)flushInterval)).setConcurrentRequests(concurrentRequests).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)100L), (int)3)).build();
    }
}

