/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.AggregationQueryEsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Avg;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class AggregationQueryEs7DAO
extends AggregationQueryEsDAO {
    public AggregationQueryEs7DAO(ElasticSearchClient client) {
        super(client);
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)"time_bucket").lte((Object)duration.getEndTimeBucket()).gte((Object)duration.getStartTimeBucket());
        boolean asc = false;
        if (condition.getOrder().equals((Object)Order.ASC)) {
            asc = true;
        }
        if (additionalConditions != null && additionalConditions.size() > 0) {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            additionalConditions.forEach(additionalCondition -> boolQuery.must().add(QueryBuilders.termsQuery((String)additionalCondition.getKey(), (String[])new String[]{additionalCondition.getValue()})));
            boolQuery.must().add(queryBuilder);
            sourceBuilder.query((QueryBuilder)boolQuery);
        } else {
            sourceBuilder.query((QueryBuilder)queryBuilder);
        }
        sourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entity_id").field("entity_id")).order(BucketOrder.aggregation((String)valueColumnName, (boolean)asc)).size(condition.getTopN()).subAggregation((AggregationBuilder)AggregationBuilders.avg((String)valueColumnName).field(valueColumnName)));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(condition.getName(), sourceBuilder);
        ArrayList<SelectedRecord> topNList = new ArrayList<SelectedRecord>();
        Terms idTerms = (Terms)response.getAggregations().get("entity_id");
        for (Terms.Bucket termsBucket : idTerms.getBuckets()) {
            SelectedRecord record = new SelectedRecord();
            record.setId(termsBucket.getKeyAsString());
            Avg value = (Avg)termsBucket.getAggregations().get(valueColumnName);
            record.setValue(String.valueOf((long)value.getValue()));
            topNList.add(record);
        }
        return topNList;
    }
}

