/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.LogState;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class LogQueryEs7DAO
extends EsDAO
implements ILogQueryDAO {
    public LogQueryEs7DAO(ElasticSearchClient client) {
        super(client);
    }

    public Logs queryLogs(String metricName, int serviceId, int serviceInstanceId, String endpointId, String traceId, LogState state, String stateCode, Pagination paging, int from, int limit, long startSecondTB, long endSecondTB) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        List mustQueryList = boolQueryBuilder.must();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (serviceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        }
        if (serviceInstanceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_instance_id", (int)serviceInstanceId));
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"endpoint_id", (String)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)stateCode)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"status_code", (String)stateCode));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        }
        if (LogState.ERROR.equals((Object)state)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"is_error", (int)BooleanUtils.booleanToValue((Boolean)true)));
        } else if (LogState.SUCCESS.equals((Object)state)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"is_error", (int)BooleanUtils.booleanToValue((Boolean)false)));
        }
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(metricName, sourceBuilder);
        Logs logs = new Logs();
        logs.setTotal((int)response.getHits().getTotalHits().value);
        for (SearchHit searchHit : response.getHits().getHits()) {
            Log log = new Log();
            log.setServiceId((String)searchHit.getSourceAsMap().get("service_id"));
            log.setServiceInstanceId((String)searchHit.getSourceAsMap().get("service_instance_id"));
            log.setEndpointId((String)searchHit.getSourceAsMap().get("endpoint_id"));
            log.setEndpointName((String)searchHit.getSourceAsMap().get("endpoint_name"));
            log.setError(BooleanUtils.valueToBoolean((int)((Number)searchHit.getSourceAsMap().get("is_error")).intValue()));
            log.setStatusCode((String)searchHit.getSourceAsMap().get("status_code"));
            log.setContentType(ContentType.instanceOf((int)((Number)searchHit.getSourceAsMap().get("content_type")).intValue()));
            log.setContent((String)searchHit.getSourceAsMap().get("content"));
            logs.getLogs().add(log);
        }
        return logs;
    }
}

