/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import java.io.IOException;
import java.util.Iterator;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.MetricsQueryEsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Avg;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class MetricsQueryEs7DAO
extends MetricsQueryEsDAO {
    public MetricsQueryEs7DAO(ElasticSearchClient client) {
        super(client);
    }

    public long readMetricsValue(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        this.buildQuery(sourceBuilder, condition, duration);
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        Function function = ValueColumnMetadata.INSTANCE.getValueFunction(condition.getName());
        if (function == Function.Latest) {
            return this.readMetricsValues(condition, valueColumnName, duration).getValues().latestValue(defaultValue);
        }
        TermsAggregationBuilder entityIdAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entity_id").field("entity_id")).size(1);
        this.functionAggregation(function, entityIdAggregation, valueColumnName);
        sourceBuilder.aggregation((AggregationBuilder)entityIdAggregation);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(condition.getName(), sourceBuilder);
        Terms idTerms = (Terms)response.getAggregations().get("entity_id");
        Iterator iterator = idTerms.getBuckets().iterator();
        if (iterator.hasNext()) {
            Terms.Bucket idBucket = (Terms.Bucket)iterator.next();
            switch (function) {
                case Sum: {
                    Sum sum = (Sum)idBucket.getAggregations().get(valueColumnName);
                    return (long)sum.getValue();
                }
                case Avg: {
                    Avg avg = (Avg)idBucket.getAggregations().get(valueColumnName);
                    return (long)avg.getValue();
                }
            }
            Avg avg = (Avg)idBucket.getAggregations().get(valueColumnName);
            return (long)avg.getValue();
        }
        return defaultValue;
    }

    protected void functionAggregation(Function function, TermsAggregationBuilder parentAggBuilder, String valueCName) {
        switch (function) {
            case Avg: {
                parentAggBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)valueCName).field(valueCName));
                break;
            }
            case Sum: {
                parentAggBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)valueCName).field(valueCName));
                break;
            }
            default: {
                parentAggBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)valueCName).field(valueCName));
            }
        }
    }
}

