/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SpanTag;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.IndexNameMaker;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameMaker;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TraceQueryEsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TraceQueryEs7DAO
extends TraceQueryEsDAO {
    public TraceQueryEs7DAO(ElasticSearchClient client, int segmentQueryMaxSize) {
        super(client, segmentQueryMaxSize);
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<SpanTag> tags) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        List mustQueryList = boolQueryBuilder.must();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (minDuration != 0L || maxDuration != 0L) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"latency");
            if (minDuration != 0L) {
                rangeQueryBuilder.gte((Object)minDuration);
            }
            if (maxDuration != 0L) {
                rangeQueryBuilder.lte((Object)maxDuration);
            }
            boolQueryBuilder.must().add(rangeQueryBuilder);
        }
        if (!Strings.isNullOrEmpty((String)endpointName)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("endpoint_name");
            mustQueryList.add(QueryBuilders.matchPhraseQuery((String)matchCName, (Object)endpointName));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (String)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_instance_id", (String)serviceInstanceId));
        }
        if (!Strings.isNullOrEmpty((String)endpointId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"endpoint_id", (String)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        }
        switch (traceState) {
            case ERROR: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)1));
                break;
            }
            case SUCCESS: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)0));
            }
        }
        switch (queryOrder) {
            case BY_START_TIME: {
                sourceBuilder.sort("start_time", SortOrder.DESC);
                break;
            }
            case BY_DURATION: {
                sourceBuilder.sort("latency", SortOrder.DESC);
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            BoolQueryBuilder tagMatchQuery = QueryBuilders.boolQuery();
            tags.forEach(tag -> tagMatchQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag.toString())));
            mustQueryList.add(tagMatchQuery);
        }
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search((IndexNameMaker)new TimeRangeIndexNameMaker("segment", startSecondTB, endSecondTB), sourceBuilder);
        TraceBrief traceBrief = new TraceBrief();
        traceBrief.setTotal((int)response.getHits().getTotalHits().value);
        for (SearchHit searchHit : response.getHits().getHits()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId((String)searchHit.getSourceAsMap().get("segment_id"));
            basicTrace.setStart(String.valueOf(searchHit.getSourceAsMap().get("start_time")));
            basicTrace.getEndpointNames().add((String)searchHit.getSourceAsMap().get("endpoint_name"));
            basicTrace.setDuration(((Number)searchHit.getSourceAsMap().get("latency")).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)searchHit.getSourceAsMap().get("is_error")).intValue()));
            basicTrace.getTraceIds().add((String)searchHit.getSourceAsMap().get("trace_id"));
            traceBrief.getTraces().add(basicTrace);
        }
        return traceBrief;
    }
}

