/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class AlarmQueryEs7DAO
extends EsDAO
implements IAlarmQueryDAO {
    public AlarmQueryEs7DAO(ElasticSearchClient client) {
        super(client);
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB, List<Tag> tags) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        List mustQueryList = boolQueryBuilder.must();
        if (startTB != 0L && endTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        }
        boolQueryBuilder.must().add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        if (Objects.nonNull(scopeId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"scope", (int)scopeId));
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("alarm_message");
            boolQueryBuilder.must().add(QueryBuilders.matchPhraseQuery((String)matchCName, (Object)keyword));
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            tags.forEach(tag -> mustQueryList.add(QueryBuilders.termQuery((String)"tags", (String)tag.toString())));
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder).sort("start_time", SortOrder.DESC);
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName((String)"alarm_record"), sourceBuilder);
        Alarms alarms = new Alarms();
        alarms.setTotal((int)response.getHits().getTotalHits().value);
        for (SearchHit searchHit : response.getHits().getHits()) {
            AlarmRecord.Builder builder = new AlarmRecord.Builder();
            AlarmRecord alarmRecord = builder.storage2Entity(searchHit.getSourceAsMap());
            AlarmMessage message = new AlarmMessage();
            message.setId(String.valueOf(alarmRecord.getId0()));
            message.setId1(String.valueOf(alarmRecord.getId1()));
            message.setMessage(alarmRecord.getAlarmMessage());
            message.setStartTime(Long.valueOf(alarmRecord.getStartTime()));
            message.setScope(Scope.Finder.valueOf((int)alarmRecord.getScope()));
            message.setScopeId(alarmRecord.getScope());
            if (!CollectionUtils.isEmpty((byte[])alarmRecord.getTagsRawData())) {
                this.parserDataBinary(alarmRecord.getTagsRawData(), message.getTags());
            }
            alarms.getMsgs().add(message);
        }
        return alarms;
    }
}

