/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.BrowserLogQueryEsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class BrowserLogQueryEs7DAO
extends BrowserLogQueryEsDAO {
    public BrowserLogQueryEs7DAO(ElasticSearchClient client) {
        super(client);
    }

    public BrowserErrorLogs queryBrowserErrorLogs(String serviceId, String serviceVersionId, String pagePathId, String pagePath, BrowserErrorCategory category, long startSecondTB, long endSecondTB, int limit, int from) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        if (startSecondTB != 0L && endSecondTB != 0L) {
            boolQueryBuilder.must().add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (!Strings.isNullOrEmpty((String)pagePath)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("page_path");
            boolQueryBuilder.must().add(QueryBuilders.matchPhraseQuery((String)matchCName, (Object)pagePath));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (String)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceVersionId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_version_id", (String)serviceVersionId));
        }
        if (StringUtil.isNotEmpty((String)pagePathId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"pate_path_id", (String)pagePathId));
        }
        if (Objects.nonNull(category)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"error_category", (int)category.getValue()));
        }
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName((String)"browser_error_log"), sourceBuilder);
        BrowserErrorLogs logs = new BrowserErrorLogs();
        logs.setTotal((int)response.getHits().getTotalHits().value);
        for (SearchHit searchHit : response.getHits().getHits()) {
            String dataBinaryBase64 = (String)searchHit.getSourceAsMap().get("data_binary");
            if (!Objects.nonNull(dataBinaryBase64)) continue;
            BrowserErrorLog log = this.parserDataBinary(dataBinaryBase64);
            logs.getLogs().add(log);
        }
        return logs;
    }
}

