/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ESEventQueryDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class ES7EventQueryDAO
extends ESEventQueryDAO {
    public ES7EventQueryDAO(ElasticSearchClient client) {
        super(client);
    }

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        SearchSourceBuilder sourceBuilder = this.buildQuery(condition);
        return this.getEventsResultByCurrentBuilder(sourceBuilder);
    }

    public Events queryEvents(List<EventQueryCondition> conditionList) throws Exception {
        SearchSourceBuilder sourceBuilder = this.buildQuery(conditionList);
        return this.getEventsResultByCurrentBuilder(sourceBuilder);
    }

    private Events getEventsResultByCurrentBuilder(SearchSourceBuilder sourceBuilder) throws IOException {
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName((String)"events"), sourceBuilder);
        Events events = new Events();
        events.setTotal(response.getHits().getTotalHits().value);
        events.setEvents(Stream.of(response.getHits().getHits()).map(arg_0 -> ((ES7EventQueryDAO)this).parseSearchHit(arg_0)).collect(Collectors.toList()));
        return events;
    }
}

