/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch7.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class LogQueryEs7DAO
extends EsDAO
implements ILogQueryDAO {
    public LogQueryEs7DAO(ElasticSearchClient client) {
        super(client);
    }

    public boolean supportQueryLogsByKeywords() {
        return true;
    }

    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, String endpointName, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, long startSecondTB, long endSecondTB, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        List mustQueryList = boolQueryBuilder.must();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            mustQueryList.add(QueryBuilders.termQuery((String)"service_id", (String)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            mustQueryList.add(QueryBuilders.termQuery((String)"service_instance_id", (String)serviceInstanceId));
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            mustQueryList.add(QueryBuilders.termQuery((String)"endpoint_id", (String)endpointId));
        }
        if (StringUtil.isNotEmpty((String)endpointName)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("endpoint_name");
            mustQueryList.add(QueryBuilders.matchPhraseQuery((String)matchCName, (Object)endpointName));
        }
        if (Objects.nonNull(relatedTrace)) {
            if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                mustQueryList.add(QueryBuilders.termQuery((String)"trace_id", (String)relatedTrace.getTraceId()));
            }
            if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                mustQueryList.add(QueryBuilders.termQuery((String)"trace_segment_id", (String)relatedTrace.getSegmentId()));
            }
            if (Objects.nonNull(relatedTrace.getSpanId())) {
                mustQueryList.add(QueryBuilders.termQuery((String)"span_id", (Object)relatedTrace.getSpanId()));
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            tags.forEach(tag -> mustQueryList.add(QueryBuilders.termQuery((String)"tags", (String)tag.toString())));
        }
        if (CollectionUtils.isNotEmpty(keywordsOfContent)) {
            keywordsOfContent.forEach(content -> mustQueryList.add(QueryBuilders.matchPhraseQuery((String)MatchCNameBuilder.INSTANCE.build("content"), (Object)content)));
        }
        if (CollectionUtils.isNotEmpty(excludingKeywordsOfContent)) {
            excludingKeywordsOfContent.forEach(content -> boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)MatchCNameBuilder.INSTANCE.build("content"), (Object)content)));
        }
        sourceBuilder.sort("timestamp", Order.DES.equals((Object)queryOrder) ? SortOrder.DESC : SortOrder.ASC);
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(IndexController.LogicIndicesRegister.getPhysicalTableName((String)"log"), sourceBuilder);
        Logs logs = new Logs();
        logs.setTotal((int)response.getHits().getTotalHits().value);
        for (SearchHit searchHit : response.getHits().getHits()) {
            Log log = new Log();
            log.setServiceId((String)searchHit.getSourceAsMap().get("service_id"));
            log.setServiceInstanceId((String)searchHit.getSourceAsMap().get("service_instance_id"));
            log.setEndpointId((String)searchHit.getSourceAsMap().get("endpoint_id"));
            log.setEndpointName((String)searchHit.getSourceAsMap().get("endpoint_name"));
            log.setTraceId((String)searchHit.getSourceAsMap().get("trace_id"));
            log.setTimestamp(Long.valueOf(((Number)searchHit.getSourceAsMap().get("timestamp")).longValue()));
            log.setContentType(ContentType.instanceOf((int)((Number)searchHit.getSourceAsMap().get("content_type")).intValue()));
            log.setContent((String)searchHit.getSourceAsMap().get("content"));
            String dataBinaryBase64 = (String)searchHit.getSourceAsMap().get("tags_raw_data");
            if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                this.parserDataBinary(dataBinaryBase64, log.getTags());
            }
            logs.getLogs().add(log);
        }
        return logs;
    }
}

