/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.hadoop.SolrCounters;
import org.apache.solr.hadoop.SolrRecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchWriter {
    private final EmbeddedSolrServer solr;
    private volatile Exception batchWriteException = null;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final int writerThreads;
    final int queueSize;
    private final ThreadPoolExecutor batchPool;
    private TaskID taskId = null;
    AtomicInteger executingBatches = new AtomicInteger(0);

    public Exception getBatchWriteException() {
        return this.batchWriteException;
    }

    public void setBatchWriteException(Exception batchWriteException) {
        this.batchWriteException = batchWriteException;
    }

    protected UpdateResponse runUpdate(List<SolrInputDocument> batchToWrite) {
        try {
            UpdateResponse result = this.solr.add(batchToWrite);
            SolrRecordWriter.incrementCounter(this.taskId, SolrCounters.class.getName(), SolrCounters.BATCHES_WRITTEN.toString(), 1L);
            SolrRecordWriter.incrementCounter(this.taskId, SolrCounters.class.getName(), SolrCounters.DOCUMENTS_WRITTEN.toString(), batchToWrite.size());
            if (LOG.isDebugEnabled()) {
                SolrRecordWriter.incrementCounter(this.taskId, SolrCounters.class.getName(), SolrCounters.BATCH_WRITE_TIME.toString(), result.getElapsedTime());
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                this.setBatchWriteException((Exception)e);
            } else {
                this.setBatchWriteException(new Exception(e));
            }
            SolrRecordWriter.incrementCounter(this.taskId, this.getClass().getName() + ".errors", e.getClass().getName(), 1L);
            LOG.error("Unable to process batch", e);
            return null;
        }
    }

    public BatchWriter(EmbeddedSolrServer solr, int batchSize, TaskID tid, int writerThreads, int queueSize) {
        this.solr = solr;
        this.writerThreads = writerThreads;
        this.queueSize = queueSize;
        this.taskId = tid;
        this.batchPool = writerThreads != 0 ? new ExecutorUtil.MDCAwareThreadPoolExecutor(writerThreads, writerThreads, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue(queueSize), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy()) : null;
    }

    public void queueBatch(Collection<SolrInputDocument> batch) throws IOException, SolrServerException {
        this.throwIf();
        Batch b = new Batch(batch);
        if (this.batchPool != null) {
            this.batchPool.execute(b);
        } else {
            b.run();
            this.throwIf();
        }
    }

    public synchronized void close(TaskAttemptContext context) throws InterruptedException, SolrServerException, IOException {
        if (this.batchPool != null) {
            context.setStatus("Waiting for batches to complete");
            this.batchPool.shutdown();
            while (!this.batchPool.isTerminated()) {
                LOG.info(String.format(Locale.ENGLISH, "Waiting for %d items and %d threads to finish executing", this.batchPool.getQueue().size(), this.batchPool.getActiveCount()));
                this.batchPool.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        context.setStatus("Committing Solr Phase 1");
        this.solr.commit(true, false);
        context.setStatus("Optimizing Solr");
        int maxSegments = context.getConfiguration().getInt("solr.record.writer.maxSegments", 1);
        LOG.info("Optimizing Solr: forcing merge down to {} segments", (Object)maxSegments);
        long start = System.nanoTime();
        this.solr.optimize(true, false, maxSegments);
        context.getCounter(SolrCounters.class.getName(), SolrCounters.PHYSICAL_REDUCER_MERGE_TIME.toString()).increment(System.nanoTime() - start);
        float secs = (float)(System.nanoTime() - start) / 3.0f;
        LOG.info("Optimizing Solr: done forcing merge down to {} segments in {} secs", (Object)maxSegments, (Object)Float.valueOf(secs));
        context.setStatus("Committing Solr Phase 2");
        this.solr.commit(true, false);
        context.setStatus("Shutting down Solr");
        this.solr.close();
    }

    private void throwIf() throws IOException, SolrServerException {
        Exception last = this.batchWriteException;
        this.batchWriteException = null;
        if (last == null) {
            return;
        }
        if (last instanceof SolrServerException) {
            throw (SolrServerException)last;
        }
        if (last instanceof IOException) {
            throw (IOException)last;
        }
        throw new IOException("Batch Write Failure", last);
    }

    final class Batch
    implements Runnable {
        private List<SolrInputDocument> documents;
        private UpdateResponse result;

        public Batch(Collection<SolrInputDocument> batch) {
            this.documents = new ArrayList<SolrInputDocument>(batch);
        }

        @Override
        public void run() {
            try {
                BatchWriter.this.executingBatches.getAndIncrement();
                this.result = BatchWriter.this.runUpdate(this.documents);
            }
            finally {
                BatchWriter.this.executingBatches.getAndDecrement();
            }
        }

        protected List<SolrInputDocument> getDocuments() {
            return this.documents;
        }

        protected void setDocuments(List<SolrInputDocument> documents) {
            this.documents = documents;
        }

        protected UpdateResponse getResult() {
            return this.result;
        }

        protected void setResult(UpdateResponse result) {
            this.result = result;
        }

        protected void reset(List<SolrInputDocument> documents) {
            if (this.documents == null) {
                this.documents = new ArrayList<SolrInputDocument>(documents);
            } else {
                this.documents.clear();
                this.documents.addAll(documents);
            }
            this.result = null;
        }

        protected void reset(SolrInputDocument document) {
            if (this.documents == null) {
                this.documents = new ArrayList<SolrInputDocument>();
            } else {
                this.documents.clear();
            }
            this.documents.add(document);
            this.result = null;
        }
    }
}

