/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.hadoop.MapReduceIndexerTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoLive {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    GoLive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goLive(MapReduceIndexerTool.Options options, FileStatus[] outDirs) {
        LOG.info("Live merging of output shards into Solr cluster...");
        boolean success = false;
        long start = System.nanoTime();
        int concurrentMerges = options.goLiveThreads;
        ExecutorUtil.MDCAwareThreadPoolExecutor executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(concurrentMerges, concurrentMerges, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        try {
            ExecutorCompletionService<Request> completionService = new ExecutorCompletionService<Request>((Executor)executor);
            HashSet<Future<Request>> pending = new HashSet<Future<Request>>();
            int cnt = -1;
            for (FileStatus dir : outDirs) {
                LOG.debug("processing: " + dir.getPath());
                List<String> urls = options.shardUrls.get(++cnt);
                for (String url : urls) {
                    int lastPathIndex;
                    String baseUrl = url;
                    if (baseUrl.endsWith("/")) {
                        baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
                    }
                    if ((lastPathIndex = baseUrl.lastIndexOf("/")) == -1) {
                        LOG.error("Found unexpected shardurl, live merge failed: " + baseUrl);
                        boolean bl = false;
                        return bl;
                    }
                    String name = baseUrl.substring(lastPathIndex + 1);
                    String mergeUrl = baseUrl = baseUrl.substring(0, lastPathIndex);
                    Callable<Request> task = () -> {
                        Request req = new Request();
                        LOG.info("Live merge " + dir.getPath() + " into " + mergeUrl);
                        try (HttpSolrClient client = new HttpSolrClient.Builder(mergeUrl).build();){
                            CoreAdminRequest.MergeIndexes mergeRequest = new CoreAdminRequest.MergeIndexes();
                            mergeRequest.setCoreName(name);
                            mergeRequest.setIndexDirs(Arrays.asList(dir.getPath().toString() + "/data/index"));
                            mergeRequest.process((SolrClient)client);
                            req.success = true;
                        }
                        catch (IOException | SolrServerException e) {
                            req.e = e;
                        }
                        return req;
                    };
                    pending.add(completionService.submit(task));
                }
            }
            while (pending != null && pending.size() > 0) {
                try {
                    int n;
                    Future future = completionService.take();
                    if (future == null) break;
                    pending.remove(future);
                    try {
                        Request request = (Request)future.get();
                        if (request.success) continue;
                        LOG.error("A live merge command failed", (Throwable)request.e);
                        n = 0;
                        return n != 0;
                    }
                    catch (ExecutionException executionException) {
                        LOG.error("Error sending live merge command", (Throwable)executionException);
                        n = 0;
                        return n != 0;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.error("Live merge process interrupted", (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
            }
            cnt = -1;
            try {
                LOG.info("Committing live merge...");
                if (options.zkHost != null) {
                    Throwable throwable = null;
                    try (CloudSolrClient server = new CloudSolrClient.Builder().withZkHost(options.zkHost).build();){
                        server.setDefaultCollection(options.collection);
                        server.commit();
                    }
                    catch (Throwable secs) {
                        Throwable throwable2 = secs;
                        throw secs;
                    }
                }
                for (List list : options.shardUrls) {
                    for (String url : list) {
                        HttpSolrClient server = new HttpSolrClient.Builder(url).build();
                        Object object = null;
                        try {
                            server.commit();
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (server == null) continue;
                            if (object != null) {
                                try {
                                    server.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                continue;
                            }
                            server.close();
                        }
                    }
                }
                LOG.info("Done committing live merge");
            }
            catch (Exception e) {
                LOG.error("Error sending commits to live Solr cluster", (Throwable)e);
                boolean bl = false;
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executor);
                float secs = (float)(System.nanoTime() - start) / 3.0f;
                LOG.info("Live merging of index shards into Solr cluster took " + secs + " secs");
                if (success) {
                    LOG.info("Live merging completed successfully");
                } else {
                    LOG.info("Live merging failed");
                }
                return bl;
            }
            success = true;
            boolean bl = true;
            return bl;
        }
        finally {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executor);
            float secs = (float)(System.nanoTime() - start) / 3.0f;
            LOG.info("Live merging of index shards into Solr cluster took " + secs + " secs");
            if (success) {
                LOG.info("Live merging completed successfully");
            } else {
                LOG.info("Live merging failed");
            }
        }
    }

    private static final class Request {
        Exception e;
        boolean success = false;

        private Request() {
        }
    }
}

