/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeater
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile int threadsNeedingHeartBeat = 0;
    private Progressable progress;
    private final long waitTimeMs = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final CountDownLatch isClosing = new CountDownLatch(1);

    public HeartBeater(Progressable progress) {
        this.setDaemon(true);
        this.progress = progress;
        LOG.info("Heart beat reporting class is " + progress.getClass().getName());
        this.start();
    }

    public Progressable getProgress() {
        return this.progress;
    }

    public void setProgress(Progressable progress) {
        this.progress = progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("HeartBeat thread running");
        while (true) {
            try {
                do {
                    HeartBeater heartBeater = this;
                    synchronized (heartBeater) {
                        if (this.threadsNeedingHeartBeat > 0) {
                            this.progress.progress();
                            if (LOG.isInfoEnabled()) {
                                LOG.info(String.format(Locale.ENGLISH, "Issuing heart beat for %d threads", this.threadsNeedingHeartBeat));
                            }
                        } else if (LOG.isInfoEnabled()) {
                            LOG.info(String.format(Locale.ENGLISH, "heartbeat skipped count %d", this.threadsNeedingHeartBeat));
                        }
                    }
                } while (!this.isClosing.await(this.waitTimeMs, TimeUnit.MILLISECONDS));
                return;
            }
            catch (Throwable e) {
                LOG.error("HeartBeat throwable", e);
                continue;
            }
            break;
        }
    }

    public synchronized void needHeartBeat() {
        ++this.threadsNeedingHeartBeat;
        this.progress.progress();
        if (this.threadsNeedingHeartBeat == 1) {
            // empty if block
        }
    }

    public synchronized void cancelHeartBeat() {
        if (this.threadsNeedingHeartBeat > 0) {
            --this.threadsNeedingHeartBeat;
        } else {
            Exception e = new Exception("Dummy");
            e.fillInStackTrace();
            LOG.warn("extra call to cancelHeartBeat", (Throwable)e);
        }
    }

    public void setStatus(String status) {
        if (this.progress instanceof TaskInputOutputContext) {
            ((TaskInputOutputContext)this.progress).setStatus(status);
        }
    }

    public void close() {
        this.isClosing.countDown();
    }
}

