/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Random;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineRandomizerMapper
extends Mapper<LongWritable, Text, LongWritable, Text> {
    private Random random;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.random = this.createRandom(context);
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        LOGGER.debug("map key: {}, value: {}", (Object)key, (Object)value);
        context.write((Object)new LongWritable(this.random.nextLong()), (Object)value);
    }

    private Random createRandom(Mapper.Context context) {
        long taskId = 0L;
        if (context.getTaskAttemptID() != null) {
            LOGGER.debug("context.getTaskAttemptID().getId(): {}", (Object)context.getTaskAttemptID().getId());
            LOGGER.debug("context.getTaskAttemptID().getTaskID().getId(): {}", (Object)context.getTaskAttemptID().getTaskID().getId());
            taskId = context.getTaskAttemptID().getTaskID().getId();
        }
        return new Random(421439783L * (taskId + 1L));
    }
}

