/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.hadoop.SolrInputDocumentWritable;
import org.apache.solr.hadoop.ZooKeeperInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCloudPartitioner
extends Partitioner<Text, SolrInputDocumentWritable>
implements Configurable {
    private Configuration conf;
    private DocCollection docCollection;
    private Map<String, Integer> shardNumbers;
    private int shards = 0;
    private final SolrParams emptySolrParams = new MapSolrParams(Collections.EMPTY_MAP);
    public static final String SHARDS = SolrCloudPartitioner.class.getName() + ".shards";
    public static final String ZKHOST = SolrCloudPartitioner.class.getName() + ".zkHost";
    public static final String COLLECTION = SolrCloudPartitioner.class.getName() + ".collection";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.shards = conf.getInt(SHARDS, -1);
        if (this.shards <= 0) {
            throw new IllegalArgumentException("Illegal shards: " + this.shards);
        }
        String zkHost = conf.get(ZKHOST);
        if (zkHost == null) {
            throw new IllegalArgumentException("zkHost must not be null");
        }
        String collection = conf.get(COLLECTION);
        if (collection == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        LOG.info("Using SolrCloud zkHost: {}, collection: {}", (Object)zkHost, (Object)collection);
        this.docCollection = new ZooKeeperInspector().extractDocCollection(zkHost, collection);
        if (this.docCollection == null) {
            throw new IllegalArgumentException("docCollection must not be null");
        }
        if (this.docCollection.getSlicesMap().size() != this.shards) {
            throw new IllegalArgumentException("Incompatible shards: + " + this.shards + " for docCollection: " + this.docCollection);
        }
        List<Slice> slices = new ZooKeeperInspector().getSortedSlices(this.docCollection.getSlices());
        if (slices.size() != this.shards) {
            throw new IllegalStateException("Incompatible sorted shards: + " + this.shards + " for docCollection: " + this.docCollection);
        }
        this.shardNumbers = new HashMap<String, Integer>(10 * slices.size());
        for (int i = 0; i < slices.size(); ++i) {
            this.shardNumbers.put(slices.get(i).getName(), i);
        }
        LOG.debug("Using SolrCloud docCollection: {}", (Object)this.docCollection);
        DocRouter docRouter = this.docCollection.getRouter();
        if (docRouter == null) {
            throw new IllegalArgumentException("docRouter must not be null");
        }
        LOG.info("Using SolrCloud docRouterClass: {}", docRouter.getClass());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int getPartition(Text key, SolrInputDocumentWritable value, int numPartitions) {
        DocRouter docRouter = this.docCollection.getRouter();
        SolrInputDocument doc = value.getSolrInputDocument();
        String keyStr = key.toString();
        Slice slice = docRouter.getTargetSlice(keyStr, doc, null, this.emptySolrParams, this.docCollection);
        if (slice == null) {
            throw new IllegalStateException("No matching slice found! The slice seems unavailable. docRouterClass: " + docRouter.getClass().getName());
        }
        int rootShard = this.shardNumbers.get(slice.getName());
        if (rootShard < 0 || rootShard >= this.shards) {
            throw new IllegalStateException("Illegal shard number " + rootShard + " for slice: " + slice + ", docCollection: " + this.docCollection);
        }
        assert (numPartitions % this.shards == 0);
        int hashCode = Hash.murmurhash3_x86_32((CharSequence)keyStr, (int)0, (int)keyStr.length(), (int)0);
        int offset = (hashCode & Integer.MAX_VALUE) % (numPartitions / this.shards);
        int microShard = rootShard * (numPartitions / this.shards) + offset;
        assert (microShard >= 0 && microShard < numPartitions);
        return microShard;
    }
}

