/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.util.Progressable;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.HdfsDirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.hadoop.BatchWriter;
import org.apache.solr.hadoop.HeartBeater;
import org.apache.solr.hadoop.SolrInputDocumentWritable;
import org.apache.solr.hadoop.SolrOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrRecordWriter<K, V>
extends RecordWriter<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final List<String> allowedConfigDirectories = new ArrayList<String>(Arrays.asList("conf", "lib", "solr.xml", "core1"));
    public static final Set<String> requiredConfigDirectories = new HashSet<String>();
    private final HeartBeater heartBeater;
    private final BatchWriter batchWriter;
    private final List<SolrInputDocument> batch;
    private final int batchSize;
    private long numDocsWritten = 0L;
    private long nextLogTime = System.nanoTime();
    private static HashMap<TaskID, Reducer.Context> contextMap;

    public static List<String> getAllowedConfigDirectories() {
        return Collections.unmodifiableList(allowedConfigDirectories);
    }

    public static boolean isRequiredConfigDirectory(String directory) {
        return requiredConfigDirectories.contains(directory);
    }

    public SolrRecordWriter(TaskAttemptContext context, Path outputShardDir, int batchSize) {
        this.batchSize = batchSize;
        this.batch = new ArrayList<SolrInputDocument>(batchSize);
        Configuration conf = context.getConfiguration();
        this.heartBeater = new HeartBeater((Progressable)context);
        try {
            this.heartBeater.needHeartBeat();
            Path solrHomeDir = SolrRecordWriter.findSolrConfig(conf);
            FileSystem fs = outputShardDir.getFileSystem(conf);
            EmbeddedSolrServer solr = SolrRecordWriter.createEmbeddedSolrServer(solrHomeDir, fs, outputShardDir);
            this.batchWriter = new BatchWriter(solr, batchSize, context.getTaskAttemptID().getTaskID(), SolrOutputFormat.getSolrWriterThreadCount(conf), SolrOutputFormat.getSolrWriterQueueSize(conf));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Failed to initialize record writer for %s, %s", context.getJobName(), conf.get("mapred.task.id")), e);
        }
        finally {
            this.heartBeater.cancelHeartBeat();
        }
    }

    public static EmbeddedSolrServer createEmbeddedSolrServer(Path solrHomeDir, FileSystem fs, Path outputShardDir) throws IOException {
        LOG.info("Creating embedded Solr server with solrHomeDir: " + solrHomeDir + ", fs: " + fs + ", outputShardDir: " + outputShardDir);
        Path solrDataDir = new Path(outputShardDir, "data");
        String dataDirStr = solrDataDir.toUri().toString();
        SolrResourceLoader loader = new SolrResourceLoader(Paths.get(solrHomeDir.toString(), new String[0]), null, null);
        LOG.info(String.format(Locale.ENGLISH, "Constructed instance information solr.home %s (%s), instance dir %s, conf dir %s, writing index to solr.data.dir %s, with permdir %s", solrHomeDir, solrHomeDir.toUri(), loader.getInstancePath(), loader.getConfigDir(), dataDirStr, outputShardDir));
        System.setProperty("solr.directoryFactory", HdfsDirectoryFactory.class.getName());
        System.setProperty("solr.lock.type", "hdfs");
        System.setProperty("solr.hdfs.nrtcachingdirectory", "false");
        System.setProperty("solr.hdfs.blockcache.enabled", "false");
        System.setProperty("solr.autoCommit.maxTime", "600000");
        System.setProperty("solr.autoSoftCommit.maxTime", "-1");
        CoreContainer container = new CoreContainer(loader);
        container.load();
        SolrCore core = container.create("", (Map)ImmutableMap.of((Object)"dataDir", (Object)dataDirStr));
        if (!(core.getDirectoryFactory() instanceof HdfsDirectoryFactory)) {
            throw new UnsupportedOperationException("Invalid configuration. Currently, the only DirectoryFactory supported is " + HdfsDirectoryFactory.class.getSimpleName());
        }
        EmbeddedSolrServer solr = new EmbeddedSolrServer(container, "");
        return solr;
    }

    public static void incrementCounter(TaskID taskId, String groupName, String counterName, long incr) {
        Reducer.Context context = contextMap.get(taskId);
        if (context != null) {
            context.getCounter(groupName, counterName).increment(incr);
        }
    }

    public static void incrementCounter(TaskID taskId, Enum<?> counterName, long incr) {
        Reducer.Context context = contextMap.get(taskId);
        if (context != null) {
            context.getCounter(counterName).increment(incr);
        }
    }

    public static void addReducerContext(Reducer.Context context) {
        TaskID taskID = context.getTaskAttemptID().getTaskID();
        contextMap.put(taskID, context);
    }

    public static Path findSolrConfig(Configuration conf) throws IOException {
        Path[] localArchives;
        for (Path unpackedDir : localArchives = DistributedCache.getLocalCacheArchives((Configuration)conf)) {
            if (!unpackedDir.getName().equals(SolrOutputFormat.getZipName(conf))) continue;
            LOG.info("Using this unpacked directory as solr home: {}", (Object)unpackedDir);
            return unpackedDir;
        }
        throw new IOException(String.format(Locale.ENGLISH, "No local cache archives, where is %s:%s", SolrOutputFormat.getSetupOk(), SolrOutputFormat.getZipName(conf)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(K key, V value) throws IOException {
        this.heartBeater.needHeartBeat();
        try {
            try {
                SolrInputDocumentWritable sidw = (SolrInputDocumentWritable)value;
                this.batch.add(sidw.getSolrInputDocument());
                if (this.batch.size() >= this.batchSize) {
                    this.batchWriter.queueBatch(this.batch);
                    this.numDocsWritten += (long)this.batch.size();
                    if (System.nanoTime() >= this.nextLogTime) {
                        LOG.info("docsWritten: {}", (Object)this.numDocsWritten);
                        this.nextLogTime += TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
                    }
                    this.batch.clear();
                }
            }
            catch (SolrServerException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.heartBeater.cancelHeartBeat();
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (context != null) {
            this.heartBeater.setProgress((Progressable)context);
        }
        try {
            this.heartBeater.needHeartBeat();
            if (this.batch.size() > 0) {
                this.batchWriter.queueBatch(this.batch);
                this.numDocsWritten += (long)this.batch.size();
                this.batch.clear();
            }
            LOG.info("docsWritten: {}", (Object)this.numDocsWritten);
            this.batchWriter.close(context);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        finally {
            this.heartBeater.cancelHeartBeat();
            this.heartBeater.close();
        }
        context.setStatus("Done");
    }

    static {
        requiredConfigDirectories.add("conf");
        contextMap = new HashMap();
    }
}

