/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop.dedup;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.hadoop.Utils;
import org.apache.solr.hadoop.dedup.SolrInputDocumentComparator;
import org.apache.solr.hadoop.dedup.UpdateConflictResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainMostRecentUpdateConflictResolver
implements UpdateConflictResolver,
Configurable {
    private Configuration conf;
    private String orderByFieldName = "file_last_modified";
    public static final String ORDER_BY_FIELD_NAME_KEY = RetainMostRecentUpdateConflictResolver.class.getName() + ".orderByFieldName";
    public static final String ORDER_BY_FIELD_NAME_DEFAULT = "file_last_modified";
    public static final String COUNTER_GROUP = Utils.getShortClassName(RetainMostRecentUpdateConflictResolver.class);
    public static final String DUPLICATES_COUNTER_NAME = "Number of documents ignored as duplicates";
    public static final String OUTDATED_COUNTER_NAME = "Number of documents ignored as outdated";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.orderByFieldName = conf.get(ORDER_BY_FIELD_NAME_KEY, this.orderByFieldName);
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected String getOrderByFieldName() {
        return this.orderByFieldName;
    }

    @Override
    public Iterator<SolrInputDocument> orderUpdates(Text key, Iterator<SolrInputDocument> updates, Reducer.Context ctx) {
        return this.getMaximum(updates, this.getOrderByFieldName(), new SolrInputDocumentComparator.TimeStampComparator(), ctx);
    }

    protected Iterator<SolrInputDocument> getMaximum(Iterator<SolrInputDocument> updates, String fieldName, Comparator child, Reducer.Context context) {
        SolrInputDocumentComparator comp = new SolrInputDocumentComparator(fieldName, child);
        SolrInputDocument max = null;
        long numDupes = 0L;
        long numOutdated = 0L;
        while (updates.hasNext()) {
            SolrInputDocument next = updates.next();
            assert (next != null);
            if (max == null) {
                max = next;
                continue;
            }
            int c = comp.compare(next, max);
            if (c == 0) {
                LOG.debug("Ignoring document version because it is a duplicate: {}", (Object)next);
                ++numDupes;
                continue;
            }
            if (c > 0) {
                LOG.debug("Ignoring document version because it is outdated: {}", (Object)max);
                max = next;
                ++numOutdated;
                continue;
            }
            LOG.debug("Ignoring document version because it is outdated: {}", (Object)next);
            ++numOutdated;
        }
        assert (max != null);
        if (numDupes > 0L) {
            context.getCounter(COUNTER_GROUP, DUPLICATES_COUNTER_NAME).increment(numDupes);
        }
        if (numOutdated > 0L) {
            context.getCounter(COUNTER_GROUP, OUTDATED_COUNTER_NAME).increment(numOutdated);
        }
        return Collections.singletonList(max).iterator();
    }
}

