/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop.morphline;

import com.codahale.metrics.Counting;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.hadoop.HeartBeater;
import org.apache.solr.hadoop.SolrInputDocumentWritable;
import org.apache.solr.hadoop.SolrMapper;
import org.apache.solr.hadoop.morphline.MorphlineCounters;
import org.apache.solr.hadoop.morphline.MorphlineMapRunner;
import org.apache.solr.morphlines.solr.DocumentLoader;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphlineMapper
extends SolrMapper<LongWritable, Text> {
    private Mapper.Context context;
    private MorphlineMapRunner runner;
    private HeartBeater heartBeater;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected IndexSchema getSchema() {
        return this.runner.getSchema();
    }

    protected Mapper.Context getContext() {
        return this.context;
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.context = context;
        this.heartBeater = new HeartBeater((Progressable)context);
        this.runner = new MorphlineMapRunner(context.getConfiguration(), new MyDocumentLoader(), this.getSolrHomeDir().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.heartBeater.needHeartBeat();
        try {
            this.runner.map(value.toString(), context.getConfiguration(), context);
        }
        finally {
            this.heartBeater.cancelHeartBeat();
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.heartBeater.close();
        this.runner.cleanup();
        this.addMetricsToMRCounters(this.runner.getMorphlineContext().getMetricRegistry(), context);
        super.cleanup(context);
    }

    private void addMetricsToMRCounters(MetricRegistry metricRegistry, Mapper.Context context) {
        for (Map.Entry entry : metricRegistry.getCounters().entrySet()) {
            this.addCounting((String)entry.getKey(), (Counting)entry.getValue(), 1L);
        }
        for (Map.Entry entry : metricRegistry.getHistograms().entrySet()) {
            this.addCounting((String)entry.getKey(), (Counting)entry.getValue(), 1L);
        }
        for (Map.Entry entry : metricRegistry.getMeters().entrySet()) {
            this.addCounting((String)entry.getKey(), (Counting)entry.getValue(), 1L);
        }
        for (Map.Entry entry : metricRegistry.getTimers().entrySet()) {
            long nanosPerMilliSec = 1000000L;
            this.addCounting((String)entry.getKey(), (Counting)entry.getValue(), nanosPerMilliSec);
        }
    }

    private void addCounting(String metricName, Counting value, long scale) {
        this.context.getCounter("morphline", metricName).increment(value.getCount() / scale);
    }

    private final class MyDocumentLoader
    implements DocumentLoader {
        private MyDocumentLoader() {
        }

        public void beginTransaction() {
        }

        public void load(SolrInputDocument doc) throws IOException, SolrServerException {
            String uniqueKeyFieldName = MorphlineMapper.this.getSchema().getUniqueKeyField().getName();
            Object id = doc.getFieldValue(uniqueKeyFieldName);
            if (id == null) {
                throw new IllegalArgumentException("Missing value for (required) unique document key: " + uniqueKeyFieldName + " (see Solr schema.xml)");
            }
            try {
                MorphlineMapper.this.context.write((Object)new Text(id.toString()), (Object)new SolrInputDocumentWritable(doc));
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while writing " + doc, e);
            }
            if (LOG.isDebugEnabled()) {
                long numParserOutputBytes = 0L;
                for (SolrInputField field : doc.values()) {
                    numParserOutputBytes += this.sizeOf(field.getValue());
                }
                MorphlineMapper.this.context.getCounter(MorphlineCounters.class.getName(), MorphlineCounters.PARSER_OUTPUT_BYTES.toString()).increment(numParserOutputBytes);
            }
            MorphlineMapper.this.context.getCounter(MorphlineCounters.class.getName(), MorphlineCounters.DOCS_READ.toString()).increment(1L);
        }

        private long sizeOf(Object value) {
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length();
            }
            if (value instanceof Integer) {
                return 4L;
            }
            if (value instanceof Long) {
                return 8L;
            }
            if (value instanceof Collection) {
                long size = 0L;
                for (Object val : (Collection)value) {
                    size += this.sizeOf(val);
                }
                return size;
            }
            return String.valueOf(value).length();
        }

        public void commitTransaction() {
        }

        public UpdateResponse rollbackTransaction() throws SolrServerException, IOException {
            return new UpdateResponse();
        }

        public void shutdown() {
        }

        public SolrPingResponse ping() throws SolrServerException, IOException {
            return new SolrPingResponse();
        }
    }
}

