/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Random;
import org.apache.spark.sql.HashByteArrayBenchmark$;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;

public final class HashByteArrayBenchmark$ {
    public static final HashByteArrayBenchmark$ MODULE$;

    static {
        new HashByteArrayBenchmark$();
    }

    public void test(int length, long seed, int numArrays, int iters) {
        Random random = new Random(seed);
        byte[][] arrays = (byte[][])Array$.MODULE$.fill(numArrays, (Function0)new Serializable(length, random){
            public static final long serialVersionUID = 0L;
            private final int length$1;
            private final Random random$1;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply() {
                void var1_1;
                byte[] bytes = new byte[this.length$1];
                this.random$1.nextBytes(bytes);
                return var1_1;
            }
            {
                this.length$1 = length$1;
                this.random$1 = random$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Benchmark benchmark = new Benchmark(new StringBuilder().append((Object)"Hash byte arrays with length ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (long)(iters * numArrays), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Murmur3_x86_32", benchmark.addCase$default$2(), (Function1)new Serializable(length, numArrays, iters, arrays){
            public static final long serialVersionUID = 0L;
            public final int length$1;
            public final int numArrays$1;
            private final int iters$1;
            public final byte[][] arrays$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.test.1 $outer;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        int sum = 0;
                        for (int i = 0; i < this.$outer.numArrays$1; ++i) {
                            sum += Murmur3_x86_32.hashUnsafeBytes((Object)this.$outer.arrays$1[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)this.$outer.length$1, (int)42);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.length$1 = length$1;
                this.numArrays$1 = numArrays$1;
                this.iters$1 = iters$1;
                this.arrays$1 = arrays$1;
            }
        });
        benchmark.addCase("xxHash 64-bit", benchmark.addCase$default$2(), (Function1)new Serializable(length, numArrays, iters, arrays){
            public static final long serialVersionUID = 0L;
            public final int length$1;
            public final int numArrays$1;
            private final int iters$1;
            public final byte[][] arrays$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.test.2 $outer;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        long sum = 0L;
                        for (int i = 0; i < this.$outer.numArrays$1; ++i) {
                            sum += XXH64.hashUnsafeBytes((Object)this.$outer.arrays$1[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)this.$outer.length$1, (long)42L);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.length$1 = length$1;
                this.numArrays$1 = numArrays$1;
                this.iters$1 = iters$1;
                this.arrays$1 = arrays$1;
            }
        });
        benchmark.run();
    }

    public void main(String[] args) {
        this.test(8, 42L, 1024, 2048);
        this.test(16, 42L, 1024, 2048);
        this.test(24, 42L, 1024, 2048);
        this.test(31, 42L, 1024, 2048);
        this.test(95, 42L, 1024, 2048);
        this.test(287, 42L, 1024, 2048);
        this.test(1055, 42L, 1024, 2048);
        this.test(2079, 42L, 1024, 2048);
        this.test(8223, 42L, 1024, 2048);
    }

    private HashByteArrayBenchmark$() {
        MODULE$ = this;
    }
}

