/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.File;
import java.net.URI;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn$;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogSuite$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00113Q!\u0001\u0002\u0002\u0002=\u0011A#\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ*vSR,'BA\u0002\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/1\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005e1\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!D\tC\u0005)Q\u000f^5mgV\t!\u0005\u0005\u0002\u001fG%\u0011AE\u0001\u0002\u0011\u0007\u0006$\u0018\r\\8h)\u0016\u001cH/\u0016;jYNDQA\n\u0001\u0005\u0012\u001d\n!B]3tKR\u001cF/\u0019;f)\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#\u0001B+oSRDQa\f\u0001\u0005B\u001d\n\u0011\"\u00194uKJ,\u0015m\u00195\t\u000bE\u0002A\u0011\u0002\u001a\u0002\r\u0015D\u0018n\u001d;t)\r\u0019dg\u0010\t\u0003SQJ!!\u000e\u0016\u0003\u000f\t{w\u000e\\3b]\")q\u0007\ra\u0001q\u0005\u0019QO]5\u0011\u0005ebdBA\u0015;\u0013\tY$&\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e+\u0011\u0015\u0001\u0005\u00071\u0001B\u0003!\u0019\u0007.\u001b7ee\u0016t\u0007cA\u0015Cq%\u00111I\u000b\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public abstract class ExternalCatalogSuite
extends SparkFunSuite
implements BeforeAndAfterEach {
    public Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public abstract CatalogTestUtils utils();

    public void resetState() {
    }

    public void afterEach() {
        try {
            this.resetState();
            return;
        }
        finally {
            BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
        }
    }

    public boolean org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(String uri, Seq<String> children) {
        File base = new File(new URI(uri));
        return ((File)children.foldLeft((Object)base, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(File x0$1, String x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    File parent = (File)tuple2._1();
                    String child = (String)tuple2._2();
                    File file = new File(parent, child);
                    return file;
                }
                throw new MatchError((Object)tuple2);
            }
        })).exists();
    }

    public ExternalCatalogSuite() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.test("basic create and list databases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("default"), true);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("default"), "catalog.databaseExists(\"default\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                catalog.createDatabase(this.$outer.utils().newDb("testing"), false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                catalog.createDatabase(this.$outer.utils().newDb("testing2"), false);
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing", "testing2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("does_not_exist"), "catalog.databaseExists(\"does_not_exist\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get database when a database exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CatalogDatabase db1 = this.$outer.utils().newBasicCatalog().getDatabase("db1");
                String $org_scalatest_assert_macro_left = db1.name();
                String $org_scalatest_assert_macro_right = "db1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = db1.description();
                String $org_scalatest_assert_macro_right2 = "db1";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final CatalogDatabase apply() {
                        return this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newBasicCatalog().getDatabase("db_that_does_not_exist");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list databases without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list databases with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listDatabases("db").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases("db*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1", "db2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = catalog.listDatabases("*1").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = catalog.listDatabases("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db2"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.dropDatabase("db1", false, false);
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database when the database is not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog1 = this.$outer.utils().newBasicCatalog();
                catalog1.dropTable("db2", "tbl1", false);
                catalog1.dropTable("db2", "tbl2", false);
                this.$outer.intercept((Function0)new Serializable(this, catalog1){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog1$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.catalog1$1 = catalog1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.resetState();
                ExternalCatalog catalog2 = this.$outer.utils().newBasicCatalog();
                catalog2.dropFunction("db2", "func1");
                this.$outer.intercept((Function0)new Serializable(this, catalog2){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog2$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.catalog2$1 = catalog2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.resetState();
                ExternalCatalog catalog3 = this.$outer.utils().newBasicCatalog();
                catalog3.dropDatabase("db2", false, true);
                Set $org_scalatest_assert_macro_left = catalog3.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$1.dropDatabase("db_that_does_not_exist", false, false);
                    }
                    {
                        this.catalog$1 = catalog$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropDatabase("db_that_does_not_exist", true, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db1 = catalog.getDatabase("db1");
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"good"), (Object)"true")}));
                String x$4 = db1.copy$default$1();
                String x$5 = db1.copy$default$2();
                String x$6 = db1.copy$default$3();
                catalog.alterDatabase(db1.copy(x$4, x$5, x$6, x$3));
                CatalogDatabase newDb1 = catalog.getDatabase("db1");
                Map $org_scalatest_assert_macro_left = db1.properties();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = newDb1.properties();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = newDb1.properties().get((Object)"k");
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"v3");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left4 = newDb1.properties().get((Object)"good");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"true");
                Option option2 = $org_scalatest_assert_macro_left4;
                Some some2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newBasicCatalog().alterDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newDb("does_not_exist"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("the table type of an external table should be EXTERNAL_TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable qual$1 = this.$outer.utils().newTable("external_table1", "db2");
                CatalogTableType x$7 = CatalogTableType$.MODULE$.EXTERNAL();
                TableIdentifier x$8 = qual$1.copy$default$1();
                CatalogStorageFormat x$9 = qual$1.copy$default$3();
                Seq x$10 = qual$1.copy$default$4();
                Seq x$11 = qual$1.copy$default$5();
                Seq x$12 = qual$1.copy$default$6();
                Seq x$13 = qual$1.copy$default$7();
                int x$14 = qual$1.copy$default$8();
                String x$15 = qual$1.copy$default$9();
                long x$16 = qual$1.copy$default$10();
                long x$17 = qual$1.copy$default$11();
                Map x$18 = qual$1.copy$default$12();
                Option x$19 = qual$1.copy$default$13();
                Option x$20 = qual$1.copy$default$14();
                Option x$21 = qual$1.copy$default$15();
                Seq x$22 = qual$1.copy$default$16();
                CatalogTable table = qual$1.copy(x$8, x$7, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
                catalog.createTable("db2", table, false);
                CatalogTable actual = catalog.getTable("db2", "external_table1");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(actual.tableType());
                CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropTable("db2", "tbl1", false);
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropTable("unknown_db", "unknown_table", false);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropTable("unknown_db", "unknown_table", true);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropTable("db2", "unknown_table", false);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropTable("db2", "unknown_table", true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.renameTable("db2", "tbl1", "tblone");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.renameTable("unknown_db", "unknown_table", "unknown_table");
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.renameTable("db2", "unknown_table", "unknown_table");
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table when destination table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$4.renameTable("db2", "tbl1", "tbl2");
                    }
                    {
                        this.catalog$4 = catalog$4;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable tbl1 = catalog.getTable("db2", "tbl1");
                Map x$23 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toh"), (Object)"frem")}));
                TableIdentifier x$24 = tbl1.copy$default$1();
                CatalogTableType x$25 = tbl1.copy$default$2();
                CatalogStorageFormat x$26 = tbl1.copy$default$3();
                Seq x$27 = tbl1.copy$default$4();
                Seq x$28 = tbl1.copy$default$5();
                Seq x$29 = tbl1.copy$default$6();
                Seq x$30 = tbl1.copy$default$7();
                int x$31 = tbl1.copy$default$8();
                String x$32 = tbl1.copy$default$9();
                long x$33 = tbl1.copy$default$10();
                long x$34 = tbl1.copy$default$11();
                Option x$35 = tbl1.copy$default$13();
                Option x$36 = tbl1.copy$default$14();
                Option x$37 = tbl1.copy$default$15();
                Seq x$38 = tbl1.copy$default$16();
                catalog.alterTable("db2", tbl1.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$23, x$35, x$36, x$37, x$38));
                CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
                Map $org_scalatest_assert_macro_left = tbl1.properties();
                String $org_scalatest_assert_macro_right = "toh";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = newTbl1.properties();
                int $org_scalatest_assert_macro_right2 = tbl1.properties().size() + 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = newTbl1.properties().get((Object)"toh");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"frem");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;
                    private final ExternalCatalog catalog$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$5.alterTable("unknown_db", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newTable("tbl1", "unknown_db"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;
                    private final ExternalCatalog catalog$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$5.alterTable("db2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newTable("unknown_table", "db2"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String $org_scalatest_assert_macro_left = this.$outer.utils().newBasicCatalog().getTable("db2", "tbl1").identifier().table();
                String $org_scalatest_assert_macro_right = "tbl1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$6;

                    public final CatalogTable apply() {
                        return this.catalog$6.getTable("unknown_db", "unknown_table");
                    }
                    {
                        this.catalog$6 = catalog$6;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$6;

                    public final CatalogTable apply() {
                        return this.catalog$6.getTable("db2", "unknown_table");
                    }
                    {
                        this.catalog$6 = catalog$6;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list tables without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$7;

                    public final Seq<String> apply() {
                        return this.catalog$7.listTables("unknown_db");
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list tables with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$8;

                    public final Seq<String> apply() {
                        return this.catalog$8.listTables("unknown_db", "*");
                    }
                    {
                        this.catalog$8 = catalog$8;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1", "*").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = catalog.listTables("db2", "tbl*").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = catalog.listTables("db2", "*1").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("basic create and list partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("mydb"), false);
                catalog.createTable("mydb", this.$outer.utils().newTable("tbl", "mydb"), false);
                catalog.createPartitions("mydb", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "mydb", "tbl", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"mydb\", \"tbl\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$9;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$9.createPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$9 = catalog$9;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$9;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$9.createPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$9 = catalog$9;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions that already exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$25 $outer;
                    private final ExternalCatalog catalog$10;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$10.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$10 = catalog$10;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), true);
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec()})), false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.resetState();
                ExternalCatalog catalog2 = this.$outer.utils().newBasicCatalog();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog2, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog2, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                catalog2.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec(), this.$outer.utils().part2().spec()})), false);
                Seq $org_scalatest_assert_macro_left = catalog2.listPartitions("db2", "tbl2", catalog2.listPartitions$default$3());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$11;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$11.dropPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$11 = catalog$11;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$11;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$11.dropPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$11 = catalog$11;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions that do not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$28 $outer;
                    private final ExternalCatalog catalog$12;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$12.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part3().spec()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$12 = catalog$12;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part3().spec()})), true);
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Map $org_scalatest_assert_macro_left = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec()).spec();
                Map $org_scalatest_assert_macro_right = this.$outer.utils().part1().spec();
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec()).spec();
                Map $org_scalatest_assert_macro_right2 = this.$outer.utils().part2().spec();
                Map map3 = $org_scalatest_assert_macro_left2;
                Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$29 $outer;
                    private final ExternalCatalog catalog$13;

                    public final CatalogTablePartition apply() {
                        return this.catalog$13.getPartition("db2", "tbl1", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part3().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$13 = catalog$13;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;
                    private final ExternalCatalog catalog$14;

                    public final CatalogTablePartition apply() {
                        return this.catalog$14.getPartition("does_not_exist", "tbl1", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$14 = catalog$14;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;
                    private final ExternalCatalog catalog$14;

                    public final CatalogTablePartition apply() {
                        return this.catalog$14.getPartition("db2", "does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$14 = catalog$14;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTablePartition newPart1 = this.$outer.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"101")})), this.$outer.utils().part1().copy$default$2(), this.$outer.utils().part1().copy$default$3());
                CatalogTablePartition newPart2 = this.$outer.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"201")})), this.$outer.utils().part2().copy$default$2(), this.$outer.utils().part2().copy$default$3());
                Seq newSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{newPart1.spec(), newPart2.spec()}));
                catalog.renamePartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec(), this.$outer.utils().part2().spec()})), newSpecs);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart1.spec()).spec());
                Map $org_scalatest_assert_macro_right = newPart1.spec();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart2.spec()).spec());
                Map $org_scalatest_assert_macro_right2 = newPart2.spec();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$31 $outer;
                    private final ExternalCatalog catalog$15;

                    public final CatalogTablePartition apply() {
                        return this.catalog$15.getPartition("db2", "tbl2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$15 = catalog$15;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$31 $outer;
                    private final ExternalCatalog catalog$15;

                    public final CatalogTablePartition apply() {
                        return this.catalog$15.getPartition("db2", "tbl2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$15 = catalog$15;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$32 $outer;
                    private final ExternalCatalog catalog$16;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$16.renamePartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$16 = catalog$16;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$32 $outer;
                    private final ExternalCatalog catalog$16;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$16.renamePartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$16 = catalog$16;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions when the new partition already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$33 $outer;
                    private final ExternalCatalog catalog$17;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$17.renamePartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                try {
                    catalog.setCurrentDatabase("db2");
                    String newLocation = this.$outer.utils().newUriForDatabase();
                    String newSerde = "com.sparkbricks.text.EasySerde";
                    Map newSerdeProps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spark"), (Object)"bricks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"compressed"), (Object)"false")}));
                    CatalogTablePartition oldPart1 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition oldPart2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    CatalogTablePartition[] catalogTablePartitionArray = new CatalogTablePartition[2];
                    CatalogStorageFormat x$39 = this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5(), this.$outer.utils().storageFormat().copy$default$6());
                    Map x$40 = oldPart1.copy$default$1();
                    Map x$41 = oldPart1.copy$default$3();
                    catalogTablePartitionArray[0] = oldPart1.copy(x$40, x$39, x$41);
                    CatalogStorageFormat x$42 = this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5(), this.$outer.utils().storageFormat().copy$default$6());
                    Map x$43 = oldPart2.copy$default$1();
                    Map x$44 = oldPart2.copy$default$3();
                    catalogTablePartitionArray[1] = oldPart2.copy(x$43, x$42, x$44);
                    catalog.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])catalogTablePartitionArray)));
                    CatalogTablePartition newPart1 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition newPart2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    Option $org_scalatest_assert_macro_left = newPart1.storage().locationUri();
                    Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
                    Option option = $org_scalatest_assert_macro_left;
                    Some some = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Option $org_scalatest_assert_macro_left2 = newPart2.storage().locationUri();
                    Some $org_scalatest_assert_macro_right2 = new Some((Object)newLocation);
                    Option option2 = $org_scalatest_assert_macro_left2;
                    Some some2 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    Option $org_scalatest_assert_macro_left3 = oldPart1.storage().locationUri();
                    Some $org_scalatest_assert_macro_right3 = new Some((Object)newLocation);
                    Option option3 = $org_scalatest_assert_macro_left3;
                    Some some3 = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, option3 != null ? !option3.equals(some3) : some3 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    Option $org_scalatest_assert_macro_left4 = oldPart2.storage().locationUri();
                    Some $org_scalatest_assert_macro_right4 = new Some((Object)newLocation);
                    Option option4 = $org_scalatest_assert_macro_left4;
                    Some some4 = $org_scalatest_assert_macro_right4;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, option4 != null ? !option4.equals(some4) : some4 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    CatalogTablePartition[] catalogTablePartitionArray2 = new CatalogTablePartition[2];
                    Some x$45 = new Some((Object)newSerde);
                    Option x$46 = this.$outer.utils().storageFormat().copy$default$1();
                    Option x$47 = this.$outer.utils().storageFormat().copy$default$2();
                    Option x$48 = this.$outer.utils().storageFormat().copy$default$3();
                    boolean x$49 = this.$outer.utils().storageFormat().copy$default$5();
                    Map x$50 = this.$outer.utils().storageFormat().copy$default$6();
                    CatalogStorageFormat x$51 = this.$outer.utils().storageFormat().copy(x$46, x$47, x$48, (Option)x$45, x$49, x$50);
                    Map x$52 = oldPart1.copy$default$1();
                    Map x$53 = oldPart1.copy$default$3();
                    catalogTablePartitionArray2[0] = oldPart1.copy(x$52, x$51, x$53);
                    Map x$54 = newSerdeProps;
                    Option x$55 = this.$outer.utils().storageFormat().copy$default$1();
                    Option x$56 = this.$outer.utils().storageFormat().copy$default$2();
                    Option x$57 = this.$outer.utils().storageFormat().copy$default$3();
                    Option x$58 = this.$outer.utils().storageFormat().copy$default$4();
                    boolean x$59 = this.$outer.utils().storageFormat().copy$default$5();
                    CatalogStorageFormat x$60 = this.$outer.utils().storageFormat().copy(x$55, x$56, x$57, x$58, x$59, x$54);
                    Map x$61 = oldPart2.copy$default$1();
                    Map x$62 = oldPart2.copy$default$3();
                    catalogTablePartitionArray2[1] = oldPart2.copy(x$61, x$60, x$62);
                    catalog.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])catalogTablePartitionArray2)));
                    CatalogTablePartition newPart1b = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition newPart2b = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    Option $org_scalatest_assert_macro_left5 = newPart1b.storage().serde();
                    Some $org_scalatest_assert_macro_right5 = new Some((Object)newSerde);
                    Option option5 = $org_scalatest_assert_macro_left5;
                    Some some5 = $org_scalatest_assert_macro_right5;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    Map $org_scalatest_assert_macro_left6 = newPart2b.storage().serdeProperties();
                    Map $org_scalatest_assert_macro_right6 = newSerdeProps;
                    Map map = $org_scalatest_assert_macro_left6;
                    Map map2 = $org_scalatest_assert_macro_right6;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(map != null ? !map.equals(map2) : map2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    CatalogTablePartition badPart1 = this.$outer.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"v2")})), this.$outer.utils().part1().copy$default$2(), this.$outer.utils().part1().copy$default$3());
                    CatalogTablePartition badPart2 = this.$outer.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"v4")})), this.$outer.utils().part2().copy$default$2(), this.$outer.utils().part2().copy$default$3());
                    this.$outer.intercept((Function0)new Serializable(this, catalog, badPart1, badPart2){
                        public static final long serialVersionUID = 0L;
                        private final ExternalCatalog catalog$18;
                        private final CatalogTablePartition badPart1$1;
                        private final CatalogTablePartition badPart2$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.catalog$18.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.badPart1$1, this.badPart2$1})));
                        }
                        {
                            this.catalog$18 = catalog$18;
                            this.badPart1$1 = badPart1$1;
                            this.badPart2$1 = badPart2$1;
                        }
                    }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                    return;
                }
                finally {
                    catalog.setCurrentDatabase("default");
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$35 $outer;
                    private final ExternalCatalog catalog$19;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$19.alterPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$19 = catalog$19;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$35 $outer;
                    private final ExternalCatalog catalog$19;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$19.alterPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$19 = catalog$19;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("basic create and list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("mydb"), false);
                catalog.createFunction("mydb", this.$outer.utils().newFunc("myfunc", this.$outer.utils().newFunc$default$2()));
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("mydb", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$37 $outer;
                    private final ExternalCatalog catalog$20;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$20.createFunction("does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newFunc());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$20 = catalog$20;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create function that already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$38 $outer;
                    private final ExternalCatalog catalog$21;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$21.createFunction("db2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newFunc("func1", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newFunc$default$2()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$21 = catalog$21;
                    }
                }, ManifestFactory$.MODULE$.classType(FunctionAlreadyExistsException.class));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropFunction("db2", "func1");
                Seq $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "*");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$22;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$22.dropFunction("does_not_exist", "something");
                    }
                    {
                        this.catalog$22 = catalog$22;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function that does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$23;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$23.dropFunction("db2", "does_not_exist");
                    }
                    {
                        this.catalog$23 = catalog$23;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogFunction $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1");
                CatalogFunction $org_scalatest_assert_macro_right = new CatalogFunction(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), this.$outer.utils().funcClass(), (Seq)Seq$.MODULE$.empty());
                CatalogFunction catalogFunction = $org_scalatest_assert_macro_left;
                CatalogFunction catalogFunction2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogFunction != null ? !catalogFunction.equals(catalogFunction2) : catalogFunction2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$24;

                    public final CatalogFunction apply() {
                        return this.catalog$24.getFunction("db2", "does_not_exist");
                    }
                    {
                        this.catalog$24 = catalog$24;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$25;

                    public final CatalogFunction apply() {
                        return this.catalog$25.getFunction("does_not_exist", "func1");
                    }
                    {
                        this.catalog$25 = catalog$25;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                String newName = "funcky";
                String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right = this.$outer.utils().funcClass();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.renameFunction("db2", "func1", newName);
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$26;

                    public final CatalogFunction apply() {
                        return this.catalog$26.getFunction("db2", "func1");
                    }
                    {
                        this.catalog$26 = catalog$26;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
                String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", newName).identifier().funcName();
                String $org_scalatest_assert_macro_right2 = newName;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = catalog.getFunction("db2", newName).className();
                String $org_scalatest_assert_macro_right3 = this.$outer.utils().funcClass();
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$26;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$26.renameFunction("db2", "does_not_exist", "me");
                    }
                    {
                        this.catalog$26 = catalog$26;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$27;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$27.renameFunction("does_not_exist", "func1", "func5");
                    }
                    {
                        this.catalog$27 = catalog$27;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename function when new function already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.createFunction("db2", this.$outer.utils().newFunc("func2", (Option<String>)new Some((Object)"db2")));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$28;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$28.renameFunction("db2", "func1", "func2");
                    }
                    {
                        this.catalog$28 = catalog$28;
                    }
                }, ManifestFactory$.MODULE$.classType(FunctionAlreadyExistsException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.createFunction("db2", this.$outer.utils().newFunc("func2", this.$outer.utils().newFunc$default$2()));
                catalog.createFunction("db2", this.$outer.utils().newFunc("not_me", this.$outer.utils().newFunc$default$2()));
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2", "not_me"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "func*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create/drop database should create/delete the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db = this.$outer.utils().newDb("mydb");
                catalog.createDatabase(db, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(db.locationUri)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropDatabase("mydb", false, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(db.locationUri)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create/drop/rename table should create/delete/rename the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db = catalog.getDatabase("db1");
                CatalogTable table = new CatalogTable(new TableIdentifier("my_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogColumn[]{new CatalogColumn("a", "int", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4()), new CatalogColumn("b", "string", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4())})), CatalogTable$.MODULE$.apply$default$5(), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16());
                catalog.createTable("db1", table, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.renameTable("db1", "my_table", "your_table");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                catalog.dropTable("db1", "your_table", false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                CatalogTable externalTable = new CatalogTable(new TableIdentifier("external_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.EXTERNAL(), new CatalogStorageFormat((Option)new Some((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogColumn[]{new CatalogColumn("a", "int", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4()), new CatalogColumn("b", "string", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4())})), CatalogTable$.MODULE$.apply$default$5(), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16());
                catalog.createTable("db1", externalTable, false);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"external_table\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create/drop/rename partitions should create/delete/rename the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                String databaseDir = catalog.getDatabase("db1").locationUri();
                CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogColumn[]{new CatalogColumn("col1", "int", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4()), new CatalogColumn("col2", "string", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4()), new CatalogColumn("a", "int", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4()), new CatalogColumn("b", "string", CatalogColumn$.MODULE$.apply$default$3(), CatalogColumn$.MODULE$.apply$default$4())})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16());
                catalog.createTable("db1", table, false);
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=1", "b=2"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=1\", \"b=2\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=3", "b=4"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=3\", \"b=4\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                catalog.renamePartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part3().spec()})));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=1", "b=2"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=1\", \"b=2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=5", "b=6"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=5\", \"b=6\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                catalog.dropPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part2().spec(), this.$outer.utils().part3().spec()})), false);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=3", "b=4"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=3\", \"b=4\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=5", "b=6"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=5\", \"b=6\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                CatalogTablePartition externalPartition = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"7"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"8")})), new CatalogStorageFormat((Option)new Some((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{externalPartition})), false);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(databaseDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "a=7", "b=8"})), "ExternalCatalogSuite.this.exists(databaseDir, \"tbl\", \"a=7\", \"b=8\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

