/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTempFunctionException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TempFunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalogSuite$;
import org.apache.spark.sql.catalyst.catalog.SimpleCatalogRelation;
import org.apache.spark.sql.catalyst.catalog.SimpleCatalogRelation$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00052A!\u0001\u0002\u0001\u001f\t\u00192+Z:tS>t7)\u0019;bY><7+^5uK*\u00111\u0001B\u0001\bG\u0006$\u0018\r\\8h\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t\u0001\"\u0003\u0002\u0014\u0011\ti1\u000b]1sW\u001a+hnU;ji\u0016DQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00057\u0005)Q\u000f^5mgV\tA\u0004\u0005\u0002\u0019;%\u0011aD\u0001\u0002\u0011\u0007\u0006$\u0018\r\\8h)\u0016\u001cH/\u0016;jYNDa\u0001\t\u0001!\u0002\u0013a\u0012AB;uS2\u001c\b\u0005")
public class SessionCatalogSuite
extends SparkFunSuite {
    private final CatalogTestUtils org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils = new $anon$1(this);

    public CatalogTestUtils org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils() {
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils;
    }

    public SessionCatalogSuite() {
        this.test("basic create and list databases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newEmptyCatalog());
                catalog.createDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("default"), true);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("default"), "catalog.databaseExists(\"default\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                catalog.createDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("testing"), false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                catalog.createDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("testing2"), false);
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing", "testing2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("does_not_exist"), "catalog.databaseExists(\"does_not_exist\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get database when a database exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                CatalogDatabase db1 = catalog.getDatabaseMetadata("db1");
                String $org_scalatest_assert_macro_left = db1.name();
                String $org_scalatest_assert_macro_right = "db1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = db1.description();
                String $org_scalatest_assert_macro_right2 = "db1";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$1;

                    public final CatalogDatabase apply() {
                        return this.catalog$1.getDatabaseMetadata("db_that_does_not_exist");
                    }
                    {
                        this.catalog$1 = catalog$1;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list databases without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list databases with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Set $org_scalatest_assert_macro_left = catalog.listDatabases("db").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases("db*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1", "db2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = catalog.listDatabases("*1").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = catalog.listDatabases("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db2"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                catalog.dropDatabase("db1", false, false);
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database when the database is not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog1 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog1 = new SessionCatalog(externalCatalog1);
                externalCatalog1.dropTable("db2", "tbl1", false);
                externalCatalog1.dropTable("db2", "tbl2", false);
                this.$outer.intercept((Function0)new Serializable(this, sessionCatalog1){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog sessionCatalog1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.sessionCatalog1$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.sessionCatalog1$1 = sessionCatalog1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                ExternalCatalog externalCatalog2 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog2 = new SessionCatalog(externalCatalog2);
                externalCatalog2.dropFunction("db2", "func1");
                this.$outer.intercept((Function0)new Serializable(this, sessionCatalog2){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog sessionCatalog2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.sessionCatalog2$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.sessionCatalog2$1 = sessionCatalog2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                ExternalCatalog externalCatalog3 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog3 = new SessionCatalog(externalCatalog3);
                externalCatalog3.dropDatabase("db2", false, true);
                Set $org_scalatest_assert_macro_left = sessionCatalog3.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropDatabase("db_that_does_not_exist", false, false);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                catalog.dropDatabase("db_that_does_not_exist", true, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                CatalogDatabase db1 = catalog.getDatabaseMetadata("db1");
                Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"good"), (Object)"true")}));
                String x$5 = db1.copy$default$1();
                String x$6 = db1.copy$default$2();
                String x$7 = db1.copy$default$3();
                catalog.alterDatabase(db1.copy(x$5, x$6, x$7, x$4));
                CatalogDatabase newDb1 = catalog.getDatabaseMetadata("db1");
                Map $org_scalatest_assert_macro_left = db1.properties();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = newDb1.properties();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = newDb1.properties().get((Object)"k");
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"v3");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left4 = newDb1.properties().get((Object)"good");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"true");
                Option option2 = $org_scalatest_assert_macro_left4;
                Some some2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private final SessionCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.alterDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("unknown_db"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$3 = catalog$3;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get/set current database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                String $org_scalatest_assert_macro_left = catalog.getCurrentDatabase();
                String $org_scalatest_assert_macro_right = "default";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.setCurrentDatabase("db2");
                String $org_scalatest_assert_macro_left2 = catalog.getCurrentDatabase();
                String $org_scalatest_assert_macro_right2 = "db2";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$4.setCurrentDatabase("deebo");
                    }
                    {
                        this.catalog$4 = catalog$4;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                catalog.createDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("deebo"), false);
                catalog.setCurrentDatabase("deebo");
                String $org_scalatest_assert_macro_left3 = catalog.getCurrentDatabase();
                String $org_scalatest_assert_macro_right3 = "deebo";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Seq $org_scalatest_assert_macro_left = externalCatalog.listTables("db1");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left2;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl3", "db1"), false);
                sessionCatalog.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl3", "db2"), false);
                Set $org_scalatest_assert_macro_left3 = externalCatalog.listTables("db1").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl3"}));
                Set set3 = $org_scalatest_assert_macro_left3;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2", "tbl3"}));
                Set set5 = $org_scalatest_assert_macro_left4;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                sessionCatalog.setCurrentDatabase("db1");
                sessionCatalog.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl4", this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable$default$2()), false);
                Set $org_scalatest_assert_macro_left5 = externalCatalog.listTables("db1").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl3", "tbl4"}));
                Set set7 = $org_scalatest_assert_macro_left5;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Set $org_scalatest_assert_macro_left6 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2", "tbl3"}));
                Set set9 = $org_scalatest_assert_macro_left6;
                Set set10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(set9 != null ? !set9.equals(set10) : set10 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create table when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;
                    private final SessionCatalog catalog$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$5.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl1", "does_not_exist"), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;
                    private final SessionCatalog catalog$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$5.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl1", "does_not_exist"), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;
                    private final SessionCatalog catalog$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$5.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl1", "db2"), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(TableAlreadyExistsException.class));
                catalog.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl1", "db2"), true);
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create temp table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Range tempTable1 = Range$.MODULE$.apply(1L, 10L, 1L, 10);
                Range tempTable2 = Range$.MODULE$.apply(1L, 20L, 2L, 10);
                catalog.createTempView("tbl1", (LogicalPlan)tempTable1, false);
                catalog.createTempView("tbl2", (LogicalPlan)tempTable2, false);
                Option $org_scalatest_assert_macro_left = catalog.getTempView("tbl1");
                Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)tempTable1);
                Option option = $org_scalatest_assert_macro_left;
                Option option2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Option $org_scalatest_assert_macro_left2 = catalog.getTempView("tbl2");
                Option $org_scalatest_assert_macro_right2 = Option$.MODULE$.apply((Object)tempTable2);
                Option option3 = $org_scalatest_assert_macro_left2;
                Option option4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option3 != null ? !option3.equals(option4) : option4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = catalog.getTempView("tbl3");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog, tempTable1){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$6;
                    private final Range tempTable1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$6.createTempView("tbl1", (LogicalPlan)this.tempTable1$1, false);
                    }
                    {
                        this.catalog$6 = catalog$6;
                        this.tempTable1$1 = tempTable1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(TempTableAlreadyExistsException.class));
                catalog.createTempView("tbl1", (LogicalPlan)tempTable2, true);
                Option $org_scalatest_assert_macro_left4 = catalog.getTempView("tbl1");
                Option $org_scalatest_assert_macro_right3 = Option$.MODULE$.apply((Object)tempTable2);
                Option option5 = $org_scalatest_assert_macro_left4;
                Option option6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option5 != null ? !option5.equals(option6) : option6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Set $org_scalatest_assert_macro_left = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.dropTable(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), false);
                Set $org_scalatest_assert_macro_left2 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.setCurrentDatabase("db2");
                sessionCatalog.dropTable(TableIdentifier$.MODULE$.apply("tbl2"), false);
                Seq $org_scalatest_assert_macro_left3 = externalCatalog.listTables("db2");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$7;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$7.dropTable(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), false);
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$7;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$7.dropTable(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), true);
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$7;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$7.dropTable(new TableIdentifier("unknown_table", (Option)new Some((Object)"db2")), false);
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
                catalog.dropTable(new TableIdentifier("unknown_table", (Option)new Some((Object)"db2")), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop temp table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Range tempTable = Range$.MODULE$.apply(1L, 10L, 2L, 10);
                sessionCatalog.createTempView("tbl1", (LogicalPlan)tempTable, false);
                sessionCatalog.setCurrentDatabase("db2");
                Option $org_scalatest_assert_macro_left = sessionCatalog.getTempView("tbl1");
                Some $org_scalatest_assert_macro_right = new Some((Object)tempTable);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left2;
                Set set2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.dropTable(TableIdentifier$.MODULE$.apply("tbl1"), false);
                Option $org_scalatest_assert_macro_left3 = sessionCatalog.getTempView("tbl1");
                None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
                Option option2 = $org_scalatest_assert_macro_left3;
                None$ none$ = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(none$) : none$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left4;
                Set set4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                sessionCatalog.dropTable(TableIdentifier$.MODULE$.apply("tbl1"), false);
                Set $org_scalatest_assert_macro_left5 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
                Set set5 = $org_scalatest_assert_macro_left5;
                Set set6 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                sessionCatalog.createTempView("tbl1", (LogicalPlan)tempTable, false);
                sessionCatalog.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl1", "db2"), false);
                sessionCatalog.dropTable(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), false);
                Option $org_scalatest_assert_macro_left6 = sessionCatalog.getTempView("tbl1");
                Some $org_scalatest_assert_macro_right6 = new Some((Object)tempTable);
                Option option3 = $org_scalatest_assert_macro_left6;
                Some some2 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option3 != null ? !option3.equals(some2) : some2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Set $org_scalatest_assert_macro_left7 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right7 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
                Set set7 = $org_scalatest_assert_macro_left7;
                Set set8 = $org_scalatest_assert_macro_right7;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Set $org_scalatest_assert_macro_left = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.renameTable(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), new TableIdentifier("tblone", (Option)new Some((Object)"db2")));
                Set $org_scalatest_assert_macro_left2 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.renameTable(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), new TableIdentifier("tbltwo", (Option)new Some((Object)"db2")));
                Set $org_scalatest_assert_macro_left3 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbltwo"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                sessionCatalog.setCurrentDatabase("db2");
                sessionCatalog.renameTable(TableIdentifier$.MODULE$.apply("tbltwo"), TableIdentifier$.MODULE$.apply("table_two"));
                Set $org_scalatest_assert_macro_left4 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "table_two"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, sessionCatalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog sessionCatalog$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.sessionCatalog$1.renameTable(new TableIdentifier("tblone", (Option)new Some((Object)"db2")), new TableIdentifier("tblones", (Option)new Some((Object)"db1")));
                    }
                    {
                        this.sessionCatalog$1 = sessionCatalog$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, sessionCatalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog sessionCatalog$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.sessionCatalog$1.renameTable(new TableIdentifier("tblone", (Option)new Some((Object)"db2")), new TableIdentifier("table_two", (Option)new Some((Object)"db2")));
                    }
                    {
                        this.sessionCatalog$1 = sessionCatalog$1;
                    }
                }, ManifestFactory$.MODULE$.classType(TableAlreadyExistsException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$8;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$8.renameTable(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), new TableIdentifier("tbl2", (Option)new Some((Object)"unknown_db")));
                    }
                    {
                        this.catalog$8 = catalog$8;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$8;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$8.renameTable(new TableIdentifier("unknown_table", (Option)new Some((Object)"db2")), new TableIdentifier("tbl2", (Option)new Some((Object)"db2")));
                    }
                    {
                        this.catalog$8 = catalog$8;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename temp table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Range tempTable = Range$.MODULE$.apply(1L, 10L, 2L, 10);
                sessionCatalog.createTempView("tbl1", (LogicalPlan)tempTable, false);
                sessionCatalog.setCurrentDatabase("db2");
                Option $org_scalatest_assert_macro_left = sessionCatalog.getTempView("tbl1");
                Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)tempTable);
                Option option = $org_scalatest_assert_macro_left;
                Option option2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left2;
                Set set2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.renameTable(TableIdentifier$.MODULE$.apply("tbl1"), TableIdentifier$.MODULE$.apply("tbl3"));
                Option $org_scalatest_assert_macro_left3 = sessionCatalog.getTempView("tbl1");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left4 = sessionCatalog.getTempView("tbl3");
                Option $org_scalatest_assert_macro_right3 = Option$.MODULE$.apply((Object)tempTable);
                Option option3 = $org_scalatest_assert_macro_left4;
                Option option4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(option4) : option4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Set $org_scalatest_assert_macro_left5 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left5;
                Set set4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                sessionCatalog.renameTable(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), new TableIdentifier("tbl4", (Option)new Some((Object)"db2")));
                Option $org_scalatest_assert_macro_left6 = sessionCatalog.getTempView("tbl3");
                Option $org_scalatest_assert_macro_right5 = Option$.MODULE$.apply((Object)tempTable);
                Option option5 = $org_scalatest_assert_macro_left6;
                Option option6 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(option6) : option6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Option $org_scalatest_assert_macro_left7 = sessionCatalog.getTempView("tbl4");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Set $org_scalatest_assert_macro_left8 = externalCatalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl4"}));
                Set set5 = $org_scalatest_assert_macro_left8;
                Set set6 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CatalogTable newestTbl1;
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                CatalogTable tbl1 = externalCatalog.getTable("db2", "tbl1");
                Map x$8 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toh"), (Object)"frem")}));
                TableIdentifier x$9 = tbl1.copy$default$1();
                CatalogTableType x$10 = tbl1.copy$default$2();
                CatalogStorageFormat x$11 = tbl1.copy$default$3();
                Seq x$12 = tbl1.copy$default$4();
                Seq x$13 = tbl1.copy$default$5();
                Seq x$14 = tbl1.copy$default$6();
                Seq x$15 = tbl1.copy$default$7();
                int x$16 = tbl1.copy$default$8();
                String x$17 = tbl1.copy$default$9();
                long x$18 = tbl1.copy$default$10();
                long x$19 = tbl1.copy$default$11();
                Option x$20 = tbl1.copy$default$13();
                Option x$21 = tbl1.copy$default$14();
                Option x$22 = tbl1.copy$default$15();
                Seq x$23 = tbl1.copy$default$16();
                sessionCatalog.alterTable(tbl1.copy(x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$8, x$20, x$21, x$22, x$23));
                CatalogTable newTbl1 = externalCatalog.getTable("db2", "tbl1");
                Map $org_scalatest_assert_macro_left = tbl1.properties();
                String $org_scalatest_assert_macro_right = "toh";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = newTbl1.properties();
                int $org_scalatest_assert_macro_right2 = tbl1.properties().size() + 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = newTbl1.properties().get((Object)"toh");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"frem");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                sessionCatalog.setCurrentDatabase("db2");
                sessionCatalog.alterTable(tbl1.copy(TableIdentifier$.MODULE$.apply("tbl1"), tbl1.copy$default$2(), tbl1.copy$default$3(), tbl1.copy$default$4(), tbl1.copy$default$5(), tbl1.copy$default$6(), tbl1.copy$default$7(), tbl1.copy$default$8(), tbl1.copy$default$9(), tbl1.copy$default$10(), tbl1.copy$default$11(), tbl1.copy$default$12(), tbl1.copy$default$13(), tbl1.copy$default$14(), tbl1.copy$default$15(), tbl1.copy$default$16()));
                CatalogTable $org_scalatest_assert_macro_left4 = newestTbl1 = externalCatalog.getTable("db2", "tbl1");
                CatalogTable $org_scalatest_assert_macro_right4 = tbl1;
                CatalogTable catalogTable = $org_scalatest_assert_macro_left4;
                CatalogTable catalogTable2 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(catalogTable != null ? !catalogTable.equals(catalogTable2) : catalogTable2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$22 $outer;
                    private final SessionCatalog catalog$9;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$9.alterTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl1", "unknown_db"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$9 = catalog$9;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$22 $outer;
                    private final SessionCatalog catalog$9;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$9.alterTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("unknown_table", "db2"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$9 = catalog$9;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                CatalogTable $org_scalatest_assert_macro_left = sessionCatalog.getTableMetadata(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")));
                CatalogTable $org_scalatest_assert_macro_right = externalCatalog.getTable("db2", "tbl1");
                CatalogTable catalogTable = $org_scalatest_assert_macro_left;
                CatalogTable catalogTable2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTable != null ? !catalogTable.equals(catalogTable2) : catalogTable2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.setCurrentDatabase("db2");
                CatalogTable $org_scalatest_assert_macro_left2 = sessionCatalog.getTableMetadata(TableIdentifier$.MODULE$.apply("tbl1"));
                CatalogTable $org_scalatest_assert_macro_right2 = externalCatalog.getTable("db2", "tbl1");
                CatalogTable catalogTable3 = $org_scalatest_assert_macro_left2;
                CatalogTable catalogTable4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(catalogTable3 != null ? !catalogTable3.equals(catalogTable4) : catalogTable4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$10;

                    public final CatalogTable apply() {
                        return this.catalog$10.getTableMetadata(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")));
                    }
                    {
                        this.catalog$10 = catalog$10;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$10;

                    public final CatalogTable apply() {
                        return this.catalog$10.getTableMetadata(new TableIdentifier("unknown_table", (Option)new Some((Object)"db2")));
                    }
                    {
                        this.catalog$10 = catalog$10;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get option of table metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog catalog = new SessionCatalog(externalCatalog);
                Option $org_scalatest_assert_macro_left = catalog.getTableMetadataOption(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")));
                Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)externalCatalog.getTable("db2", "tbl1"));
                Option option = $org_scalatest_assert_macro_left;
                Option option2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Option $org_scalatest_assert_macro_left2 = catalog.getTableMetadataOption(new TableIdentifier("unknown_table", (Option)new Some((Object)"db2")));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$11;

                    public final Option<CatalogTable> apply() {
                        return this.catalog$11.getTableMetadataOption(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")));
                    }
                    {
                        this.catalog$11 = catalog$11;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lookup table relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Range tempTable1 = Range$.MODULE$.apply(1L, 10L, 1L, 10);
                CatalogTable metastoreTable1 = externalCatalog.getTable("db2", "tbl1");
                sessionCatalog.createTempView("tbl1", (LogicalPlan)tempTable1, false);
                sessionCatalog.setCurrentDatabase("db2");
                LogicalPlan $org_scalatest_assert_macro_left = sessionCatalog.lookupRelation(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), sessionCatalog.lookupRelation$default$2());
                SubqueryAlias $org_scalatest_assert_macro_right = new SubqueryAlias("tbl1", (LogicalPlan)new SimpleCatalogRelation("db2", metastoreTable1, SimpleCatalogRelation$.MODULE$.apply$default$3()));
                LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
                SubqueryAlias subqueryAlias = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(subqueryAlias) : subqueryAlias != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                LogicalPlan $org_scalatest_assert_macro_left2 = sessionCatalog.lookupRelation(TableIdentifier$.MODULE$.apply("tbl1"), sessionCatalog.lookupRelation$default$2());
                SubqueryAlias $org_scalatest_assert_macro_right2 = new SubqueryAlias("tbl1", (LogicalPlan)tempTable1);
                LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_left2;
                SubqueryAlias subqueryAlias2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan2 != null ? !logicalPlan2.equals(subqueryAlias2) : subqueryAlias2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.dropTable(TableIdentifier$.MODULE$.apply("tbl1"), false);
                LogicalPlan $org_scalatest_assert_macro_left3 = sessionCatalog.lookupRelation(TableIdentifier$.MODULE$.apply("tbl1"), sessionCatalog.lookupRelation$default$2());
                SubqueryAlias $org_scalatest_assert_macro_right3 = new SubqueryAlias("tbl1", (LogicalPlan)new SimpleCatalogRelation("db2", metastoreTable1, SimpleCatalogRelation$.MODULE$.apply$default$3()));
                LogicalPlan logicalPlan3 = $org_scalatest_assert_macro_left3;
                SubqueryAlias subqueryAlias3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(logicalPlan3 != null ? !logicalPlan3.equals(subqueryAlias3) : subqueryAlias3 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lookup table relation with alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                String alias = "monster";
                CatalogTable tableMetadata = catalog.getTableMetadata(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")));
                SubqueryAlias relation = new SubqueryAlias("tbl1", (LogicalPlan)new SimpleCatalogRelation("db2", tableMetadata, SimpleCatalogRelation$.MODULE$.apply$default$3()));
                SubqueryAlias relationWithAlias = new SubqueryAlias(alias, (LogicalPlan)new SubqueryAlias("tbl1", (LogicalPlan)new SimpleCatalogRelation("db2", tableMetadata, (Option)new Some((Object)alias))));
                LogicalPlan $org_scalatest_assert_macro_left = catalog.lookupRelation(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Option)None$.MODULE$);
                SubqueryAlias $org_scalatest_assert_macro_right = relation;
                LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
                SubqueryAlias subqueryAlias = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(subqueryAlias) : subqueryAlias != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                LogicalPlan $org_scalatest_assert_macro_left2 = catalog.lookupRelation(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Option)new Some((Object)alias));
                SubqueryAlias $org_scalatest_assert_macro_right2 = relationWithAlias;
                LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_left2;
                SubqueryAlias subqueryAlias2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(logicalPlan2 != null ? !logicalPlan2.equals(subqueryAlias2) : subqueryAlias2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(new TableIdentifier("tbl1", (Option)new Some((Object)"db2"))), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl1\", scala.Some.apply[String](\"db2\")))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(new TableIdentifier("tbl2", (Option)new Some((Object)"db2"))), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl2\", scala.Some.apply[String](\"db2\")))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(new TableIdentifier("tbl3", (Option)new Some((Object)"db2"))), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl3\", scala.Some.apply[String](\"db2\")))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(new TableIdentifier("tbl1", (Option)new Some((Object)"db1"))), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl1\", scala.Some.apply[String](\"db1\")))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(new TableIdentifier("tbl2", (Option)new Some((Object)"db1"))), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl2\", scala.Some.apply[String](\"db1\")))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Range tempTable = Range$.MODULE$.apply(1L, 10L, 1L, 10);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(new TableIdentifier("tbl3", (Option)new Some((Object)"db2"))), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl3\", scala.Some.apply[String](\"db2\")))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                catalog.setCurrentDatabase("db2");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply("tbl1")), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl1\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply("tbl2")), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl2\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                catalog.createTempView("tbl3", (LogicalPlan)tempTable, false);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply("tbl3")), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tbl3\"))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("getTempViewOrPermanentTableMetadata on temporary views", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Range tempTable = Range$.MODULE$.apply(1L, 10L, 2L, 10);
                ((AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$12;

                    public final CatalogTable apply() {
                        return this.catalog$12.getTempViewOrPermanentTableMetadata(TableIdentifier$.MODULE$.apply("view1"));
                    }
                    {
                        this.catalog$12 = catalog$12;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class))).getMessage();
                ((AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$12;

                    public final CatalogTable apply() {
                        return this.catalog$12.getTempViewOrPermanentTableMetadata(new TableIdentifier("view1", (Option)new Some((Object)"default")));
                    }
                    {
                        this.catalog$12 = catalog$12;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class))).getMessage();
                catalog.createTempView("view1", (LogicalPlan)tempTable, false);
                String $org_scalatest_assert_macro_left = catalog.getTempViewOrPermanentTableMetadata(TableIdentifier$.MODULE$.apply("view1")).identifier().table();
                String $org_scalatest_assert_macro_right = "view1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = ((CatalogColumn)catalog.getTempViewOrPermanentTableMetadata(TableIdentifier$.MODULE$.apply("view1")).schema().apply(0)).name();
                String $org_scalatest_assert_macro_right2 = "id";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ((AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$12;

                    public final CatalogTable apply() {
                        return this.catalog$12.getTempViewOrPermanentTableMetadata(new TableIdentifier("view1", (Option)new Some((Object)"default")));
                    }
                    {
                        this.catalog$12 = catalog$12;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class))).getMessage();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list tables without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Range tempTable = Range$.MODULE$.apply(1L, 10L, 2L, 10);
                catalog.createTempView("tbl1", (LogicalPlan)tempTable, false);
                catalog.createTempView("tbl4", (LogicalPlan)tempTable, false);
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{TableIdentifier$.MODULE$.apply("tbl1"), TableIdentifier$.MODULE$.apply("tbl4")}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{TableIdentifier$.MODULE$.apply("tbl1"), TableIdentifier$.MODULE$.apply("tbl4"), new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), new TableIdentifier("tbl2", (Option)new Some((Object)"db2"))}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$13;

                    public final Seq<TableIdentifier> apply() {
                        return this.catalog$13.listTables("unknown_db");
                    }
                    {
                        this.catalog$13 = catalog$13;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list tables with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Range tempTable = Range$.MODULE$.apply(1L, 10L, 2L, 10);
                catalog.createTempView("tbl1", (LogicalPlan)tempTable, false);
                catalog.createTempView("tbl4", (LogicalPlan)tempTable, false);
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1", "*").toSet();
                Set $org_scalatest_assert_macro_right = catalog.listTables("db1").toSet();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right2 = catalog.listTables("db2").toSet();
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = catalog.listTables("db2", "tbl*").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{TableIdentifier$.MODULE$.apply("tbl1"), TableIdentifier$.MODULE$.apply("tbl4"), new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), new TableIdentifier("tbl2", (Option)new Some((Object)"db2"))}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = catalog.listTables("db2", "*1").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{TableIdentifier$.MODULE$.apply("tbl1"), new TableIdentifier("tbl1", (Option)new Some((Object)"db2"))}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$14;

                    public final Seq<TableIdentifier> apply() {
                        return this.catalog$14.listTables("unknown_db", "*");
                    }
                    {
                        this.catalog$14 = catalog$14;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("basic create and list partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newEmptyCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                sessionCatalog.createDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("mydb"), false);
                sessionCatalog.createTable(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newTable("tbl", "mydb"), false);
                sessionCatalog.createPartitions(new TableIdentifier("tbl", (Option)new Some((Object)"mydb")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().catalogPartitionsEqual(externalCatalog, "mydb", "tbl", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()})))), "SessionCatalogSuite.this.utils.catalogPartitionsEqual(externalCatalog, \"mydb\", \"tbl\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](SessionCatalogSuite.this.utils.part1, SessionCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.setCurrentDatabase("mydb");
                sessionCatalog.createPartitions(TableIdentifier$.MODULE$.apply("tbl"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMixedOrder()})), false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().catalogPartitionsEqual(externalCatalog, "mydb", "tbl", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMixedOrder()})))), "SessionCatalogSuite.this.utils.catalogPartitionsEqual(externalCatalog, \"mydb\", \"tbl\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](SessionCatalogSuite.this.utils.part1, SessionCatalogSuite.this.utils.part2, SessionCatalogSuite.this.utils.partWithMixedOrder))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$15;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$15.createPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$15 = catalog$15;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$15;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$15.createPartitions(new TableIdentifier("does_not_exist", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$15 = catalog$15;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions that already exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$34 $outer;
                    private final SessionCatalog catalog$16;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$16.createPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$16 = catalog$16;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.createPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1()})), true);
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions with invalid part spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                AnalysisException e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$35 $outer;
                    private final SessionCatalog catalog$17;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$17.createPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithLessColumns()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Partition spec is invalid. The spec (a) must match the partition spec (a, b) defined in table '`db2`.`tbl2`'";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$35 $outer;
                    private final SessionCatalog catalog$17;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$17.createPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMoreColumns()})), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "Partition spec is invalid. The spec (a, b, c) must match the partition spec (a, b) defined in table '`db2`.`tbl2`'";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$35 $outer;
                    private final SessionCatalog catalog$17;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$17.createPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithUnknownColumns(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1()})), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left3 = e.getMessage();
                String $org_scalatest_assert_macro_right3 = "Partition spec is invalid. The spec (a, unknown) must match the partition spec (a, b) defined in table '`db2`.`tbl2`'";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().catalogPartitionsEqual(externalCatalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()})))), "SessionCatalogSuite.this.utils.catalogPartitionsEqual(externalCatalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](SessionCatalogSuite.this.utils.part1, SessionCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.dropPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()})), false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().catalogPartitionsEqual(externalCatalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()})))), "SessionCatalogSuite.this.utils.catalogPartitionsEqual(externalCatalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](SessionCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.setCurrentDatabase("db2");
                sessionCatalog.dropPartitions(TableIdentifier$.MODULE$.apply("tbl2"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()})), false);
                Seq $org_scalatest_assert_macro_left = externalCatalog.listPartitions("db2", "tbl2", externalCatalog.listPartitions$default$3());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                sessionCatalog.createPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()})), false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().catalogPartitionsEqual(externalCatalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()})))), "SessionCatalogSuite.this.utils.catalogPartitionsEqual(externalCatalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](SessionCatalogSuite.this.utils.part1, SessionCatalogSuite.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                sessionCatalog.dropPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()})), false);
                Seq $org_scalatest_assert_macro_left2 = externalCatalog.listPartitions("db2", "tbl2", externalCatalog.listPartitions$default$3());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$18;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$18.dropPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$18 = catalog$18;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$18;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$18.dropPartitions(new TableIdentifier("does_not_exist", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$18 = catalog$18;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions that do not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$39 $outer;
                    private final SessionCatalog catalog$19;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$19.dropPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part3().spec()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$19 = catalog$19;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part3().spec()})), true);
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions with invalid partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                AnalysisException e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$40 $outer;
                    private final SessionCatalog catalog$20;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$20.dropPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMoreColumns().spec()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$20 = catalog$20;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Partition spec is invalid. The spec (a, b, c) must be contained within the partition spec (a, b) defined in table '`db2`.`tbl2`'";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$40 $outer;
                    private final SessionCatalog catalog$20;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$20.dropPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithUnknownColumns().spec()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$20 = catalog$20;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "Partition spec is invalid. The spec (a, unknown) must be contained within the partition spec (a, b) defined in table '`db2`.`tbl2`'";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Map $org_scalatest_assert_macro_left = catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()).spec();
                Map $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec();
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()).spec();
                Map $org_scalatest_assert_macro_right2 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec();
                Map map3 = $org_scalatest_assert_macro_left2;
                Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                catalog.setCurrentDatabase("db2");
                Map $org_scalatest_assert_macro_left3 = catalog.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()).spec();
                Map $org_scalatest_assert_macro_right3 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec();
                Map map5 = $org_scalatest_assert_macro_left3;
                Map map6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Map $org_scalatest_assert_macro_left4 = catalog.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()).spec();
                Map $org_scalatest_assert_macro_right4 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec();
                Map map7 = $org_scalatest_assert_macro_left4;
                Map map8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$42 $outer;
                    private final SessionCatalog catalog$21;

                    public final CatalogTablePartition apply() {
                        return this.catalog$21.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part3().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$21 = catalog$21;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;
                    private final SessionCatalog catalog$22;

                    public final CatalogTablePartition apply() {
                        return this.catalog$22.getPartition(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$22 = catalog$22;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;
                    private final SessionCatalog catalog$22;

                    public final CatalogTablePartition apply() {
                        return this.catalog$22.getPartition(new TableIdentifier("does_not_exist", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$22 = catalog$22;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition with invalid partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                AnalysisException e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final SessionCatalog catalog$23;

                    public final CatalogTablePartition apply() {
                        return this.catalog$23.getPartition(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithLessColumns().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$23 = catalog$23;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Partition spec is invalid. The spec (a) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final SessionCatalog catalog$23;

                    public final CatalogTablePartition apply() {
                        return this.catalog$23.getPartition(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMoreColumns().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$23 = catalog$23;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "Partition spec is invalid. The spec (a, b, c) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final SessionCatalog catalog$23;

                    public final CatalogTablePartition apply() {
                        return this.catalog$23.getPartition(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithUnknownColumns().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$23 = catalog$23;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left3 = e.getMessage();
                String $org_scalatest_assert_macro_right3 = "Partition spec is invalid. The spec (a, unknown) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                CatalogTablePartition newPart1 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"101")})), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().copy$default$2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().copy$default$3());
                CatalogTablePartition newPart2 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"201")})), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().copy$default$2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().copy$default$3());
                Seq newSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{newPart1.spec(), newPart2.spec()}));
                catalog.renamePartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()})), newSpecs);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), newPart1.spec()).spec());
                Map $org_scalatest_assert_macro_right = newPart1.spec();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), newPart2.spec()).spec());
                Map $org_scalatest_assert_macro_right2 = newPart2.spec();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$45 $outer;
                    private final SessionCatalog catalog$24;

                    public final CatalogTablePartition apply() {
                        return this.catalog$24.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$24 = catalog$24;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$45 $outer;
                    private final SessionCatalog catalog$24;

                    public final CatalogTablePartition apply() {
                        return this.catalog$24.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$24 = catalog$24;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.setCurrentDatabase("db2");
                catalog.renamePartitions(TableIdentifier$.MODULE$.apply("tbl2"), newSpecs, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(catalog.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()).spec());
                Map $org_scalatest_assert_macro_right3 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(catalog.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()).spec());
                Map $org_scalatest_assert_macro_right4 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog, newPart1){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$24;
                    private final CatalogTablePartition newPart1$1;

                    public final CatalogTablePartition apply() {
                        return this.catalog$24.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.newPart1$1.spec());
                    }
                    {
                        this.catalog$24 = catalog$24;
                        this.newPart1$1 = newPart1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog, newPart2){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$24;
                    private final CatalogTablePartition newPart2$1;

                    public final CatalogTablePartition apply() {
                        return this.catalog$24.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.newPart2$1.spec());
                    }
                    {
                        this.catalog$24 = catalog$24;
                        this.newPart2$1 = newPart2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$46 $outer;
                    private final SessionCatalog catalog$25;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$25.renamePartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$25 = catalog$25;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$46 $outer;
                    private final SessionCatalog catalog$25;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$25.renamePartitions(new TableIdentifier("does_not_exist", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$25 = catalog$25;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partition with invalid partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                AnalysisException e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$47 $outer;
                    private final SessionCatalog catalog$26;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$26.renamePartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithLessColumns().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$26 = catalog$26;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Partition spec is invalid. The spec (a) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$47 $outer;
                    private final SessionCatalog catalog$26;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$26.renamePartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMoreColumns().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$26 = catalog$26;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "Partition spec is invalid. The spec (a, b, c) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$47 $outer;
                    private final SessionCatalog catalog$26;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$26.renamePartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithUnknownColumns().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$26 = catalog$26;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left3 = e.getMessage();
                String $org_scalatest_assert_macro_right3 = "Partition spec is invalid. The spec (a, unknown) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                String newLocation = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newUriForDatabase();
                CatalogTablePartition oldPart1 = catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec());
                CatalogTablePartition oldPart2 = catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec());
                CatalogTablePartition[] catalogTablePartitionArray = new CatalogTablePartition[2];
                CatalogStorageFormat x$24 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$3(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$4(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$5(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$6());
                Map x$25 = oldPart1.copy$default$1();
                Map x$26 = oldPart1.copy$default$3();
                catalogTablePartitionArray[0] = oldPart1.copy(x$25, x$24, x$26);
                CatalogStorageFormat x$27 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$3(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$4(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$5(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().storageFormat().copy$default$6());
                Map x$28 = oldPart2.copy$default$1();
                Map x$29 = oldPart2.copy$default$3();
                catalogTablePartitionArray[1] = oldPart2.copy(x$28, x$27, x$29);
                catalog.alterPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])catalogTablePartitionArray)));
                CatalogTablePartition newPart1 = catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec());
                CatalogTablePartition newPart2 = catalog.getPartition(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec());
                Option $org_scalatest_assert_macro_left = newPart1.storage().locationUri();
                Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Option $org_scalatest_assert_macro_left2 = newPart2.storage().locationUri();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)newLocation);
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = oldPart1.storage().locationUri();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)newLocation);
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, option3 != null ? !option3.equals(some3) : some3 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left4 = oldPart2.storage().locationUri();
                Some $org_scalatest_assert_macro_right4 = new Some((Object)newLocation);
                Option option4 = $org_scalatest_assert_macro_left4;
                Some some4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, option4 != null ? !option4.equals(some4) : some4 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                catalog.setCurrentDatabase("db2");
                catalog.alterPartitions(TableIdentifier$.MODULE$.apply("tbl2"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{oldPart1, oldPart2})));
                CatalogTablePartition newerPart1 = catalog.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().spec());
                CatalogTablePartition newerPart2 = catalog.getPartition(TableIdentifier$.MODULE$.apply("tbl2"), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().spec());
                Option $org_scalatest_assert_macro_left5 = oldPart1.storage().locationUri();
                Option $org_scalatest_assert_macro_right5 = newerPart1.storage().locationUri();
                Option option5 = $org_scalatest_assert_macro_left5;
                Option option6 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(option6) : option6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Option $org_scalatest_assert_macro_left6 = oldPart2.storage().locationUri();
                Option $org_scalatest_assert_macro_right6 = newerPart2.storage().locationUri();
                Option option7 = $org_scalatest_assert_macro_left6;
                Option option8 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option7 != null ? !option7.equals(option8) : option8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                CatalogTablePartition badPart1 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"v2")})), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().copy$default$2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1().copy$default$3());
                CatalogTablePartition badPart2 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)"v4")})), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().copy$default$2(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2().copy$default$3());
                this.$outer.intercept((Function0)new Serializable(this, catalog, badPart1, badPart2){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$27;
                    private final CatalogTablePartition badPart1$1;
                    private final CatalogTablePartition badPart2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$27.alterPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.badPart1$1, this.badPart2$1})));
                    }
                    {
                        this.catalog$27 = catalog$27;
                        this.badPart1$1 = badPart1$1;
                        this.badPart2$1 = badPart2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$50 $outer;
                    private final SessionCatalog catalog$28;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$28.alterPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$28 = catalog$28;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$50 $outer;
                    private final SessionCatalog catalog$28;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$28.alterPartitions(new TableIdentifier("does_not_exist", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$28 = catalog$28;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partition with invalid partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                AnalysisException e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$51 $outer;
                    private final SessionCatalog catalog$29;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$29.alterPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithLessColumns()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$29 = catalog$29;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Partition spec is invalid. The spec (a) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$51 $outer;
                    private final SessionCatalog catalog$29;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$29.alterPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithMoreColumns()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$29 = catalog$29;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "Partition spec is invalid. The spec (a, b, c) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                e = (AnalysisException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$51 $outer;
                    private final SessionCatalog catalog$29;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$29.alterPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"db2")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().partWithUnknownColumns()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$29 = catalog$29;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left3 = e.getMessage();
                String $org_scalatest_assert_macro_right3 = "Partition spec is invalid. The spec (a, unknown) must match the partition spec (a, b) defined in table '`db2`.`tbl1`'";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Set $org_scalatest_assert_macro_left = catalog.listPartitions(new TableIdentifier("tbl2", (Option)new Some((Object)"db2")), catalog.listPartitions$default$2()).toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.setCurrentDatabase("db2");
                Set $org_scalatest_assert_macro_left2 = catalog.listPartitions(TableIdentifier$.MODULE$.apply("tbl2"), catalog.listPartitions$default$2()).toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part1(), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().part2()}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$30;

                    public final Seq<CatalogTablePartition> apply() {
                        return this.catalog$30.listPartitions(new TableIdentifier("tbl1", (Option)new Some((Object)"unknown_db")), this.catalog$30.listPartitions$default$2());
                    }
                    {
                        this.catalog$30 = catalog$30;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$30;

                    public final Seq<CatalogTablePartition> apply() {
                        return this.catalog$30.listPartitions(new TableIdentifier("does_not_exist", (Option)new Some((Object)"db2")), this.catalog$30.listPartitions$default$2());
                    }
                    {
                        this.catalog$30 = catalog$30;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("basic create and list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newEmptyCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                sessionCatalog.createDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newDb("mydb"), false);
                sessionCatalog.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("myfunc", (Option<String>)new Some((Object)"mydb")), false);
                Set $org_scalatest_assert_macro_left = externalCatalog.listFunctions("mydb", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.setCurrentDatabase("mydb");
                sessionCatalog.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("myfunc2", this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc$default$2()), false);
                Set $org_scalatest_assert_macro_left2 = externalCatalog.listFunctions("mydb", "*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc", "myfunc2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$56 $outer;
                    private final SessionCatalog catalog$31;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$31.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("func5", (Option<String>)new Some((Object)"does_not_exist")), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$31 = catalog$31;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create function that already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$57 $outer;
                    private final SessionCatalog catalog$32;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$32.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer().org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("func1", (Option<String>)new Some((Object)"db2")), false);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.catalog$32 = catalog$32;
                    }
                }, ManifestFactory$.MODULE$.classType(FunctionAlreadyExistsException.class));
                catalog.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("func1", (Option<String>)new Some((Object)"db2")), true);
            }

            public /* synthetic */ SessionCatalogSuite org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create temp function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                Serializable tempFunc1 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Seq<Expression> e) {
                        return (Expression)e.head();
                    }
                };
                Serializable tempFunc2 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Seq<Expression> e) {
                        return (Expression)e.last();
                    }
                };
                ExpressionInfo info1 = new ExpressionInfo("tempFunc1", "temp1");
                ExpressionInfo info2 = new ExpressionInfo("tempFunc2", "temp2");
                catalog.createTempFunction("temp1", info1, (Function1)tempFunc1, false);
                catalog.createTempFunction("temp2", info2, (Function1)tempFunc2, false);
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(catalog.lookupFunction(FunctionIdentifier$.MODULE$.apply("temp1"), arguments));
                Literal $org_scalatest_assert_macro_right = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(catalog.lookupFunction(FunctionIdentifier$.MODULE$.apply("temp2"), arguments));
                Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog, arguments){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$33;
                    private final Seq arguments$1;

                    public final Expression apply() {
                        return this.catalog$33.lookupFunction(FunctionIdentifier$.MODULE$.apply("temp3"), this.arguments$1);
                    }
                    {
                        this.catalog$33 = catalog$33;
                        this.arguments$1 = arguments$1;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
                Serializable tempFunc3 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(Seq<Expression> e) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)e.size()));
                    }
                };
                ExpressionInfo info3 = new ExpressionInfo("tempFunc3", "temp1");
                this.$outer.intercept((Function0)new Serializable(this, catalog, (Function1)tempFunc3, info3){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$33;
                    private final Function1 tempFunc3$1;
                    private final ExpressionInfo info3$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$33.createTempFunction("temp1", this.info3$1, this.tempFunc3$1, false);
                    }
                    {
                        this.catalog$33 = catalog$33;
                        this.tempFunc3$1 = tempFunc3$1;
                        this.info3$1 = info3$1;
                    }
                }, ManifestFactory$.MODULE$.classType(TempFunctionAlreadyExistsException.class));
                catalog.createTempFunction("temp1", info3, (Function1)tempFunc3, true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(catalog.lookupFunction(FunctionIdentifier$.MODULE$.apply("temp1"), arguments));
                Literal $org_scalatest_assert_macro_right3 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)arguments.length()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog externalCatalog = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog();
                SessionCatalog sessionCatalog = new SessionCatalog(externalCatalog);
                Set $org_scalatest_assert_macro_left = externalCatalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                sessionCatalog.dropFunction(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), false);
                Seq $org_scalatest_assert_macro_left2 = externalCatalog.listFunctions("db2", "*");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                sessionCatalog.setCurrentDatabase("db2");
                sessionCatalog.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("func2", (Option<String>)new Some((Object)"db2")), false);
                Set $org_scalatest_assert_macro_left3 = externalCatalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func2"}));
                Set set3 = $org_scalatest_assert_macro_left3;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                sessionCatalog.dropFunction(FunctionIdentifier$.MODULE$.apply("func2"), false);
                Seq $org_scalatest_assert_macro_left4 = externalCatalog.listFunctions("db2", "*");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function when database/function does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$34;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$34.dropFunction(new FunctionIdentifier("something", (Option)new Some((Object)"unknown_db")), false);
                    }
                    {
                        this.catalog$34 = catalog$34;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$34;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$34.dropFunction(FunctionIdentifier$.MODULE$.apply("does_not_exist"), false);
                    }
                    {
                        this.catalog$34 = catalog$34;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
                catalog.dropFunction(FunctionIdentifier$.MODULE$.apply("does_not_exist"), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("drop temp function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                ExpressionInfo info = new ExpressionInfo("tempFunc", "func1");
                Serializable tempFunc = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Seq<Expression> e) {
                        return (Expression)e.head();
                    }
                };
                catalog.createTempFunction("func1", info, (Function1)tempFunc, false);
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(catalog.lookupFunction(FunctionIdentifier$.MODULE$.apply("func1"), arguments));
                Literal $org_scalatest_assert_macro_right = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropTempFunction("func1", false);
                this.$outer.intercept((Function0)new Serializable(this, catalog, arguments){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$35;
                    private final Seq arguments$2;

                    public final Expression apply() {
                        return this.catalog$35.lookupFunction(FunctionIdentifier$.MODULE$.apply("func1"), this.arguments$2);
                    }
                    {
                        this.catalog$35 = catalog$35;
                        this.arguments$2 = arguments$2;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$35;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$35.dropTempFunction("func1", false);
                    }
                    {
                        this.catalog$35 = catalog$35;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTempFunctionException.class));
                catalog.dropTempFunction("func1", true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                CatalogFunction expected = new CatalogFunction(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().funcClass(), (Seq)Seq$.MODULE$.empty());
                CatalogFunction $org_scalatest_assert_macro_left = catalog.getFunctionMetadata(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")));
                CatalogFunction $org_scalatest_assert_macro_right = expected;
                CatalogFunction catalogFunction = $org_scalatest_assert_macro_left;
                CatalogFunction catalogFunction2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogFunction != null ? !catalogFunction.equals(catalogFunction2) : catalogFunction2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.setCurrentDatabase("db2");
                CatalogFunction $org_scalatest_assert_macro_left2 = catalog.getFunctionMetadata(FunctionIdentifier$.MODULE$.apply("func1"));
                CatalogFunction $org_scalatest_assert_macro_right2 = expected;
                CatalogFunction catalogFunction3 = $org_scalatest_assert_macro_left2;
                CatalogFunction catalogFunction4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(catalogFunction3 != null ? !catalogFunction3.equals(catalogFunction4) : catalogFunction4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get function when database/function does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$36;

                    public final CatalogFunction apply() {
                        return this.catalog$36.getFunctionMetadata(new FunctionIdentifier("func1", (Option)new Some((Object)"unknown_db")));
                    }
                    {
                        this.catalog$36 = catalog$36;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$36;

                    public final CatalogFunction apply() {
                        return this.catalog$36.getFunctionMetadata(new FunctionIdentifier("does_not_exist", (Option)new Some((Object)"db2")));
                    }
                    {
                        this.catalog$36 = catalog$36;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lookup temp function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                ExpressionInfo info1 = new ExpressionInfo("tempFunc1", "func1");
                Serializable tempFunc1 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Seq<Expression> e) {
                        return (Expression)e.head();
                    }
                };
                catalog.createTempFunction("func1", info1, (Function1)tempFunc1, false);
                Expression $org_scalatest_assert_macro_left = catalog.lookupFunction(FunctionIdentifier$.MODULE$.apply("func1"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))})));
                Literal $org_scalatest_assert_macro_right = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
                Expression expression = $org_scalatest_assert_macro_left;
                Literal literal = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(expression != null ? !expression.equals(literal) : literal != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropTempFunction("func1", false);
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$37;

                    public final Expression apply() {
                        return this.catalog$37.lookupFunction(FunctionIdentifier$.MODULE$.apply("func1"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))})));
                    }
                    {
                        this.catalog$37 = catalog$37;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchFunctionException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                ExpressionInfo info1 = new ExpressionInfo("tempFunc1", "func1");
                ExpressionInfo info2 = new ExpressionInfo("tempFunc2", "yes_me");
                Serializable tempFunc1 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Seq<Expression> e) {
                        return (Expression)e.head();
                    }
                };
                Serializable tempFunc2 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Seq<Expression> e) {
                        return (Expression)e.last();
                    }
                };
                catalog.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("func2", (Option<String>)new Some((Object)"db2")), false);
                catalog.createFunction(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newFunc("not_me", (Option<String>)new Some((Object)"db2")), false);
                catalog.createTempFunction("func1", info1, (Function1)tempFunc1, false);
                catalog.createTempFunction("yes_me", info2, (Function1)tempFunc2, false);
                Set $org_scalatest_assert_macro_left = ((TraversableOnce)catalog.listFunctions("db1", "*").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionIdentifier apply(Tuple2<FunctionIdentifier, String> x$1) {
                        return (FunctionIdentifier)x$1._1();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FunctionIdentifier[]{FunctionIdentifier$.MODULE$.apply("func1"), FunctionIdentifier$.MODULE$.apply("yes_me")}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = ((TraversableOnce)catalog.listFunctions("db2", "*").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionIdentifier apply(Tuple2<FunctionIdentifier, String> x$2) {
                        return (FunctionIdentifier)x$2._1();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FunctionIdentifier[]{FunctionIdentifier$.MODULE$.apply("func1"), FunctionIdentifier$.MODULE$.apply("yes_me"), new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), new FunctionIdentifier("func2", (Option)new Some((Object)"db2")), new FunctionIdentifier("not_me", (Option)new Some((Object)"db2"))}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = ((TraversableOnce)catalog.listFunctions("db2", "func*").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionIdentifier apply(Tuple2<FunctionIdentifier, String> x$3) {
                        return (FunctionIdentifier)x$3._1();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FunctionIdentifier[]{FunctionIdentifier$.MODULE$.apply("func1"), new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), new FunctionIdentifier("func2", (Option)new Some((Object)"db2"))}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("list functions when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SessionCatalog catalog = new SessionCatalog(this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalogSuite$$utils().newBasicCatalog());
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final SessionCatalog catalog$38;

                    public final Seq<Tuple2<FunctionIdentifier, String>> apply() {
                        return this.catalog$38.listFunctions("unknown_db", "func*");
                    }
                    {
                        this.catalog$38 = catalog$38;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchDatabaseException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

