/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExamplePointUDT;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u001f\ty!k\\<F]\u000e|G-\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005AQM\\2pI\u0016\u00148O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%IaG\u0001\u000fgR\u0014Xo\u0019;PMN#(/\u001b8h+\u0005a\u0002CA\u000f!\u001b\u0005q\"BA\u0010\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t\tcD\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\t\u0001!\u0002\u0013a\u0012aD:ueV\u001cGo\u00144TiJLgn\u001a\u0011\t\u000f\u0015\u0002!\u0019!C\u00057\u0005Y1\u000f\u001e:vGR|e-\u0016#U\u0011\u00199\u0003\u0001)A\u00059\u0005a1\u000f\u001e:vGR|e-\u0016#UA!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0013!D1se\u0006LxJZ*ue&tw-F\u0001,!\tiB&\u0003\u0002.=\tI\u0011I\u001d:bsRK\b/\u001a\u0005\u0007_\u0001\u0001\u000b\u0011B\u0016\u0002\u001d\u0005\u0014(/Y=PMN#(/\u001b8hA!9\u0011\u0007\u0001b\u0001\n\u0013Q\u0013aC1se\u0006LxJ\u001a(vY2Daa\r\u0001!\u0002\u0013Y\u0013\u0001D1se\u0006LxJ\u001a(vY2\u0004\u0003bB\u001b\u0001\u0005\u0004%IAN\u0001\f[\u0006\u0004xJZ*ue&tw-F\u00018!\ti\u0002(\u0003\u0002:=\t9Q*\u00199UsB,\u0007BB\u001e\u0001A\u0003%q'\u0001\u0007nCB|em\u0015;sS:<\u0007\u0005C\u0004>\u0001\t\u0007I\u0011\u0002\u0016\u0002\u0015\u0005\u0014(/Y=PMV#E\u000b\u0003\u0004@\u0001\u0001\u0006IaK\u0001\fCJ\u0014\u0018-_(g+\u0012#\u0006\u0005C\u0003B\u0001\u0011%!)\u0001\tf]\u000e|G-\u001a#fG>$W\rV3tiR\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0005+:LG\u000fC\u0003K\u0001\u0002\u0007A$\u0001\u0004tG\",W.\u0019")
public class RowEncoderSuite
extends SparkFunSuite {
    private final StructType structOfString = new StructType().add("str", (DataType)StringType$.MODULE$);
    private final StructType structOfUDT = new StructType().add("udt", (DataType)new ExamplePointUDT(), false);
    private final ArrayType arrayOfString = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
    private final ArrayType arrayOfNull = ArrayType$.MODULE$.apply((DataType)NullType$.MODULE$);
    private final MapType mapOfString = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
    private final ArrayType arrayOfUDT = new ArrayType((DataType)new ExamplePointUDT(), false);

    private StructType structOfString() {
        return this.structOfString;
    }

    private StructType structOfUDT() {
        return this.structOfUDT;
    }

    private ArrayType arrayOfString() {
        return this.arrayOfString;
    }

    private ArrayType arrayOfNull() {
        return this.arrayOfNull;
    }

    private MapType mapOfString() {
        return this.mapOfString;
    }

    private ArrayType arrayOfUDT() {
        return this.arrayOfUDT;
    }

    private void encodeDecodeTest(StructType schema) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"encode/decode: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.simpleString()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, schema){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;
            private final StructType schema$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExpressionEncoder qual$6 = RowEncoder$.MODULE$.apply(this.schema$1);
                Seq x$11 = qual$6.resolveAndBind$default$1();
                Analyzer x$12 = qual$6.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$6.resolveAndBind(x$11, x$12);
                Function0 inputGenerator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)this.schema$1, false, RandomDataGenerator$.MODULE$.forType$default$3()).get();
                ObjectRef input = new ObjectRef(null);
                try {
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this, encoder, inputGenerator, input){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$encodeDecodeTest$1 $outer;
                        private final ExpressionEncoder encoder$2;
                        private final Function0 inputGenerator$1;
                        private final ObjectRef input$1;

                        public final void apply(int _) {
                            this.apply$mcVI$sp(_);
                        }

                        public void apply$mcVI$sp(int _) {
                            this.input$1.elem = (Row)this.inputGenerator$1.apply();
                            InternalRow row = this.encoder$2.toRow((Object)((Row)this.input$1.elem));
                            Row convertedBack = (Row)this.encoder$2.fromRow(row);
                            Row $org_scalatest_assert_macro_left = (Row)this.input$1.elem;
                            Row $org_scalatest_assert_macro_right = convertedBack;
                            Row row2 = $org_scalatest_assert_macro_left;
                            Row row3 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(row2 != null ? !row2.equals(row3) : row3 != null));
                            this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.encoder$2 = encoder$2;
                            this.inputGenerator$1 = inputGenerator$1;
                            this.input$1 = input$1;
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    throw this.$outer.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |schema: ", "\n               |input: ", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$1.simpleString(), (Row)input.elem})))).stripMargin(), exception);
                }
            }

            public /* synthetic */ RowEncoderSuite org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.schema$1 = schema$1;
            }
        });
    }

    public RowEncoderSuite() {
        this.encodeDecodeTest(new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("float", (DataType)FloatType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("string", (DataType)StringType$.MODULE$).add("binary", (DataType)BinaryType$.MODULE$).add("date", (DataType)DateType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$).add("udt", (DataType)new ExamplePointUDT()));
        this.encodeDecodeTest(new StructType().add("arrayOfNull", (DataType)this.arrayOfNull()).add("arrayOfString", (DataType)this.arrayOfString()).add("arrayOfArrayOfString", (DataType)ArrayType$.MODULE$.apply((DataType)this.arrayOfString())).add("arrayOfArrayOfInt", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))).add("arrayOfMap", (DataType)ArrayType$.MODULE$.apply((DataType)this.mapOfString())).add("arrayOfStruct", (DataType)ArrayType$.MODULE$.apply((DataType)this.structOfString())).add("arrayOfUDT", (DataType)this.arrayOfUDT()));
        this.encodeDecodeTest(new StructType().add("mapOfIntAndString", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)).add("mapOfStringAndArray", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.arrayOfString())).add("mapOfArrayAndInt", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)IntegerType$.MODULE$)).add("mapOfArray", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)this.arrayOfString())).add("mapOfStringAndStruct", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.structOfString())).add("mapOfStructAndString", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)StringType$.MODULE$)).add("mapOfStruct", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)this.structOfString())));
        this.encodeDecodeTest(new StructType().add("structOfString", (DataType)this.structOfString()).add("structOfStructOfString", (DataType)new StructType().add("struct", (DataType)this.structOfString())).add("structOfArray", (DataType)new StructType().add("array", (DataType)this.arrayOfString())).add("structOfMap", (DataType)new StructType().add("map", (DataType)this.mapOfString())).add("structOfArrayAndMap", (DataType)new StructType().add("array", (DataType)this.arrayOfString()).add("map", (DataType)this.mapOfString())).add("structOfUDT", (DataType)this.structOfUDT()));
        this.test("encode/decode decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("string", (DataType)StringType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("java_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("scala_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("catalyst_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
                Seq x$1 = qual$1.resolveAndBind$default$1();
                Analyzer x$2 = qual$1.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$1.resolveAndBind(x$1, x$2);
                java.math.BigDecimal javaDecimal = new java.math.BigDecimal("1234.5678");
                BigDecimal scalaDecimal = package$.MODULE$.BigDecimal().apply("1234.5678");
                Decimal catalystDecimal = Decimal$.MODULE$.apply("1234.5678");
                Row input = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100), "test", BoxesRunTime.boxToDouble((double)0.123), javaDecimal, scalaDecimal, catalystDecimal}));
                InternalRow row = encoder.toRow((Object)input);
                Row convertedBack = (Row)encoder.fromRow(row);
                int $org_scalatest_assert_macro_left = convertedBack.getDecimal(3).compareTo(javaDecimal);
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int $org_scalatest_assert_macro_left2 = convertedBack.getDecimal(4).compareTo(scalaDecimal.bigDecimal());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                int $org_scalatest_assert_macro_left3 = convertedBack.getDecimal(5).compareTo(catalystDecimal.toJavaBigDecimal());
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RowEncoder should preserve decimal precision and scale", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("decimal", (DataType)new DecimalType(10, 5), false);
                ExpressionEncoder qual$2 = RowEncoder$.MODULE$.apply(schema);
                Seq x$3 = qual$2.resolveAndBind$default$1();
                Analyzer x$4 = qual$2.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$2.resolveAndBind(x$3, x$4);
                Decimal decimal = Decimal$.MODULE$.apply("67123.45");
                Row input = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal}));
                InternalRow row = encoder.toRow((Object)input);
                Object $org_scalatest_assert_macro_left = row.toSeq(schema).head();
                Decimal $org_scalatest_assert_macro_right = decimal;
                Object object = $org_scalatest_assert_macro_left;
                Decimal decimal2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(decimal2) : decimal2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RowEncoder should preserve schema nullability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$, false);
                ExpressionEncoder qual$3 = RowEncoder$.MODULE$.apply(schema);
                Seq x$5 = qual$3.resolveAndBind$default$1();
                Analyzer x$6 = qual$3.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$3.resolveAndBind(x$5, x$6);
                Seq $org_scalatest_assert_macro_left = encoder.serializer();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder.serializer().head()).dataType();
                IntegerType$ $org_scalatest_assert_macro_right2 = IntegerType$.MODULE$;
                DataType dataType = $org_scalatest_assert_macro_left2;
                IntegerType$ integerType$ = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder.serializer().head()).nullable();
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RowEncoder should preserve nested column name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$, false).add("s", (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$, false), false), false);
                ExpressionEncoder qual$4 = RowEncoder$.MODULE$.apply(schema);
                Seq x$7 = qual$4.resolveAndBind$default$1();
                Analyzer x$8 = qual$4.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$4.resolveAndBind(x$7, x$8);
                Seq $org_scalatest_assert_macro_left = encoder.serializer();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder.serializer().head()).dataType();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("i", (DataType)IntegerType$.MODULE$, false).add("s", (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$, false), false);
                DataType dataType = $org_scalatest_assert_macro_left2;
                StructType structType = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(structType) : structType != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder.serializer().head()).nullable();
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RowEncoder should support array as the external type for ArrayType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("array", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).add("nestedArray", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$))).add("deepNestedArray", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$))));
                ExpressionEncoder qual$5 = RowEncoder$.MODULE$.apply(schema);
                Seq x$9 = qual$5.resolveAndBind$default$1();
                Analyzer x$10 = qual$5.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$5.resolveAndBind(x$9, x$10);
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = BoxesRunTime.boxToInteger((int)1);
                objectArray2[1] = BoxesRunTime.boxToInteger((int)2);
                objectArray2[2] = null;
                objectArray[0] = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray2), ClassTag$.MODULE$.Any());
                String[][] stringArrayArray = new String[2][];
                String[] stringArray = new String[2];
                stringArray[0] = "abc";
                stringArray[1] = null;
                stringArrayArray[0] = (String[])((Object[])stringArray);
                stringArrayArray[1] = null;
                objectArray[1] = (Object[])stringArrayArray;
                Seq[] seqArray = new Seq[2];
                Object[][] objectArrayArray = new Object[2][];
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = BoxesRunTime.boxToLong((long)0L);
                objectArray3[1] = null;
                objectArrayArray[0] = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray3), ClassTag$.MODULE$.Any());
                objectArrayArray[1] = null;
                seqArray[0] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])objectArrayArray));
                seqArray[1] = null;
                objectArray[2] = seqArray;
                Row input = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                InternalRow row = encoder.toRow((Object)input);
                Row convertedBack = (Row)encoder.fromRow(row);
                Seq $org_scalatest_assert_macro_left = convertedBack.getSeq(0);
                Object[] objectArray4 = new Object[3];
                objectArray4[0] = BoxesRunTime.boxToInteger((int)1);
                objectArray4[1] = BoxesRunTime.boxToInteger((int)2);
                objectArray4[2] = null;
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray4));
                Seq seq = $org_scalatest_assert_macro_left;
                Seq seq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq $org_scalatest_assert_macro_left2 = convertedBack.getSeq(1);
                Seq[] seqArray2 = new Seq[2];
                String[] stringArray2 = new String[2];
                stringArray2[0] = "abc";
                stringArray2[1] = null;
                seqArray2[0] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray2));
                seqArray2[1] = null;
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])seqArray2));
                Seq seq3 = $org_scalatest_assert_macro_left2;
                Seq seq4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq $org_scalatest_assert_macro_left3 = convertedBack.getSeq(2);
                Seq[] seqArray3 = new Seq[2];
                Seq[] seqArray4 = new Seq[2];
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = BoxesRunTime.boxToLong((long)0L);
                objectArray5[1] = null;
                seqArray4[0] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray5));
                seqArray4[1] = null;
                seqArray3[0] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])seqArray4));
                seqArray3[1] = null;
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])seqArray3));
                Seq seq5 = $org_scalatest_assert_macro_left3;
                Seq seq6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq5 != null ? !seq5.equals(seq6) : seq6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RowEncoder should throw RuntimeException if input row object is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$);
                ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                RuntimeException e = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this, encoder){
                    public static final long serialVersionUID = 0L;
                    private final ExpressionEncoder encoder$1;

                    public final InternalRow apply() {
                        return this.encoder$1.toRow(null);
                    }
                    {
                        this.encoder$1 = encoder$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Null value appeared in non-nullable field";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "top level row object";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RowEncoder should validate external type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RuntimeException e1 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)IntegerType$.MODULE$);
                        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                        return encoder.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)1))})));
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "java.lang.Short is not a valid external type";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RuntimeException e2 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)StringType$.MODULE$);
                        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                        return encoder.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "java.lang.Integer is not a valid external type";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RuntimeException e3 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)StringType$.MODULE$));
                        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                        return encoder.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})));
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                String $org_scalatest_assert_macro_left3 = e3.getMessage();
                String $org_scalatest_assert_macro_right3 = "scala.Tuple2 is not a valid external type";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                RuntimeException e4 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)ArrayType$.MODULE$.apply((DataType)TimestampType$.MODULE$));
                        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                        return encoder.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String[]{"a"}})));
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                String $org_scalatest_assert_macro_left4 = e4.getMessage();
                String $org_scalatest_assert_macro_right4 = "java.lang.String is not a valid external type";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

