/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Exists$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameBoundary;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.UnresolvedWindowExpression;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.ValueFollowing;
import org.apache.spark.sql.catalyst.expressions.ValuePreceding;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.WindowSpecReference;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ExpressionParserSuite$;
import org.apache.spark.sql.catalyst.parser.ExpressionParserSuite$$anonfun$19$;
import org.apache.spark.sql.catalyst.parser.ExpressionParserSuite$$anonfun$30$;
import org.apache.spark.sql.catalyst.parser.ExpressionParserSuite$$anonfun$30$$anonfun$apply$mcV$sp$4$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001f\t)R\t\u001f9sKN\u001c\u0018n\u001c8QCJ\u001cXM]*vSR,'BA\u0002\u0005\u0003\u0019\u0001\u0018M]:fe*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tQ\u0001\u001d7b]NL!!\u0006\n\u0003\u0011Ac\u0017M\u001c+fgRDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000bq\u0001A\u0011A\u000f\u0002\u0017\u0005\u001c8/\u001a:u\u000bF,\u0018\r\u001c\u000b\u0004=\u0011j\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDQ!J\u000eA\u0002\u0019\n!b]9m\u0007>lW.\u00198e!\t9#F\u0004\u0002 Q%\u0011\u0011\u0006I\u0001\u0007!J,G-\u001a4\n\u0005-b#AB*ue&twM\u0003\u0002*A!)af\u0007a\u0001_\u0005\tQ\r\u0005\u00021g5\t\u0011G\u0003\u00023\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t!\u0014G\u0001\u0006FqB\u0014Xm]:j_:DQA\u000e\u0001\u0005\u0002]\n\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0015\u0007yA\u0014\bC\u0003&k\u0001\u0007a\u0005C\u0003;k\u0001\u00071(\u0001\u0005nKN\u001c\u0018mZ3t!\ryBHJ\u0005\u0003{\u0001\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public class ExpressionParserSuite
extends PlanTest {
    public void assertEqual(String sqlCommand, Expression e) {
        this.compareExpressions(CatalystSqlParser$.MODULE$.parseExpression(sqlCommand), e);
    }

    public void intercept(String sqlCommand, Seq<String> messages) {
        ParseException e = (ParseException)this.intercept((Function0)new Serializable(this, sqlCommand){
            public static final long serialVersionUID = 0L;
            private final String sqlCommand$1;

            public final Expression apply() {
                return CatalystSqlParser$.MODULE$.parseExpression(this.sqlCommand$1);
            }
            {
                this.sqlCommand$1 = sqlCommand$1;
            }
        }, ManifestFactory$.MODULE$.classType(ParseException.class));
        messages.foreach((Function1)new Serializable(this, e){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;
            private final ParseException e$1;

            public final void apply(String message) {
                String $org_scalatest_assert_macro_left = this.e$1.message();
                String $org_scalatest_assert_macro_right = message;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.e$1 = e$1;
            }
        });
    }

    public ExpressionParserSuite() {
        this.test("star expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("*", (Expression)new UnresolvedStar((Option)None$.MODULE$));
                this.$outer.assertEqual("a.b.*", (Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("named expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Symbol r0 = Symbol$.MODULE$.apply("a");
                this.$outer.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(r0));
                NamedExpression r1 = package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).as("b");
                this.$outer.assertEqual("a as b", (Expression)r1);
                this.$outer.assertEqual("a b", (Expression)r1);
                this.$outer.assertEqual("a as (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))));
                this.$outer.assertEqual("a() (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).function((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))));
                this.$outer.assertEqual("1SL", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("1SL")));
                this.$outer.assertEqual("a.* b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))))).as(Symbol$.MODULE$.apply("b")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a and b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a or b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a and b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d")))));
                this.$outer.assertEqual("a or b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d")))));
                this.$outer.assertEqual("a or b or c or d or e or f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("d")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("e")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("f")))));
                this.$outer.assertEqual("a and b and c and d and e and f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("d")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("e")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("f")))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("long binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.testVeryBinaryExpression$1(" AND ", And.class);
                this.testVeryBinaryExpression$1(" OR ", Or.class);
            }

            private final void testVeryBinaryExpression$1(String op, Class clazz) {
                String sql = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)x)}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(op);
                Expression e = CatalystSqlParser$.MODULE$.parseExpression(sql);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = A1 instanceof EqualTo ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        boolean bl = expression instanceof EqualTo;
                        return bl;
                    }
                }).size()));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new Serializable(this, clazz){
                    public static final long serialVersionUID = 0L;
                    private final Class clazz$1;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        Object object = this.clazz$1.isInstance(A1) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x2) {
                        Expression expression = x2;
                        boolean bl = this.clazz$1.isInstance(expression);
                        return bl;
                    }
                    {
                        this.clazz$1 = clazz$1;
                    }
                }).size()));
                int $org_scalatest_assert_macro_right2 = 999;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("not expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("not a", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).unary_$bang());
                this.$outer.assertEqual("!a", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).unary_$bang());
                this.$outer.assertEqual("not true > true", (Expression)new Not((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.booleanToLiteral(true), (Expression)package.expressions$.MODULE$.booleanToLiteral(true))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("exists expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("exists (select 1 from b where b.x = a.x)", (Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("b")).where((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("b.x")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a.x"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), Exists$.MODULE$.apply$default$2()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("comparison expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a = b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a == b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a <=> b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a <> b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a != b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a < b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$less((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a <= b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a !> b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a > b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a >= b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a !< b", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("between expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")))));
                this.$outer.assertEqual("a not between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c"))))).unary_$bang());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("in expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a in (b, c, d)", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d"))})));
                this.$outer.assertEqual("a not in (b, c, d)", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d"))}))).unary_$bang());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("in sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a in (select b from c)", (Expression)new In((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ListQuery[]{new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), ListQuery$.MODULE$.apply$default$2())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("like expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a like 'pattern%'", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")));
                this.$outer.assertEqual("a not like 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang());
                this.$outer.assertEqual("a rlike 'pattern%'", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")));
                this.$outer.assertEqual("a not rlike 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang());
                this.$outer.assertEqual("a regexp 'pattern%'", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")));
                this.$outer.assertEqual("a not regexp 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("is null expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a is null", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).isNull());
                this.$outer.assertEqual("a is not null", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).isNotNull());
                this.$outer.assertEqual("a = b is null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).isNull());
                this.$outer.assertEqual("a = b is not null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).isNotNull());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a * b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a / b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a DIV b", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).cast((DataType)LongType$.MODULE$));
                this.$outer.assertEqual("a % b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a + b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a - b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a & b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a ^ b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$up((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a | b", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a * t | b ^ c & d - e + f % g DIV h / i * k", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("t")))).$bar(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("b")).$up(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("c")).$amp(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("d")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("e")))).$plus(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("f")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("g")))).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("h")))).cast((DataType)LongType$.MODULE$)).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("i")))).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("k"))))))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("+a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")));
                this.$outer.assertEqual("-a", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).unary_$minus());
                this.$outer.assertEqual("~a", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).unary_$tilde());
                this.$outer.assertEqual("-+~~a", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).unary_$tilde()).unary_$tilde()).unary_$minus());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cast expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("cast(a as int)", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).cast((DataType)IntegerType$.MODULE$));
                this.$outer.assertEqual("cast(a as timestamp)", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).cast((DataType)TimestampType$.MODULE$));
                this.$outer.assertEqual("cast(a as array<int>)", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).cast((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)));
                this.$outer.assertEqual("cast(cast(a as int) as long)", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).cast((DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("foo()", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("foo")).function((Seq)Nil$.MODULE$));
                this.$outer.assertEqual("foo.bar()", (Expression)new UnresolvedFunction(new FunctionIdentifier("bar", (Option)new Some((Object)"foo")), (Seq)Seq$.MODULE$.empty(), false));
                this.$outer.assertEqual("foo(*)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                this.$outer.assertEqual("count(*)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("count")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})));
                this.$outer.assertEqual("foo(a, b)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})));
                this.$outer.assertEqual("foo(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})));
                this.$outer.assertEqual("foo(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("foo")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})));
                this.$outer.assertEqual("grouping(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("grouping")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})));
                this.$outer.assertEqual("`select`(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("select")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
                this.$outer.assertEqual("foo(*) over w1", (Expression)new UnresolvedWindowExpression((Expression)func, new WindowSpecReference("w1")));
                this.$outer.assertEqual("foo(*) over ()", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1(this.windowed$default$1$1(), this.windowed$default$2$1(), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (partition by a, b)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), this.windowed$default$2$1(), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (distribute by a, b)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), this.windowed$default$2$1(), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (cluster by a, b)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), this.windowed$default$2$1(), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (order by a desc, b asc)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).desc(), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("b")).asc()})), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (sort by a desc, b asc)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).desc(), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("b")).asc()})), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (partition by a, b order by c)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("c")).asc()})), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("foo(*) over (distribute by a, b sort by c)", this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("c")).asc()})), this.windowed$default$3$1(), func));
                this.$outer.assertEqual("sum(product + 1) over (partition by ((product) + (1)) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)));
                this.$outer.assertEqual("sum(product + 1) over (partition by ((product / 2) + 1) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("product")).$div((Expression)package.expressions$.MODULE$.intToLiteral(2))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)));
                Seq frameTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"rows", (Object)RowFrame$.MODULE$), new Tuple2((Object)"range", (Object)RangeFrame$.MODULE$)}));
                Seq boundaries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"10 preceding", (Object)new ValuePreceding(10), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 following", (Object)new ValueFollowing(4), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"unbounded preceding", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"unbounded following", (Object)UnboundedFollowing$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between unbounded preceding and current row", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between unbounded preceding and unbounded following", (Object)UnboundedPreceding$.MODULE$, (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and current row", (Object)new ValuePreceding(10), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and 5 following", (Object)CurrentRow$.MODULE$, (Object)new ValueFollowing(5)), new Tuple3((Object)"between 10 preceding and 5 following", (Object)new ValuePreceding(10), (Object)new ValueFollowing(5))}));
                frameTypes.foreach((Function1)new Serializable(this, func, boundaries){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;
                    public final UnresolvedFunction func$1;
                    private final Seq boundaries$1;

                    public final void apply(Tuple2<String, Product> x0$1) {
                        Tuple2<String, Product> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String frameTypeSql = (String)tuple2._1();
                            Product frameType = (Product)tuple2._2();
                            this.boundaries$1.foreach((Function1)new Serializable(this, frameTypeSql, frameType){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$19$$anonfun$apply$mcV$sp$1 $outer;
                                private final String frameTypeSql$1;
                                private final Product frameType$1;

                                public final void apply(Tuple3<String, Product, Product> x0$2) {
                                    Tuple3<String, Product, Product> tuple3 = x0$2;
                                    if (tuple3 != null) {
                                        String boundarySql = (String)tuple3._1();
                                        Product begin = (Product)tuple3._2();
                                        Product end = (Product)tuple3._3();
                                        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo(*) over (partition by a order by b ", " ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.frameTypeSql$1, boundarySql}));
                                        Expression expr = this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("b")).asc()})), (WindowFrame)new SpecifiedWindowFrame((FrameType)this.frameType$1, (FrameBoundary)begin, (FrameBoundary)end), this.$outer.func$1);
                                        this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer().assertEqual(query, expr);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple3);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.frameTypeSql$1 = frameTypeSql$1;
                                    this.frameType$1 = frameType$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$19 org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.func$1 = func$1;
                        this.boundaries$1 = boundaries$1;
                    }
                });
                this.$outer.intercept("foo(*) over (partition by a order by b rows 10.0 preceding)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame bound value must be a constant integer."}));
                this.$outer.intercept("foo(*) over (partition by a order by b rows exp(b) preceding)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame bound value must be a constant integer."}));
            }

            public /* synthetic */ ExpressionParserSuite org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final Expression org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$windowed$1(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$1) {
                return new WindowExpression((Expression)func$1, new WindowSpecDefinition(partitioning, ordering, frame));
            }

            private final Seq windowed$default$1$1() {
                return (Seq)Seq$.MODULE$.empty();
            }

            private final Seq windowed$default$2$1() {
                return (Seq)Seq$.MODULE$.empty();
            }

            private final WindowFrame windowed$default$3$1() {
                return UnspecifiedFrame$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("row constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("(a, b)", (Expression)new CreateStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))}))));
                this.$outer.assertEqual("(a, b, c)", (Expression)new CreateStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c"))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("(select max(val) from tbl) > current", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("tbl")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("max")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("val"))}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("current"))));
                this.$outer.assertEqual("a = (select b from s)", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("s")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("case when", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("case a when 1 then b when 2 then c else d end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")), package.expressions$.MODULE$.intToLiteral(2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d"))}))));
                this.$outer.assertEqual("case (a or b) when true then c when false then d else e end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("c")), package.expressions$.MODULE$.booleanToLiteral(false), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("e"))}))));
                this.$outer.assertEqual("case 'a'='a' when true then 1 end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslString("a").$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.intToLiteral(1)}))));
                this.$outer.assertEqual("case when a = 1 then b when a = 2 then c else d end", (Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Object)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("b")).expr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (Object)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("c")).expr())})), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("d"))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dereference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a.b", (Expression)UnresolvedAttribute$.MODULE$.apply("a.b"));
                this.$outer.assertEqual("`select`.b", (Expression)UnresolvedAttribute$.MODULE$.apply("select.b"));
                this.$outer.assertEqual("(a + b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))).getField("b"));
                this.$outer.assertEqual("struct(a, b).b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("struct")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))}))).getField("b"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")));
                this.$outer.assertEqual("1a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("1a")));
                this.$outer.assertEqual("`select`", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("select")));
                this.$outer.assertEqual("columns", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("columns")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("subscript", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("a[b]", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
                this.$outer.assertEqual("a[1 + 1]", (Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).getItem(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))));
                this.$outer.assertEqual("`c`.a[b]", (Expression)package.expressions$.MODULE$.DslExpression((Expression)UnresolvedAttribute$.MODULE$.apply("c.a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b"))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("(a)", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("a")));
                this.$outer.assertEqual("r * (a + b)", package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("r")).$times(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("b")))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("type constructors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("dAte '2016-03-11'", (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-03-11")));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply() {
                        return CatalystSqlParser$.MODULE$.parseExpression("DAtE 'mar 11 2016'");
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply() {
                        return CatalystSqlParser$.MODULE$.parseExpression("timestamP '2016-33-11 20:54:00.000'");
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept("GEO '(10,-6)'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Literals of type 'GEO' are currently not supported."}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("null", (Expression)Literal$.MODULE$.apply(null));
                this.$outer.assertEqual("trUe", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.$outer.assertEqual("False", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assertEqual("787324", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)787324)));
                this.$outer.assertEqual("7873247234798249234", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)7873247234798249234L)));
                this.$outer.assertEqual("78732472347982492793712334", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("78732472347982492793712334").underlying()));
                this.$outer.assertEqual("7873247234798249279371.2334", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("7873247234798249279371.2334").underlying()));
                this.$outer.assertEqual("9.0e1", (Expression)package.expressions$.MODULE$.doubleToLiteral(90.0));
                this.$outer.assertEqual(".9e+2", (Expression)package.expressions$.MODULE$.doubleToLiteral(90.0));
                this.$outer.assertEqual("0.9e+2", (Expression)package.expressions$.MODULE$.doubleToLiteral(90.0));
                this.$outer.assertEqual("900e-1", (Expression)package.expressions$.MODULE$.doubleToLiteral(90.0));
                this.$outer.assertEqual("900.0E-1", (Expression)package.expressions$.MODULE$.doubleToLiteral(90.0));
                this.$outer.assertEqual("9.e+1", (Expression)package.expressions$.MODULE$.doubleToLiteral(90.0));
                this.$outer.intercept(".e3", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                this.$outer.assertEqual("10Y", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)10))));
                this.$outer.intercept("-1000Y", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToByte((byte)127)}))}));
                this.$outer.assertEqual("10S", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)10))));
                this.$outer.intercept("40000S", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToShort((short)Short.MAX_VALUE)}))}));
                this.$outer.assertEqual("10L", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)));
                this.$outer.intercept("78732472347982492793712334L", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToLong((long)Long.MAX_VALUE)}))}));
                this.$outer.assertEqual("10.0D", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)10.0)));
                this.$outer.intercept("-1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"})).s((Seq)Nil$.MODULE$)}));
                this.$outer.intercept("1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"})).s((Seq)Nil$.MODULE$)}));
                this.$outer.assertEqual("1E309", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)));
                this.$outer.assertEqual("90912830918230182310293801923652346786BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("90912830918230182310293801923652346786").underlying()));
                this.$outer.assertEqual("123.0E-28BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("123.0E-28").underlying()));
                this.$outer.assertEqual("123.08BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("123.08").underlying()));
                this.$outer.intercept("1.20E-38BD", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecimalType can only support precision up to 38"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("strings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("\"hello\"", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"));
                this.$outer.assertEqual("'hello'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"));
                this.$outer.assertEqual("\"hello\" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("helloworld"));
                this.$outer.assertEqual("'hello' \" \" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello world"));
                this.$outer.assertEqual("'pattern%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"));
                this.$outer.assertEqual("'no-pattern\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("no-pattern\\%"));
                this.$outer.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\%"));
                this.$outer.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"));
                this.$outer.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u0000"));
                this.$outer.assertEqual("'\\''", (Expression)package.expressions$.MODULE$.stringToLiteral("'"));
                this.$outer.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\""));
                this.$outer.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\b"));
                this.$outer.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\n"));
                this.$outer.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\r"));
                this.$outer.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\t"));
                this.$outer.assertEqual("'\\Z'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u001a"));
                this.$outer.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("Hello!"));
                this.$outer.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("World :)"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept("interval", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"at least one time unit should be given for interval literal"}));
                Seq units = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month", "week", "day", "hour", "minute", "second", "millisecond", "microsecond"}));
                Seq forms = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"}));
                Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "-7", "21"}));
                units.foreach((Function1)new Serializable(this, forms, values){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;
                    private final Seq forms$1;
                    public final Seq values$1;

                    public final void apply(String unit) {
                        this.forms$1.foreach((Function1)new Serializable(this, unit){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$30$$anonfun$apply$mcV$sp$4 $outer;
                            public final String unit$1;

                            public final void apply(String form) {
                                this.$outer.values$1.foreach((Function1)new Serializable(this, form){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$30$$anonfun$apply$mcV$sp$4$$anonfun$apply$2 $outer;
                                    private final String form$1;

                                    public final void apply(String value) {
                                        Literal expected = this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$intervalLiteral$1(this.$outer.unit$1, value);
                                        this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer().assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interval ", " ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, this.$outer.unit$1, this.form$1})), (Expression)expected);
                                        this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer().assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interval '", "' ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, this.$outer.unit$1, this.form$1})), (Expression)expected);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.form$1 = form$1;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$30$$anonfun$apply$mcV$sp$4 org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.unit$1 = unit$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$30 org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.forms$1 = forms$1;
                        this.values$1 = values$1;
                    }
                });
                this.$outer.assertEqual("interval 13.123456789 seconds", (Expression)this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$intervalLiteral$1("second", "13.123456789"));
                this.$outer.assertEqual("interval -13.123456789 second", (Expression)this.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$intervalLiteral$1("second", "-13.123456789"));
                this.$outer.intercept("interval 10 nanoseconds", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No interval can be constructed"}));
                Seq yearMonthValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"123-10", "496-0", "-2-3", "-123-0"}));
                yearMonthValues.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;

                    public final void apply(String value) {
                        Literal result = Literal$.MODULE$.apply((Object)CalendarInterval.fromYearMonthString((String)value));
                        this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer().assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interval '", "' year to month"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), (Expression)result);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Seq datTimeValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"99 11:22:33.123456789", "-99 11:22:33.123456789", "10 9:8:7.123456789", "1 0:0:0", "-1 0:0:0", "1 0:0:1"}));
                datTimeValues.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;

                    public final void apply(String value) {
                        Literal result = Literal$.MODULE$.apply((Object)CalendarInterval.fromDayTimeString((String)value));
                        this.$outer.org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer().assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interval '", "' day to second"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), (Expression)result);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.intercept("interval 10 month to second", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals FROM month TO second are not supported."}));
                this.$outer.assertEqual("interval 3 months 22 seconds 1 millisecond", (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(3, 22001000L)));
                this.$outer.assertEqual("interval 3 years '-1-10' year to month 3 weeks '1 0:0:2' day to second", (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(14, 1900802000000L)));
            }

            public /* synthetic */ ExpressionParserSuite org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final Literal org$apache$spark$sql$catalyst$parser$ExpressionParserSuite$$anonfun$$intervalLiteral$1(String u, String s) {
                return Literal$.MODULE$.apply((Object)CalendarInterval.fromSingleUnitString((String)u, (String)s));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("composed expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("1 + r.r As q", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)UnresolvedAttribute$.MODULE$.apply("r.r"))).as("q"));
                this.$outer.assertEqual("1 - f('o', o(bar))", package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$minus((Expression)package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("f")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("o"), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("o")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("bar"))}))}))));
                this.$outer.intercept("1 - f('o', o(bar)) hello * world", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input '*'"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("current date/timestamp braceless expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("current_date", (Expression)new CurrentDate());
                this.$outer.assertEqual("current_timestamp", (Expression)new CurrentTimestamp());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-17364, fully qualified column name which starts with number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertEqual("123_", (Expression)UnresolvedAttribute$.MODULE$.apply("123_"));
                this.$outer.assertEqual("1a.123_", (Expression)UnresolvedAttribute$.MODULE$.apply("1a.123_"));
                this.$outer.assertEqual("a.123A", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123A"));
                this.$outer.assertEqual("a.123E3_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123E3_column"));
                this.$outer.assertEqual("a.123D_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123D_column"));
                this.$outer.assertEqual("a.123BD_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123BD_column"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-17832 function identifier contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FunctionIdentifier complexName = new FunctionIdentifier("`ba`r", (Option)new Some((Object)"`fo`o"));
                this.$outer.assertEqual(complexName.quotedString(), (Expression)UnresolvedAttribute$.MODULE$.apply("`fo`o.`ba`r"));
                this.$outer.intercept(complexName.unquotedString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input"}));
                FunctionIdentifier complexName2 = new FunctionIdentifier("ba``r", (Option)new Some((Object)"fo``o"));
                this.$outer.assertEqual(complexName2.quotedString(), (Expression)UnresolvedAttribute$.MODULE$.apply("fo``o.ba``r"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

