/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.TableIdentifierParserSuite$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001f\tQB+\u00192mK&#WM\u001c;jM&,'\u000fU1sg\u0016\u00148+^5uK*\u00111\u0001B\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\b5\u0001\u0011\r\u0011\"\u0001\u001c\u0003YA\u0017N^3O_:\u0014Vm]3sm\u0016$7*Z=x_J$W#\u0001\u000f\u0011\u0007u\u0001#%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0015\t%O]1z!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u0015;sS:<\u0007BB\u0016\u0001A\u0003%A$A\fiSZ,gj\u001c8SKN,'O^3e\u0017\u0016Lxo\u001c:eA!9Q\u0006\u0001b\u0001\n\u0003q\u0013\u0001\b5jm\u0016\u001cFO]5di:{gNU3tKJ4X\rZ&fs^|'\u000fZ\u000b\u0002_A\u0019\u0001g\r\u0012\u000e\u0003ER!A\r\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00025c\t\u00191+Z9\t\rY\u0002\u0001\u0015!\u00030\u0003uA\u0017N^3TiJL7\r\u001e(p]J+7/\u001a:wK\u0012\\U-_<pe\u0012\u0004\u0003")
public class TableIdentifierParserSuite
extends SparkFunSuite {
    private final String[] hiveNonReservedKeyword = (String[])((Object[])new String[]{"add", "admin", "after", "analyze", "archive", "asc", "before", "bucket", "buckets", "cascade", "change", "cluster", "clustered", "clusterstatus", "collection", "columns", "comment", "compact", "compactions", "compute", "concatenate", "continue", "data", "day", "databases", "datetime", "dbproperties", "deferred", "defined", "delimited", "dependency", "desc", "directories", "directory", "disable", "distribute", "enable", "escaped", "exclusive", "explain", "export", "fields", "file", "fileformat", "first", "format", "formatted", "functions", "hold_ddltime", "hour", "idxproperties", "ignore", "index", "indexes", "inpath", "inputdriver", "inputformat", "items", "jar", "keys", "key_type", "last", "limit", "offset", "lines", "load", "location", "lock", "locks", "logical", "long", "mapjoin", "materialized", "metadata", "minus", "minute", "month", "msck", "noscan", "no_drop", "nulls", "offline", "option", "outputdriver", "outputformat", "overwrite", "owner", "partitioned", "partitions", "plus", "pretty", "principals", "protection", "purge", "read", "readonly", "rebuild", "recordreader", "recordwriter", "reload", "rename", "repair", "replace", "replication", "restrict", "rewrite", "role", "roles", "schemas", "second", "serde", "serdeproperties", "server", "sets", "shared", "show", "show_database", "skewed", "sort", "sorted", "ssl", "statistics", "stored", "streamtable", "string", "struct", "tables", "tblproperties", "temporary", "terminated", "tinyint", "touch", "transactions", "unarchive", "undo", "uniontype", "unlock", "unset", "unsigned", "uri", "use", "utc", "utctimestamp", "view", "while", "year", "work", "transaction", "write", "isolation", "level", "snapshot", "autocommit", "all", "alter", "array", "as", "authorization", "between", "bigint", "binary", "boolean", "both", "by", "create", "cube", "current_date", "current_timestamp", "cursor", "date", "decimal", "delete", "describe", "double", "drop", "exists", "external", "false", "fetch", "float", "for", "grant", "group", "grouping", "import", "in", "insert", "int", "into", "is", "lateral", "like", "local", "none", "null", "of", "order", "out", "outer", "partition", "percent", "procedure", "range", "reads", "revoke", "rollup", "row", "rows", "set", "smallint", "table", "timestamp", "to", "trigger", "true", "truncate", "update", "user", "using", "values", "with", "regexp", "rlike", "bigint", "binary", "boolean", "current_date", "current_timestamp", "date", "double", "float", "int", "smallint", "timestamp", "at"});
    private final Seq<String> hiveStrictNonReservedKeyword = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"anti", "full", "inner", "left", "semi", "right", "natural", "union", "intersect", "except", "database", "on", "join", "cross", "select", "from", "where", "having", "from", "to", "table", "with", "not"}));

    public String[] hiveNonReservedKeyword() {
        return this.hiveNonReservedKeyword;
    }

    public Seq<String> hiveStrictNonReservedKeyword() {
        return this.hiveStrictNonReservedKeyword;
    }

    public TableIdentifierParserSuite() {
        this.test("table identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableIdentifierParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(TableIdentifier$.MODULE$.apply("q"));
                TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("q");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new TableIdentifier("q", Option$.MODULE$.apply((Object)"d")));
                TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("d.q");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "d.q.g", "t:", "${some.var.x}", "tab:1"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final ParseException apply(String identifier) {
                        return (ParseException)this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, identifier){
                            public static final long serialVersionUID = 0L;
                            private final String identifier$1;

                            public final TableIdentifier apply() {
                                return CatalystSqlParser$.MODULE$.parseTableIdentifier(this.identifier$1);
                            }
                            {
                                this.identifier$1 = identifier$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(ParseException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TableIdentifierParserSuite org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("table identifier - strict keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableIdentifierParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.hiveStrictNonReservedKeyword().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(String keyword) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
                        TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(keyword);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
                        TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyword})));
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().convertToEqualizer(new TableIdentifier(keyword, Option$.MODULE$.apply((Object)"db")));
                        TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db.`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyword})));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TableIdentifierParserSuite org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("table identifier - non reserved keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableIdentifierParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])this.$outer.hiveNonReservedKeyword()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(String nonReserved) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().convertToEqualizer(TableIdentifier$.MODULE$.apply(nonReserved));
                        TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(nonReserved);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TableIdentifierParserSuite org$apache$spark$sql$catalyst$parser$TableIdentifierParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-17364 table identifier - contains number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableIdentifierParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TableIdentifier $org_scalatest_assert_macro_left = CatalystSqlParser$.MODULE$.parseTableIdentifier("123_");
                TableIdentifier $org_scalatest_assert_macro_right = TableIdentifier$.MODULE$.apply("123_");
                TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
                TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TableIdentifier $org_scalatest_assert_macro_left2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("1a.123_");
                TableIdentifier $org_scalatest_assert_macro_right2 = new TableIdentifier("123_", (Option)new Some((Object)"1a"));
                TableIdentifier tableIdentifier3 = $org_scalatest_assert_macro_left2;
                TableIdentifier tableIdentifier4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(tableIdentifier3 != null ? !tableIdentifier3.equals(tableIdentifier4) : tableIdentifier4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TableIdentifier $org_scalatest_assert_macro_left3 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123A");
                TableIdentifier $org_scalatest_assert_macro_right3 = new TableIdentifier("123A", (Option)new Some((Object)"a"));
                TableIdentifier tableIdentifier5 = $org_scalatest_assert_macro_left3;
                TableIdentifier tableIdentifier6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(tableIdentifier5 != null ? !tableIdentifier5.equals(tableIdentifier6) : tableIdentifier6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TableIdentifier $org_scalatest_assert_macro_left4 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123E3_LIST");
                TableIdentifier $org_scalatest_assert_macro_right4 = new TableIdentifier("123E3_LIST", (Option)new Some((Object)"a"));
                TableIdentifier tableIdentifier7 = $org_scalatest_assert_macro_left4;
                TableIdentifier tableIdentifier8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(tableIdentifier7 != null ? !tableIdentifier7.equals(tableIdentifier8) : tableIdentifier8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TableIdentifier $org_scalatest_assert_macro_left5 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123D_LIST");
                TableIdentifier $org_scalatest_assert_macro_right5 = new TableIdentifier("123D_LIST", (Option)new Some((Object)"a"));
                TableIdentifier tableIdentifier9 = $org_scalatest_assert_macro_left5;
                TableIdentifier tableIdentifier10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(tableIdentifier9 != null ? !tableIdentifier9.equals(tableIdentifier10) : tableIdentifier10 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TableIdentifier $org_scalatest_assert_macro_left6 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123BD_LIST");
                TableIdentifier $org_scalatest_assert_macro_right6 = new TableIdentifier("123BD_LIST", (Option)new Some((Object)"a"));
                TableIdentifier tableIdentifier11 = $org_scalatest_assert_macro_left6;
                TableIdentifier tableIdentifier12 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(tableIdentifier11 != null ? !tableIdentifier11.equals(tableIdentifier12) : tableIdentifier12 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-17832 table identifier - contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableIdentifierParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TableIdentifier complexName = new TableIdentifier("`weird`table`name", (Option)new Some((Object)"`d`b`1"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(complexName);
                TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("```d``b``1`.```weird``table``name`");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(complexName);
                TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName.quotedString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, complexName){
                    public static final long serialVersionUID = 0L;
                    private final TableIdentifier complexName$1;

                    public final TableIdentifier apply() {
                        return CatalystSqlParser$.MODULE$.parseTableIdentifier(this.complexName$1.unquotedString());
                    }
                    {
                        this.complexName$1 = complexName$1;
                    }
                }, ManifestFactory$.MODULE$.classType(ParseException.class));
                TableIdentifier complexName2 = new TableIdentifier("x``y", (Option)new Some((Object)"d``b"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(complexName2);
                TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName2.quotedString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

