/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprId$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PredicateSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTest$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation$;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)3Q!\u0001\u0002\u0002\u0002=\u0011\u0001\u0002\u00157b]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\u0001\u001d7b]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0011D\u0006\u0002\u0010!J,G-[2bi\u0016DU\r\u001c9fe\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\u0006A\u0001!\t\"I\u0001\u0011]>\u0014X.\u00197ju\u0016,\u0005\u0010\u001d:JIN$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0012\u0011a\u00027pO&\u001c\u0017\r\\\u0005\u0003O\u0011\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\")\u0011f\ba\u0001E\u0005!\u0001\u000f\\1o\u0011\u0015Y\u0003\u0001\"\u0003-\u00035qwN]7bY&TX\r\u00157b]R\u0011!%\f\u0005\u0006S)\u0002\rA\t\u0005\u0006_\u0001!I\u0001M\u0001\re\u0016<(/\u001b;f\u000bF,\u0018\r\u001c\u000b\u0003cQ\u0002\"!\u0006\u001a\n\u0005M2\"AC#yaJ,7o]5p]\")QG\fa\u0001c\u0005I1m\u001c8eSRLwN\u001c\u0005\u0006o\u0001!\t\u0002O\u0001\rG>l\u0007/\u0019:f!2\fgn\u001d\u000b\u0004s}\n\u0005C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$\u0001B+oSRDQ\u0001\u0011\u001cA\u0002\t\nQ\u0001\u001d7b]FBQA\u0011\u001cA\u0002\t\nQ\u0001\u001d7b]JBQ\u0001\u0012\u0001\u0005\u0012\u0015\u000b!cY8na\u0006\u0014X-\u0012=qe\u0016\u001c8/[8ogR\u0019\u0011H\u0012%\t\u000b\u001d\u001b\u0005\u0019A\u0019\u0002\u0005\u0015\f\u0004\"B%D\u0001\u0004\t\u0014AA33\u0001")
public abstract class PlanTest
extends SparkFunSuite
implements PredicateHelper {
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return (LogicalPlan)plan.transformAllExpressions((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ScalarSubquery) {
                    ScalarSubquery scalarSubquery = (ScalarSubquery)A1;
                    ExprId x$7 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$8 = scalarSubquery.copy$default$1();
                    Seq x$9 = scalarSubquery.copy$default$2();
                    object = scalarSubquery.copy(x$8, x$9, x$7);
                } else if (A1 instanceof Exists) {
                    Exists exists2 = (Exists)A1;
                    ExprId x$10 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$11 = exists2.copy$default$1();
                    object = exists2.copy(x$11, x$10);
                } else if (A1 instanceof ListQuery) {
                    ListQuery listQuery = (ListQuery)A1;
                    ExprId x$12 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$13 = listQuery.copy$default$1();
                    object = listQuery.copy(x$13, x$12);
                } else if (A1 instanceof PredicateSubquery) {
                    PredicateSubquery predicateSubquery = (PredicateSubquery)A1;
                    ExprId x$14 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$15 = predicateSubquery.copy$default$1();
                    Seq x$16 = predicateSubquery.copy$default$2();
                    boolean x$17 = predicateSubquery.copy$default$3();
                    object = predicateSubquery.copy(x$15, x$16, x$17, x$14);
                } else if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    String x$18 = attributeReference.name();
                    DataType x$19 = attributeReference.dataType();
                    boolean x$20 = attributeReference.nullable();
                    Metadata x$21 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$22 = ExprId$.MODULE$.apply(0L);
                    Option x$23 = AttributeReference$.MODULE$.apply$default$6(x$18, x$19, x$20, x$21);
                    Boolean x$24 = AttributeReference$.MODULE$.apply$default$7(x$18, x$19, x$20, x$21);
                    object = new AttributeReference(x$18, x$19, x$20, x$21, x$22, x$23, x$24);
                } else if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    Expression x$25 = alias.child();
                    String x$26 = alias.name();
                    ExprId x$27 = ExprId$.MODULE$.apply(0L);
                    Option x$28 = Alias$.MODULE$.apply$default$4(x$25, x$26);
                    Option x$29 = Alias$.MODULE$.apply$default$5(x$25, x$26);
                    Boolean x$30 = Alias$.MODULE$.apply$default$6(x$25, x$26);
                    object = new Alias(x$25, x$26, x$27, x$28, x$29, x$30);
                } else if (A1 instanceof AggregateExpression) {
                    AggregateExpression aggregateExpression = (AggregateExpression)A1;
                    ExprId x$31 = ExprId$.MODULE$.apply(0L);
                    AggregateFunction x$32 = aggregateExpression.copy$default$1();
                    AggregateMode x$33 = aggregateExpression.copy$default$2();
                    boolean x$34 = aggregateExpression.copy$default$3();
                    object = aggregateExpression.copy(x$32, x$33, x$34, x$31);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof ScalarSubquery ? true : (expression instanceof Exists ? true : (expression instanceof ListQuery ? true : (expression instanceof PredicateSubquery ? true : (expression instanceof AttributeReference ? true : (expression instanceof Alias ? true : expression instanceof AggregateExpression)))));
                return bl;
            }
        });
    }

    private LogicalPlan normalizePlan(LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Filter) {
                    Filter filter = (Filter)A1;
                    Expression condition = filter.condition();
                    LogicalPlan child = filter.child();
                    if (condition != null) {
                        Expression expression = condition;
                        if (child != null) {
                            LogicalPlan logicalPlan = child;
                            object = new Filter((Expression)((TraversableOnce)((SeqLike)this.$outer.splitConjunctivePredicates(expression).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$normalizePlan$1 $outer;

                                public final Expression apply(Expression x$1) {
                                    return this.$outer.org$apache$spark$sql$catalyst$plans$PlanTest$$anonfun$$$outer().org$apache$spark$sql$catalyst$plans$PlanTest$$rewriteEqual(x$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Expression x$2) {
                                    return x$2.hashCode();
                                }
                            }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)And$.MODULE$), logicalPlan);
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof Sample) {
                    Sample sample = (Sample)A1;
                    long x$35 = 0L;
                    double x$36 = sample.copy$default$1();
                    double x$37 = sample.copy$default$2();
                    boolean x$38 = sample.copy$default$3();
                    LogicalPlan x$39 = sample.copy$default$5();
                    Boolean x$40 = Predef$.MODULE$.boolean2Boolean(true);
                    object = sample.copy(x$36, x$37, x$38, x$35, x$39, x$40);
                    return (B1)object;
                }
                if (A1 instanceof Join) {
                    Join join = (Join)A1;
                    LogicalPlan left = join.left();
                    LogicalPlan right = join.right();
                    JoinType joinType = join.joinType();
                    Option condition = join.condition();
                    if (condition.isDefined()) {
                        Expression newCondition = (Expression)((TraversableOnce)((SeqLike)this.$outer.splitConjunctivePredicates((Expression)condition.get()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$normalizePlan$1 $outer;

                            public final Expression apply(Expression x$3) {
                                return this.$outer.org$apache$spark$sql$catalyst$plans$PlanTest$$anonfun$$$outer().org$apache$spark$sql$catalyst$plans$PlanTest$$rewriteEqual(x$3);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Expression x$4) {
                                return x$4.hashCode();
                            }
                        }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)And$.MODULE$);
                        object = new Join(left, right, joinType, (Option)new Some((Object)newCondition));
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan = x2;
                if (logicalPlan instanceof Filter) {
                    Filter filter = (Filter)logicalPlan;
                    Expression condition = filter.condition();
                    LogicalPlan child = filter.child();
                    if (condition != null && child != null) {
                        return true;
                    }
                }
                if (logicalPlan instanceof Sample) {
                    return true;
                }
                if (!(logicalPlan instanceof Join)) return false;
                Join join = (Join)logicalPlan;
                Option condition = join.condition();
                if (!condition.isDefined()) return false;
                return true;
            }

            public /* synthetic */ PlanTest org$apache$spark$sql$catalyst$plans$PlanTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression org$apache$spark$sql$catalyst$plans$PlanTest$$rewriteEqual(Expression condition) {
        Expression expression = condition;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression l = equalTo.left();
            Expression r = equalTo.right();
            if (l != null) {
                Expression expression2 = l;
                if (r != null) {
                    Expression expression3 = r;
                    return (Expression)((TraversableOnce)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression2, expression3}))).sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Expression x$5) {
                            return x$5.hashCode();
                        }
                    }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)EqualTo$.MODULE$);
                }
            }
        }
        if (!(expression instanceof EqualNullSafe)) return condition;
        EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
        Expression l = equalNullSafe.left();
        Expression r = equalNullSafe.right();
        if (l == null) return condition;
        Expression expression4 = l;
        if (r == null) return condition;
        Expression expression5 = r;
        return (Expression)((TraversableOnce)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression4, expression5}))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Expression x$6) {
                return x$6.hashCode();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)EqualNullSafe$.MODULE$);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2) {
        LogicalPlan normalized1 = this.normalizePlan(this.normalizeExprIds(plan1));
        LogicalPlan normalized2 = this.normalizePlan(this.normalizeExprIds(plan2));
        LogicalPlan logicalPlan = normalized1;
        LogicalPlan logicalPlan2 = normalized2;
        if (!(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null)) {
            return;
        }
        throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |== FAIL: Plans do not match ===\n          |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.sideBySide(normalized1.treeString(), normalized2.treeString()).mkString("\n")})))).stripMargin());
    }

    public void compareExpressions(Expression e1, Expression e2) {
        this.comparePlans((LogicalPlan)new Filter(e1, (LogicalPlan)OneRowRelation$.MODULE$), (LogicalPlan)new Filter(e2, (LogicalPlan)OneRowRelation$.MODULE$));
    }

    public PlanTest() {
        PredicateHelper.class.$init$((PredicateHelper)this);
    }
}

