/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$20$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$21$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$22$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$22$$anonfun$apply$mcV$sp$9$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u001d2A!\u0001\u0002\u0001\u001f\t\u0011B)\u0019;f)&lW-\u0016;jYN\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAaA\u0007\u0001!\n\u0013Y\u0012\u0001D4fi&sW\u000bV\"ECf\u001cHC\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0006Ge\u0001\r\u0001J\u0001\ni&lWm\u001d;b[B\u0004\"!H\u0013\n\u0005\u0019r\"\u0001\u0002'p]\u001e\u0004")
public class DateTimeUtilsSuite
extends SparkFunSuite {
    public int org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(long timestamp) {
        TimeZone tz = TimeZone.getDefault();
        return (int)((timestamp + (long)tz.getOffset(timestamp)) / 86400000L);
    }

    public DateTimeUtilsSuite() {
        this.test("timestamp and us", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                now.setNanos(1000);
                long ns = DateTimeUtils$.MODULE$.fromJavaTimestamp(now);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)(ns % 1000000L)));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(ns));
                Timestamp $org_scalatest_assert_macro_right2 = now;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{-111111111111L, -1L, 0L, 1L, 111111111111L})).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(long t) {
                        this.apply$mcVJ$sp(t);
                    }

                    public void apply$mcVJ$sp(long t) {
                        Timestamp ts = DateTimeUtils$.MODULE$.toJavaTimestamp(t);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
                        long $org_scalatest_assert_macro_right = t;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
                        Timestamp $org_scalatest_assert_macro_right2 = ts;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("us and julian day", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(0L);
                if (tuple2 != null) {
                    Tuple2.mcIJ.sp sp2;
                    int d = tuple2._1$mcI$sp();
                    long ns = tuple2._2$mcJ$sp();
                    Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(d, ns);
                    int d2 = sp3._1$mcI$sp();
                    long ns2 = sp3._2$mcJ$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)d2));
                    int $org_scalatest_assert_macro_right = 2440588;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)ns2));
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.fromJulianDay(d2, ns2);
                    long $org_scalatest_assert_macro_right3 = 0L;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{Timestamp.valueOf("2015-06-11 10:10:10.100"), Timestamp.valueOf("2015-06-11 20:10:10.100"), Timestamp.valueOf("1900-06-11 20:10:10.100")}))).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;

                        public final void apply(Timestamp t) {
                            Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
                            if (tuple2 != null) {
                                long ns;
                                Tuple2.mcIJ.sp sp2;
                                int d = tuple2._1$mcI$sp();
                                long ns2 = tuple2._2$mcJ$sp();
                                Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(d, ns2);
                                int d2 = sp3._1$mcI$sp();
                                long $org_scalatest_assert_macro_left = ns = sp3._2$mcJ$sp();
                                int $org_scalatest_assert_macro_right = 0;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                Timestamp t1 = DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromJulianDay(d2, ns));
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(t.equals(t1), "t.equals(t1)");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-6785: java date conversion before and after epoch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                this.checkFromToJavaDate$1(new Date(100L));
                this.checkFromToJavaDate$1(Date.valueOf("1970-01-01"));
                this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:00").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:00 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:01").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:01 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1969-12-31 23:59:59").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1969-12-31 23:59:59 UTC").getTime()));
                this.checkFromToJavaDate$1(Date.valueOf("1969-01-01"));
                this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:00").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:00 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:01").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:01 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1989-11-09 11:59:59").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1989-11-09 19:59:59 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1776-07-04 10:30:00").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1776-07-04 18:30:00 UTC").getTime()));
            }

            private final void checkFromToJavaDate$1(Date d1) {
                Date d2 = DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.fromJavaDate(d1));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(d2.toString());
                String $org_scalatest_assert_macro_right = d1.toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("string to date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 0, 28, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-01-28")).get());
                int $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2015, 0, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015")).get());
                int $org_scalatest_assert_macro_right2 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                c.set(1, 0, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"0001")).get());
                int $org_scalatest_assert_macro_right3 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                c = Calendar.getInstance();
                c.set(2015, 2, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03")).get());
                int $org_scalatest_assert_macro_right4 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18")).get());
                int $org_scalatest_assert_macro_right5 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18 ")).get());
                int $org_scalatest_assert_macro_right6 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18 123142")).get());
                int $org_scalatest_assert_macro_right7 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18T123123")).get());
                int $org_scalatest_assert_macro_right8 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18T")).get());
                int $org_scalatest_assert_macro_right9 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Option $org_scalatest_assert_macro_left10 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18X"));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Option $org_scalatest_assert_macro_left11 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015/03/18"));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Option $org_scalatest_assert_macro_left12 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015.03.18"));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Option $org_scalatest_assert_macro_left13 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"20150318"));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "isEmpty", $org_scalatest_assert_macro_left13.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Option $org_scalatest_assert_macro_left14 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-031-8"));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left14, "isEmpty", $org_scalatest_assert_macro_left14.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Option $org_scalatest_assert_macro_left15 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"02015-03-18"));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left15, "isEmpty", $org_scalatest_assert_macro_left15.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Option $org_scalatest_assert_macro_left16 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"015-03-18"));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left16, "isEmpty", $org_scalatest_assert_macro_left16.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                Option $org_scalatest_assert_macro_left17 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"015"));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left17, "isEmpty", $org_scalatest_assert_macro_left17.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                Option $org_scalatest_assert_macro_left18 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"02015"));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left18, "isEmpty", $org_scalatest_assert_macro_left18.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("string to time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                c.set(14, 0);
                c.set(1900, 0, 1, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("1900-01-01T00:00:00GMT-00:00"));
                java.util.Date $org_scalatest_assert_macro_right = c.getTime();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2000, 11, 30, 10, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("2000-12-30T10:00:00Z"));
                java.util.Date $org_scalatest_assert_macro_right2 = c.getTime();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                c.setTimeZone(TimeZone.getTimeZone("GMT-04:00"));
                c.set(14, 0);
                c.set(1900, 0, 1, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("1900-01-01T00:00:00-04:00"));
                java.util.Date $org_scalatest_assert_macro_right3 = c.getTime();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                c.set(1900, 0, 1, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("1900-01-01T00:00:00GMT-04:00"));
                java.util.Date $org_scalatest_assert_macro_right4 = c.getTime();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                c.setTimeZone(TimeZone.getDefault());
                c.set(14, 0);
                c.set(2000, 11, 30, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("2000-12-30"));
                Date $org_scalatest_assert_macro_right5 = new Date(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                c.set(2000, 11, 30, 10, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("2000-12-30 10:00:00"));
                Timestamp $org_scalatest_assert_macro_right6 = new Timestamp(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("string to timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(1969, 11, 31, 16, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"1969-12-31 16:00:00")).get());
                long $org_scalatest_assert_macro_right = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(1, 0, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"0001")).get());
                long $org_scalatest_assert_macro_right2 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                c = Calendar.getInstance();
                c.set(2015, 2, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03")).get());
                long $org_scalatest_assert_macro_right3 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18")).get());
                long $org_scalatest_assert_macro_right4 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18 ")).get());
                long $org_scalatest_assert_macro_right5 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T")).get());
                long $org_scalatest_assert_macro_right6 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                c = Calendar.getInstance();
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18 12:03:17")).get());
                long $org_scalatest_assert_macro_right7 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17")).get());
                long $org_scalatest_assert_macro_right8 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT-13:53"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17-13:53")).get());
                long $org_scalatest_assert_macro_right9 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17Z")).get());
                long $org_scalatest_assert_macro_right10 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18 12:03:17Z")).get());
                long $org_scalatest_assert_macro_right11 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT-01:00"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17-1:0")).get());
                long $org_scalatest_assert_macro_right12 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17-01:00")).get());
                long $org_scalatest_assert_macro_right13 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17+07:30")).get());
                long $org_scalatest_assert_macro_right14 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:03"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17+07:03")).get());
                long $org_scalatest_assert_macro_right15 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                c = Calendar.getInstance();
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18 12:03:17.123")).get());
                long $org_scalatest_assert_macro_right16 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123")).get());
                long $org_scalatest_assert_macro_right17 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 456);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.456Z")).get());
                long $org_scalatest_assert_macro_right18 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18 12:03:17.456Z")).get());
                long $org_scalatest_assert_macro_right19 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT-01:00"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123-1:0")).get());
                long $org_scalatest_assert_macro_right20 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123-01:00")).get());
                long $org_scalatest_assert_macro_right21 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123+07:30")).get());
                long $org_scalatest_assert_macro_right22 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right22), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123+07:30")).get());
                long $org_scalatest_assert_macro_right23 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right23), $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right23), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123121+7:30")).get());
                long $org_scalatest_assert_macro_right24 = c.getTimeInMillis() * 1000L + 121L;
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right24), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left25 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.12312+7:30")).get());
                long $org_scalatest_assert_macro_right25 = c.getTimeInMillis() * 1000L + 120L;
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right25), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"");
                c = Calendar.getInstance();
                c.set(11, 18);
                c.set(12, 12);
                c.set(13, 15);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left26 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"18:12:15")).get());
                long $org_scalatest_assert_macro_right26 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right26), $org_scalatest_assert_macro_left26.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right26), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(11, 18);
                c.set(12, 12);
                c.set(13, 15);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left27 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"T18:12:15.12312+7:30")).get());
                long $org_scalatest_assert_macro_right27 = c.getTimeInMillis() * 1000L + 120L;
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left27, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right27), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                c.set(11, 18);
                c.set(12, 12);
                c.set(13, 15);
                c.set(14, 123);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left28 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"18:12:15.12312+7:30")).get());
                long $org_scalatest_assert_macro_right28 = c.getTimeInMillis() * 1000L + 120L;
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left28, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right28), $org_scalatest_assert_macro_left28.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right28), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"");
                c = Calendar.getInstance();
                c.set(2011, 4, 6, 7, 8, 9);
                c.set(14, 100);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left29 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2011-05-06 07:08:09.1000")).get());
                long $org_scalatest_assert_macro_right29 = c.getTimeInMillis() * 1000L;
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left29, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right29), $org_scalatest_assert_macro_left29.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right29), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"");
                Option $org_scalatest_assert_macro_left30 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"238"));
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left30, "isEmpty", $org_scalatest_assert_macro_left30.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"");
                Option $org_scalatest_assert_macro_left31 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"00238"));
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left31, "isEmpty", $org_scalatest_assert_macro_left31.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"");
                Option $org_scalatest_assert_macro_left32 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18 123142"));
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left32, "isEmpty", $org_scalatest_assert_macro_left32.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"");
                Option $org_scalatest_assert_macro_left33 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T123123"));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left33, "isEmpty", $org_scalatest_assert_macro_left33.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"");
                Option $org_scalatest_assert_macro_left34 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18X"));
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left34, "isEmpty", $org_scalatest_assert_macro_left34.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"");
                Option $org_scalatest_assert_macro_left35 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015/03/18"));
                Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left35, "isEmpty", $org_scalatest_assert_macro_left35.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"");
                Option $org_scalatest_assert_macro_left36 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015.03.18"));
                Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left36, "isEmpty", $org_scalatest_assert_macro_left36.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"");
                Option $org_scalatest_assert_macro_left37 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"20150318"));
                Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left37, "isEmpty", $org_scalatest_assert_macro_left37.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"");
                Option $org_scalatest_assert_macro_left38 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-031-8"));
                Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left38, "isEmpty", $org_scalatest_assert_macro_left38.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"");
                Option $org_scalatest_assert_macro_left39 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"02015-01-18"));
                Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left39, "isEmpty", $org_scalatest_assert_macro_left39.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"");
                Option $org_scalatest_assert_macro_left40 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"015-01-18"));
                Bool $org_scalatest_assert_macro_expr40 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left40, "isEmpty", $org_scalatest_assert_macro_left40.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr40, (Object)"");
                Option $org_scalatest_assert_macro_left41 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03.17-20:0"));
                Bool $org_scalatest_assert_macro_expr41 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left41, "isEmpty", $org_scalatest_assert_macro_left41.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr41, (Object)"");
                Option $org_scalatest_assert_macro_left42 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03.17-0:70"));
                Bool $org_scalatest_assert_macro_expr42 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left42, "isEmpty", $org_scalatest_assert_macro_left42.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr42, (Object)"");
                Option $org_scalatest_assert_macro_left43 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03.17-1:0:0"));
                Bool $org_scalatest_assert_macro_expr43 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left43, "isEmpty", $org_scalatest_assert_macro_left43.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr43, (Object)"");
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
                c.set(2015, 2, 18, 12, 3, 17);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left44 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-18T12:03:17.123456789+0:00")).get());
                long $org_scalatest_assert_macro_right30 = c.getTimeInMillis() * 1000L + 123456L;
                Bool $org_scalatest_assert_macro_expr44 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left44, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right30), $org_scalatest_assert_macro_left44.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right30), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr44, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-15379: special invalid date string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-02-29 00:00:00"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Option $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-04-31 00:00:00"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-02-29"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-04-31"));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-02-29 00:00:00"));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Option $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-31 00:00:00"));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Option $org_scalatest_assert_macro_left7 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-02-29"));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Option $org_scalatest_assert_macro_left8 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-31"));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("hours", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 13, 2, 11);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(c.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right = 13;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2015, 12, 8, 2, 7, 9);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(c.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("minutes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 13, 2, 11);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2015, 2, 8, 2, 7, 9);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right2 = 7;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("seconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 13, 2, 11);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(c.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right = 11;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2015, 2, 8, 2, 7, 9);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(c.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right2 = 9;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("hours / minutes / seconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{Timestamp.valueOf("2015-06-11 10:12:35.789"), Timestamp.valueOf("2015-06-11 20:13:40.789"), Timestamp.valueOf("1900-06-11 12:14:50.789"), Timestamp.valueOf("1700-02-28 12:14:50.123456")}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(Timestamp t) {
                        long us = DateTimeUtils$.MODULE$.fromJavaTimestamp(t);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(us));
                        Timestamp $org_scalatest_assert_macro_right = t;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get day in year", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 77;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2012, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 78;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get year", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 2015;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2012, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 2012;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get quarter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2012, 11, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get month", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2012, 11, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 12;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get day of month", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 18;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c.set(2012, 11, 24, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 24;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("date add months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c1 = Calendar.getInstance();
                c1.set(1997, 1, 28, 10, 30, 0);
                int days1 = DateTimeUtils$.MODULE$.millisToDays(c1.getTimeInMillis());
                Calendar c2 = Calendar.getInstance();
                c2.set(2000, 1, 29);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(days1, 36)));
                int $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.millisToDays(c2.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c2.set(1996, 0, 31);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(days1, -13)));
                int $org_scalatest_assert_macro_right2 = DateTimeUtils$.MODULE$.millisToDays(c2.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("timestamp add months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c1 = Calendar.getInstance();
                c1.set(1997, 1, 28, 10, 30, 0);
                c1.set(14, 0);
                long ts1 = c1.getTimeInMillis() * 1000L;
                Calendar c2 = Calendar.getInstance();
                c2.set(2000, 1, 29, 10, 30, 0);
                c2.set(14, 123);
                long ts2 = c2.getTimeInMillis() * 1000L;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 36, 123000L)));
                long $org_scalatest_assert_macro_right = ts2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("monthsBetween", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c1 = Calendar.getInstance();
                c1.set(1997, 1, 28, 10, 30, 0);
                Calendar c2 = Calendar.getInstance();
                c2.set(1996, 9, 30, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c1.getTimeInMillis() * 1000L, c2.getTimeInMillis() * 1000L)));
                double $org_scalatest_assert_macro_right = 3.94959677;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                c2.set(2000, 1, 28, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c1.getTimeInMillis() * 1000L, c2.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right2 = -36;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                c2.set(2000, 1, 29, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c1.getTimeInMillis() * 1000L, c2.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right3 = -36;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                c2.set(1996, 2, 31, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c1.getTimeInMillis() * 1000L, c2.getTimeInMillis() * 1000L)));
                int $org_scalatest_assert_macro_right4 = 11;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("from UTC timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(TimeZone tz) {
                        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$20$$anonfun$apply$mcV$sp$7 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "JST", "2011-12-25 18:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "PST", "2011-12-25 01:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "Asia/Shanghai", "2011-12-25 17:00:00.123456");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$20 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(TimeZone.getTimeZone("PST"), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-03-13 09:59:59.0", "PST", "2016-03-13 01:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-03-13 10:00:00.0", "PST", "2016-03-13 03:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-11-06 08:59:59.0", "PST", "2016-11-06 01:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-11-06 09:00:00.0", "PST", "2016-11-06 01:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-11-06 10:00:00.0", "PST", "2016-11-06 02:00:00.0");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1(String utc, String tz, String expected) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("to UTC timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final void apply(TimeZone tz) {
                        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$21$$anonfun$apply$mcV$sp$8 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 18:00:00.123456", "JST", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 01:00:00.123456", "PST", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 17:00:00.123456", "Asia/Shanghai", "2011-12-25 09:00:00.123456");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$21 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(TimeZone.getTimeZone("PST"), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-03-13 01:59:59", "PST", "2016-03-13 09:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-03-13 02:00:00", "PST", "2016-03-13 10:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-03-13 03:00:00", "PST", "2016-03-13 10:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 00:59:59", "PST", "2016-11-06 07:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 01:00:00", "PST", "2016-11-06 09:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 01:59:59", "PST", "2016-11-06 09:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 02:00:00", "PST", "2016-11-06 10:00:00.0");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2(String utc, String tz, String expected) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.toUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("daysToMillis and millisToDays", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map skipped_days = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Kwajalein"), (Object)BoxesRunTime.boxToInteger((int)8632)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Pacific/Apia"), (Object)BoxesRunTime.boxToInteger((int)15338)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Pacific/Enderbury"), (Object)BoxesRunTime.boxToInteger((int)9131)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Pacific/Fakaofo"), (Object)BoxesRunTime.boxToInteger((int)15338)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Pacific/Kiritimati"), (Object)BoxesRunTime.boxToInteger((int)9131)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Pacific/Kwajalein"), (Object)BoxesRunTime.boxToInteger((int)8632)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"MIT"), (Object)BoxesRunTime.boxToInteger((int)15338))}));
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this, skipped_days){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$22 $outer;
                    public final Map skipped_days$1;

                    public final void apply(TimeZone tz) {
                        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, new Serializable(this, tz){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$22$$anonfun$apply$mcV$sp$9 $outer;
                            public final TimeZone tz$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                int skipped = BoxesRunTime.unboxToInt((Object)this.$outer.skipped_days$1.getOrElse((Object)this.tz$1.getID(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return Integer.MIN_VALUE;
                                    }
                                }));
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-20000), 20000).foreach$mVc$sp((Function1)new Serializable(this, skipped){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$22$$anonfun$apply$mcV$sp$9$$anonfun$apply$3 $outer;
                                    private final int skipped$1;

                                    public final void apply(int d) {
                                        this.apply$mcVI$sp(d);
                                    }

                                    public void apply$mcVI$sp(int d) {
                                        if (d != this.skipped$1) {
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.daysToMillis(d))));
                                            int $org_scalatest_assert_macro_right = d;
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Round trip of ", " did not work in tz ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)d), this.$outer.tz$1})));
                                        }
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.skipped$1 = skipped$1;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$22$$anonfun$apply$mcV$sp$9 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.tz$1 = tz$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$22 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.skipped_days$1 = skipped_days$1;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

